# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xsomething import XSomething
from xattribute import XAttribute
from xtypes import XString
from xtypes import XList
from xtypes import XInstance
from xtypes import XType

class XMethod(XSomething):
    
    __init__xattributes__ = [
        XAttribute(name="name", xtype=XString(len_min=1), mode="r"),
        XAttribute(name="in_xattributes", xtype=XList(sequence=XInstance(XAttribute)), default_value=None, mode="r"),
        XAttribute(name="out_xtype", xtype=XInstance(XType), default_value=None, mode="r"),
        XAttribute(name="out_xattributes", xtype=XList(sequence=XInstance(XAttribute)), default_value=None, mode="r"),
        XAttribute(name="popup", xtype=XString(into=['no', 'single', 'multi']), default_value=None, mode="r"),
        ]
    
    def __init__(self, *args, **kwargs):
        out_xtype = self.out_xtype
        out_xattributes = self.out_xattributes
        test = ( out_xtype is not None ) and ( out_xattributes is not None )
        if test:
            msg  = '\n\n'
            msg += 'out_xtype and out_xattributes must not be defined both in XMethod instances\n'
            raise ValueError(msg)
        return
    
    pass
