# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xmetaclass import XMetaClass

class XObject(object):
    
    __metaclass__ = XMetaClass
    
    # WHY ???
    # Because I want to intercept the __init__
    # of XObject in case of a class A(XObject)
    # which not implement __init__
    
    def __init__(self, *args, **kwargs):
        return
    
    def customPythonScript(self, text):
        return text
    
    def xemit(self, signal, *args, **kwargs):
        try:
            connections = self.__connections__
        except AttributeError:
            return
        try:
            targets = connections[signal]
        except KeyError:
            return
        for target in targets:
            if isinstance(target, list):
                obj, attr = target
                if obj == "self":
                    obj = self
                    pass
                target = getattr(obj, attr)
                pass
            target(*args, **kwargs)
            pass
        return
    
    def xconnect(self, sender, signal, target):
        if sender is not self:
            sender.xconnect(sender, signal, target)
            return
        #
        # E.A. : There is a problem at pickle when
        # target is an instance of XInterceptor.
        # Thus, put the target as a list [obj, attr]
        # and get the real target back in xemit
        #
        from xinterceptor import XInterceptor
        if isinstance(target, XInterceptor):
            obj = target.obj
            #
            # E.A. : A bug in pickle with python 2.2.x
            # if target contains self, a pickle load
            # create another instance !!!
            #
            if obj is self:
                obj = "self"
                pass
            if obj:
                name = target.name
                target = [obj, name]
                pass
            pass
        #
        # Same for unbound methods ...
        # 
        from inspect import ismethod
        if ismethod(target):
            obj = target.im_self
            if obj:
                name = target.__name__
                target = [obj, name]
                pass
            pass
        #
        try:
            connections = self.__connections__
        except AttributeError:
            self.__connections__ = {}
            connections = self.__connections__
            pass
        try:
            targets = connections[signal]
        except KeyError:
            connections[signal] = []
            targets = connections[signal]
            pass
        if target not in targets:
            targets.append(target)
            pass
        return
    
    def xdisconnect(self, sender, signal, target):
        if sender is not self:
            sender.xdisconnect(sender, signal, target)
            return
        connections = self.__connections__
        targets = connections[signal]
        targets.remove(target)
        return
    
    pass

from xmetaclass import __developper__dict__

keys = __developper__dict__.keys()
keys.remove('__xnamedobject__')
keys.insert(0, '__xnamedobject__')

for key in keys:
    value = __developper__dict__[key]
    setattr(XObject, key, value)
    pass

from xmetaclass import resetXClasses

resetXClasses()
