# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xutilities import message
from XDATA_CORBA__POA import XDATA_Component
from SALOME_ComponentPy import SALOME_ComponentPy_i
import SALOMEDS #SRN: Aug 24, 2004: Added this import

from xdata import *
xint = XInt()
xfloat = XFloat()
xstring = XString()
xlist_xint = XList(sequence=xint)
xlist_xfloat = XList(sequence=xfloat)
xlist_xstring = XList(sequence=xstring)
xdict_keys_xstring = XDict(keys=xstring)
xdict_keys_xfloat = XDict(keys=xfloat)
xdict_keys_xint = XDict(keys=xint)
xdict = XDict()

def sendExceptionOnCorbaBus():
    #
    from sys import exc_info
    exc_type, exc_value, exc_traceback = exc_info()
    #
    if exc_value is None:
        pmdcn = ""
    else:
        e = exc_type
        pmdcn = "%s.%s"%(e.__module__, e.__name__)
        pass
    #
    from traceback import format_exception
    exc_msg = "".join(format_exception(exc_type, exc_value, exc_traceback))
    msg = exc_msg
    #
    message(pmdcn, msg, cls="XDATA")
    from XDATA_CORBA import XException
    e = XException(pmdcn, msg)
    message(e, cls="XDATA")
    raise e

class XDATA(XDATA_Component, SALOME_ComponentPy_i):
    
    def __init__(self, orb, poa, contID, containerName, instanceName, interfaceName):
        SALOME_ComponentPy_i.__init__(self, orb, poa, contID, containerName, instanceName, interfaceName, 1)
        self._serviceName = "__init__"
        self._interfaceName = interfaceName
        self.names = []
        self.study = None
        self.__id2builder__ = {}
        #SRN BEGIN: Aug 24, 2004: Added a map of XObjects published in the Study
        self.object_map = {}
        #SRN END
        #
        self.salome_version = None
        from os import getenv
        d = getenv('KERNEL_ROOT_DIR')
        if d:
            filename = d + "/bin/salome/VERSION"
            try:
                f = open(filename)
                stream = f.read()
                if stream.find('THIS IS SALOME - KERNEL VERSION: 3.2.6') == 0:
                    self.salome_version = "3.2.6"
                    pass
                f.close()
            except:
                pass
            pass
        #
        return

    def Kill_impl(self):
        return 0
    
    def _get_interfaceName(self):
        return self._interfaceName
    
    def newXType(self, value, xtype=None, depth=0):
        self.beginService("newXType")
        message("python_value =", value)
        from xsalome import python2corba
        value = python2corba(value, self._this(), xtype, depth)
        message("corba_value =", value)
        self.endService("newXType")
        return value
    
    def newXInt(self, value):
        return self.newXType(value, xint, 1)
    def newXFloat(self, value):
        return self.newXType(value, xfloat, 1)
    def newXString(self, value):
        return self.newXType(value, xstring, 1)
    def newXListLongValues(self, value):
        return self.newXType(value, xlist_xint, 1)
    def newXListDoubleValues(self, value):
        return self.newXType(value, xlist_xfloat, 1)
    def newXListStringValues(self, value):
        return self.newXType(value, xlist_xstring, 1)
    
    def newXListXObjectValues(self, value, is_tuple=0):
        self.beginService("newXType")
        message("python_value =", value)
        message("is_tuple =", is_tuple)
        message('converting the list content from corba to python')
        from xsalome import corba2python
        value = [ corba2python(v) for v in value ]
        if is_tuple:
            value = tuple(value)
            pass
        message("python_value =", value)
        from xsalome import python2corba
        value = python2corba(value, self._this())
        message("corba_value =", value)
        self.endService("newXType")
        return value
    
    def newXTupleXObjectValues(self, value):
        return self.newXListXObjectValues(value, 1)
    
    def newXDictKeys(self, keys, values, xtype):
        message(keys, values)
        self.beginService("newXType")
        value = {}
        for i in range(len(keys)):
            key = keys[i]
            from xsalome import corba2python
            val = corba2python(values[i])
            value[key] = val
            pass
        from xsalome import python2corba
        value = python2corba(value, self._this(), xtype)
        self.endService("newXType")
        return value
    
    def newXDictStringKeys(self, keys, values):
        return self.newXDictKeys(keys, values, xdict_keys_xstring)
    def newXDictDoubleKeys(self, keys, values):
        return self.newXDictKeys(keys, values, xdict_keys_xfloat)
    def newXDictLongKeys(self, keys, values):
        return self.newXDictKeys(keys, values, xdict_keys_xint)
    def newXDictXObjectKeys(self, keys, values):
        from xsalome import corba2python
        keys = [ corba2python(key) for key in keys ]
        return self.newXDictKeys(keys, values, xdict)
    
    def newXObject(self):
        from xdata import XObject
        corba_object = self.newCorbaObject(XObject)
        return corba_object
    
    def newCorbaObject(self, cls, *args, **kwargs):
        self.beginService("new%s"%(cls.__name__))
        # --
        if kwargs:
            msg  = "Hummm, I tought that kwargs was empty in the corba bus\n"
            msg += "It's not the case here !!! Strange ..."
            raise msg
        # --
        message("python_class =", cls, cls="XDATA")
        # --
        # convert corba args in python kwargs
        message("begin{python kwargs construction}", cls="XDATA")
        ixas = cls.getAllInitXAttributes()
        ixas_names = [ getattr(x, '__name') for x in ixas ]
        for i in range(len(ixas_names)):
            key, val = ixas_names[i], args[i]
            message("key, corba_val:", key, val, cls="XDATA")
            # convert corba val in python val
            from xsalome import corba2python
            val = corba2python(val)
            message("key, python_val:", key, val, cls="XDATA")
            kwargs[key] = val
            pass
        message("end{python kwargs construction}", cls="XDATA")
        # --
        # Nullify args
        args = tuple()
        # --
        # construct the python object
        message("calling", cls, "constructor with kwargs", cls="XDATA")
        try:
            python_object = cls(*args, **kwargs)
        except:
            sendExceptionOnCorbaBus()
            pass
        message("python_object:", python_object, cls="XDATA")
        # --
        # wrap python object in corba object
        from xsalome import python2corba
        message("calling python2corba", cls="XDATA")
        corba_object = python2corba(python_object, self._this())
        message("corba_object =", corba_object, cls="XDATA")
        #
        self.endService("new%s"%(cls.__name__))
        return corba_object
    
    def isLocal(self, value):
        from xsalome import isLocal
        return isLocal(value)
    
    def newName(self, prefix):
        n = 0
        while 1:
            n += 1
            name = "%s_%s"%(prefix, n)
            if name not in self.names:
                return name
            pass
        return
    
    #SRN BEGIN: Aug 24, 2004: Added Persistence support
    
    def IORToLocalPersistentID(self, theSObject, IORString, isMultiFile, isASCII):
        message(theSObject, IORString, isMultiFile, isASCII)
        return theSObject.GetID()
    
    def LocalPersistentIDToIOR(self, theSObject, PersistentID, isMultiFile, isASCII):
        message(theSObject, PersistentID, isMultiFile, isASCII)
        # \begin{E.A.}
        self.study = theSObject.GetStudy()
        # \end{E.A.}
        if not self.object_map.has_key(PersistentID):
            raise "XDATA::LocalPersistentIDToIOR : PersistentID "+str(PersistentID)+" doesn't correspond to any Python object"
        from xsalome import getORB
        orb = getORB()
        from xsalome import python2corba
        corba_object = python2corba(self.object_map[PersistentID], self._this())
        return orb.object_to_string(corba_object)
    
    def ComponentDataType(self):
        return "XDATA"
    
    def Save(self, theComponent, theURL, isMultiFile):
        message(theComponent, theURL, isMultiFile)
        self.object_map.clear()
        self.study = theComponent.GetStudy()
        itr = self.study.NewChildIterator(theComponent)
        itr.InitEx(1)
        while itr.More():
            so = itr.Value()
            result, attr = so.FindAttribute("AttributeIOR")
            if result:
                attr = attr._narrow(SALOMEDS.AttributeIOR)
                ior = attr.Value()
                from xsalome import getORB
                obj = getORB().string_to_object(ior)
                from xsalome import corba2python
                python_object = corba2python(obj)
                if not hasattr(python_object, '_narrow'):
                    objectID = so.GetID()
                    self.object_map[objectID] = python_object
                    pass
                pass
            itr.Next()
            pass
        
        from xmedpersistence import DumpObject
        stream = DumpObject(self.object_map, self.study)
        self.object_map.clear()
        
        if isMultiFile:
            filename = self.study._get_URL()
            idx = filename.rfind(".")
            filename = filename[:idx]
            filename +="_XDATA.xd"
            fd = open(filename, "w")
            fd.write(stream)
            fd.close()
            stream = filename
            pass
	
        return stream
    
    def SaveASCII(self, theComponent, theURL, isMultiFile):
        return self.Save(theComponent, theURL, isMultiFile)
    
    def Load(self, theComponent, theStream, theURL, isMultiFile):
        message(theComponent, theStream, theURL, isMultiFile)
        from xmedpersistence import ConstructObject
        self.object_map.clear()
        self.study = theComponent.GetStudy()
        
        if isMultiFile:
            filename = self.study._get_URL()
            idx = filename.rfind(".")
            filename = filename[:idx]
            filename +="_XDATA.xd"
            fd = open(filename, "r")
            stream = fd.read()
            fd.close()
            self.object_map = ConstructObject(stream, self.study)
            pass
        else:
            self.object_map = ConstructObject(theStream, self.study)
            pass
        return 1
    
    def LoadASCII(self, theComponent, theStream, theURL, isMultiFile):
        return self.Load(theComponent, theStream, theURL, isMultiFile)      
    
    def Close(self, theComponent):
        self.object_map.clear()
        pass
    
    #SRN END  
    
    def CanPublishInStudy(self, theIOR):
        message(theIOR, cls="XDATA")
        return 1
    
    def PublishInStudy(self, theStudy, theSObject, theObject, theName):
        message(theStudy, theSObject, theObject, theName, cls="XDATA")
        self.setStudy(theStudy)
        builder = self.getBuilder(theStudy)
        builder.NewCommand()
        sobject = self.addToStudy(theObject, theName, 0, None)
        if theStudy.IsModified():
            builder.CommitCommand()
        else:
            builder.AbortCommand()
            pass
        return sobject
    
    def PublishInStudyWithoutContent(self, theStudy, theSObject, theObject, theName):
        message(theStudy, theSObject, theObject, theName, cls="XDATA")
        self.setStudy(theStudy)
        builder = self.getBuilder(theStudy)
        builder.NewCommand()
        theObject.__recursion__ = 0
        sobject = self.addToStudy(theObject, theName, 0, None)
        if theStudy.IsModified():
            builder.CommitCommand()
        else:
            builder.AbortCommand()
            pass
        return sobject
    
    def CanCopy(self, theObject):
        return 0
    
    def getBuilder(self, study):
        study_id = study.id
        try:
            builder = self.__id2builder__[study_id]
        except KeyError:
            builder = study.NewBuilder()
            self.__id2builder__[study_id] = builder
            pass
        return builder

    def getSComponent(self, study):
        father = study.FindComponent(self._get_interfaceName())
        return father

    def findOrCreateAttribute(self, builder, sobject, name):
        attr = sobject.FindAttribute(name)[1]
        if attr is None:
            attr = builder.FindOrCreateAttribute(sobject, name)
            pass
        sobject.__attributes__.append(name)
        return attr
    
    def setStudy(self, study):
        self.study = study
        import SALOMEDS
        myStudy = self.study
        myStudy_id = myStudy._get_StudyId()
        myStudy.id = myStudy_id
        myBuilder = self.getBuilder(myStudy)
        father = self.getSComponent(myStudy)
        if father is None:
            myBuilder.NewCommand()
            father = myBuilder.NewComponent(self._get_interfaceName())
            father.__attributes__ = []
            attr = self.findOrCreateAttribute(myBuilder, father, "AttributeName")
            attr._narrow(SALOMEDS.AttributeName).SetValue(self._get_interfaceName())
            attr = self.findOrCreateAttribute(myBuilder, father, "AttributePixMap")
            attr._narrow(SALOMEDS.AttributePixMap).SetPixMap(self._get_interfaceName()+".png")
            myBuilder.DefineComponentInstance(father, self._this())
            myBuilder.CommitCommand()
            pass
        return
    
    def removeChildrenSObjects(self, mySObject):
        myStudy = self.study
        myBuilder = myStudy.NewBuilder()
        myBuilder.NewCommand()
        it = myStudy.NewChildIterator(mySObject)
        while it.More():
            sobj = it.Value()
            myBuilder.RemoveObjectWithChildren(sobj)
            it.Next()
            pass
        myBuilder.CommitCommand()
        return
    
    def getUnpackBoolean(self, xattr):
        #
        unpack = 1
        #
        from xdata import XAttribute
        if not isinstance(xattr, XAttribute):
            return unpack
        #
        xtype = xattr.xtype
        from xdata import XMulTypes
        if isinstance(xtype, XMulTypes):
            xtypes = xtype.xtypes
            if len(xtypes) == 2:
                from xdata import XNone
                if isinstance(xtypes[0], XNone):
                    xtype = xtypes[1]
                    pass
                pass
            pass
        #
        try:
            unpack = xtype.unpack_in_browser
        except AttributeError:
            pass
        #
        return unpack

    def getSortBoolean(self, xattr):
        #
        sort = 1
        #
        from xdata import XAttribute
        if not isinstance(xattr, XAttribute):
            return sort
        #
        xtype = xattr.xtype
        from xdata import XMulTypes
        if isinstance(xtype, XMulTypes):
            xtypes = xtype.xtypes
            if len(xtypes) == 2:
                from xdata import XNone
                if isinstance(xtypes[0], XNone):
                    xtype = xtypes[1]
                    pass
                pass
            pass
        #
        try:
            sort = xtype.sort_in_browser
        except AttributeError:
            pass
        #
        return sort

    def addRef(self, myBuilder, mySObject, sobj):
        self.removeChildrenSObjects(mySObject)
        myBuilder.Addreference(mySObject, sobj)
        #
        name = sobj.FindAttribute("AttributeName")[1]
        if name:
            name = name._narrow(SALOMEDS.AttributeName).Value()
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
            attr._narrow(SALOMEDS.AttributeComment).SetValue(name)
            pass
        #
        return
    
    def findObjectIOR(self, study, ior):
        sobj = study.FindObjectIOR(ior)
        if sobj:
            # Fix a bug in salome 3.2.6
            if self.salome_version == "3.2.6":
                if sobj.GetIOR() != ior:
                    sobj = None
                    pass
                pass
            pass
        return sobj
    
    def addToStudy(self, value, name, is_xprop, father):
        message(value, name, is_xprop, father, cls="XDATA")
        if self.study is None: return
        import SALOMEDS
        myStudy = self.study
        myBuilder = self.getBuilder(myStudy)
        #
        mySObject = None
        if is_xprop:
            try:
                find_previous = not father.is_empty
            except AttributeError:
                find_previous = 1
                pass
            if find_previous:
                message("trying to find the previous SObject ...")
                it = myStudy.NewChildIterator(father)
                while it.More():
                    sobj = it.Value()
                    sname = sobj.FindAttribute("AttributeName")[1]
                    if sname:
                        sname = sname._narrow(SALOMEDS.AttributeName).Value()
                        if sname == name:
                            mySObject = sobj
                            message("... found")
                            break
                        pass
                    it.Next()
                    pass
                if mySObject is None:
                    message('... not found')
                    pass
                pass
            pass
        else:
            if hasattr(value, "_narrow"):
                from xsalome import getORB
                orb = getORB()
                ior = orb.object_to_string(value)
                mySObject = self.findObjectIOR(myStudy, ior)
                pass
            pass
        if mySObject is None:
            if father is None:
                father = self.getSComponent(myStudy)
                # E.A. if object has no name for instance if it is put in
                # study from supervision, set a name
                if not name:
                    if hasattr(value, "getPythonModuleDotClassName"):
                        pmdcn = value.getPythonModuleDotClassName()
                        if not hasattr(self, "pmdcn2num"):
                            self.pmdcn2num = {}
                            pass
                        pmdcn2num = self.pmdcn2num
                        if pmdcn not in pmdcn2num:
                            pmdcn2num[pmdcn] = 1
                            pass
                        name = "%s instance %s"%(pmdcn, pmdcn2num[pmdcn])
                        pmdcn2num[pmdcn] += 1
                        pass
                    pass
                pass
            mySObject = myBuilder.NewObject(father)
            pass
        #
        mySObject.__attributes__ = []
        #
        ref = mySObject.ReferencedObject()[1]
        if ref:
            myBuilder.RemoveReference(mySObject)
            pass
        #
        attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeName")
        attr._narrow(SALOMEDS.AttributeName).SetValue(name)
        self.names.append(name)
        #
        names_in_study = []
        #
        if 0:
            pass
        elif value is None:
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
            attr._narrow(SALOMEDS.AttributeComment).SetValue("None")
        elif value is True:
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
            attr._narrow(SALOMEDS.AttributeComment).SetValue("True")
        elif value is False:
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
            attr._narrow(SALOMEDS.AttributeComment).SetValue("False")
        elif isinstance(value, float):
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeReal")
            attr._narrow(SALOMEDS.AttributeReal).SetValue(value)
        elif isinstance(value, str):
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
            attr._narrow(SALOMEDS.AttributeComment).SetValue(value)
        elif isinstance(value, int):
            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeInteger")
            attr._narrow(SALOMEDS.AttributeInteger).SetValue(value)
        elif isinstance(value, list):
            message('obj is a list')
            if self.getUnpackBoolean(is_xprop):
                self.removeChildrenSObjects(mySObject)
                mySObject.is_empty = 1
                for i in range(len(value)):
                    v = value[i]
                    name = "[%s]"%(i)
                    self.addToStudy(v, name, 1, mySObject)
                    names_in_study.append(name)
                    pass
                pass
            pass
        elif hasattr(value, "_narrow"):
            from xsalome import getORB
            orb = getORB()
            ior = orb.object_to_string(value)
            corba_object = value
            if not hasattr(corba_object, 'getCorbaModuleDotInterfaceName'):
                message('non xdata corba object')
                #
                test_sobj = corba_object._narrow(SALOMEDS.SObject)
                if test_sobj:
                    sobj = test_sobj
                else:
                    sobj = self.findObjectIOR(myStudy, ior)
                    pass
                #
                if ( sobj ) and ( sobj.GetID() != mySObject.GetID() ):
                    message('previous sobj found in study --> add a ref')
                    self.addRef(myBuilder, mySObject, sobj)
                else:
                    attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeIOR")
                    attr._narrow(SALOMEDS.AttributeIOR).SetValue(ior)
                    pass
                pass
            else:
                cmdin = corba_object.getCorbaModuleDotInterfaceName()
                corba_module, corba_class = cmdin.split(".")
                if corba_module == "XDATA_CORBA":
                    sobj = self.findObjectIOR(myStudy, ior)
                    if ( sobj ) and ( sobj.GetID() != mySObject.GetID() ) and ( corba_class == "XObject" ):
                        self.addRef(myBuilder, mySObject, sobj)
                    else:
                        #
                        attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeIOR")
                        attr._narrow(SALOMEDS.AttributeIOR).SetValue(ior)
                        attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeLocalID")
                        attr._narrow(SALOMEDS.AttributeLocalID).SetValue(4000)
                        #
                        if corba_class in ("XObject", ):
                            pass
                        elif corba_class in ("XDictLongKeys", "XDictStringKeys", "XDictDoubleKeys", ) :
                            if self.getUnpackBoolean(is_xprop):
                                self.removeChildrenSObjects(mySObject)
                                mySObject.is_empty = 1
                                keys = corba_object.keys()
                                if self.getSortBoolean(is_xprop):
                                    keys.sort()
                                    pass
                                for key in keys:
                                    v = corba_object.value(key)
                                    key = str(key)
                                    self.addToStudy(v, key, 1, mySObject)
                                    names_in_study.append(key)
                                    pass
                                pass
                            pass
                        elif corba_class in ("XDictXObjectKeys", ) :
                            if self.getUnpackBoolean(is_xprop):
                                self.removeChildrenSObjects(mySObject)
                                mySObject.is_empty = 1
                                keys = corba_object.keys()
                                if self.getSortBoolean(is_xprop):
                                    keys.sort()
                                    pass
                                for key in keys:
                                    name = 'item %s'%(keys.index(key))
                                    item_sobj = self.addToStudy("", name, 1, mySObject)
                                    item_sobj.is_empty = 1
                                    names_in_study.append(name)
                                    self.addToStudy(key, "key", 1, item_sobj)
                                    v = corba_object.value(key)
                                    self.addToStudy(v, "value", 1, item_sobj)
                                    pass
                                pass
                            pass
                        else:
                            python_object = corba_object.value()
                            if 0:
                                pass
                            elif isinstance(python_object, float):
                                attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeReal")
                                attr._narrow(SALOMEDS.AttributeReal).SetValue(python_object)
                            elif isinstance(python_object, str):
                                if python_object.find('__wrap__') == 0:
                                    ior = python_object[len('__wrap__'):]
                                    from xsalome import getORB
                                    corba_object = getORB().string_to_object(ior)
                                    father.is_empty = 0
                                    self.addToStudy(corba_object, name, is_xprop, father)
                                else:
                                    attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
                                    attr._narrow(SALOMEDS.AttributeComment).SetValue(python_object)
                                    pass
                                pass
                            elif isinstance(python_object, int):
                                attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeInteger")
                                attr._narrow(SALOMEDS.AttributeInteger).SetValue(python_object)
                            elif isinstance(python_object, list):
                                if self.getUnpackBoolean(is_xprop):
                                    self.removeChildrenSObjects(mySObject)
                                    mySObject.is_empty = 1
                                    for i in range(len(python_object)):
                                        v = python_object[i]
                                        name = "[%s]"%(i)
                                        self.addToStudy(v, name, 1, mySObject)
                                        names_in_study.append(name)
                                        pass
                                    pass
                                pass
                            pass
                        pass
                    pass
                else:
                    sobj = self.findObjectIOR(myStudy, ior)
                    if ( sobj ) and ( sobj.GetID() != mySObject.GetID() ):
                        message('previous sobj found in study --> add a ref')
                        self.addRef(myBuilder, mySObject, sobj)
                    else:
                        attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeIOR")
                        attr._narrow(SALOMEDS.AttributeIOR).SetValue(ior)
                        # attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeLocalID")
                        # attr._narrow(SALOMEDS.AttributeLocalID).SetValue(4000)
                        #
                        from xsalome import corba2python
                        python_object = corba2python(value)
                        #
                        from xdata import XObject
                        if isinstance(python_object, XObject):
                            cls = python_object.__class__
                            #
                            attr = self.findOrCreateAttribute(myBuilder, mySObject, "AttributeComment")
                            attr._narrow(SALOMEDS.AttributeComment).SetValue("%s instance"%(cls.__name__))
                            #
                            content = 1
                            if hasattr(value, "__recursion__"):
                                content = getattr(value, "__recursion__")
                                pass
                            python_object.__content__in__study__ = content
                            #
                            if content:
                                xattrs = cls.getXAttributesMRO()
                                for x in xattrs:
                                    name = x.name
                                    from xutilities import name2capname
                                    capname = name2capname(name)
                                    method = getattr(value, "get%s"%(capname))
                                    try:
                                        v = method()
                                        ok = 1
                                    except:
                                        ok = 0
                                        pass
                                    if ok:
                                        message(x.name, v)
                                        self.addToStudy(v, x.name, x, mySObject)
                                        names_in_study.append(name)
                                        pass
                                    pass
                                pass
                            pass
                        #
                        pass
                    pass
                pass
            pass
        else:
            raise Exception("What is that : %s"%(value))
        #
        for attr in ["Comment", "Real", "Integer", "IOR", ]:
            attr = "Attribute%s"%(attr)
            if attr in mySObject.__attributes__:
                continue
            if mySObject.FindAttribute(attr)[1] is None:
                continue
            myBuilder.RemoveAttribute(mySObject, attr)
            pass
        #
        # E.A. : After the object has been published
        # in study, we must remove the children which
        # are not in names_in_study. They can be here
        # if the object has been modified or for any
        # reason ...
        #
        try:
            need_cleaning = not mySObject.is_empty
        except AttributeError:
            need_cleaning = 1
            pass
        if need_cleaning:
            it = myStudy.NewChildIterator(mySObject)
            while it.More():
                sobj = it.Value()
                it.Next()
                sname = sobj.FindAttribute("AttributeName")[1]
                if not sname: continue
                sname = sname._narrow(SALOMEDS.AttributeName).Value()
                if sname in names_in_study: continue
                message("sobj with name %s must be removed"%(sname))
                myBuilder.RemoveObjectWithChildren(sobj)
                pass
            pass
        #
        return mySObject
    
    pass

from XDATA_CORBA__POA import XObject

class XObject_i(XObject):
    def __init__(self, python_object, component, xtype, cmdin):
        self.python_object = python_object
        self.component = component
        self.xtype = xtype
        #
        self._name2xtype = {}
        self._name2xmethod = {}
        self._cls = python_object.__class__
        self._pmdcn = "%s.%s"%(self._cls.__module__, self._cls.__name__)
        self._cmdin = cmdin
        #
        return
    def getCorbaComponent(self):
        return self.component
    def getPythonModuleDotClassName(self):
        return self._pmdcn
    def getCorbaModuleDotInterfaceName(self):
        return self._cmdin
    def getXTypeFromName(self, name):
        if name in self._name2xtype:
            return self._name2xtype[name]
        property = getattr(self._cls, name)
        accessor = property.fget
        xtype = getattr(accessor.xattr, '__xtype')
        self._name2xtype[name] = xtype
        return self.getXTypeFromName(name)
    def getXMethodFromName(self, name):
        if name in self._name2xmethod:
            return self._name2xmethod[name]
        from xutilities import getMRO
        from xdata import XObject
        l = getMRO(self._cls, XObject)
        for cls in l:
            found = 0
            for x in cls.__object__xmethods__:
                if x.name != name: continue
                self._name2xmethod[name] = x
                found = 1
                break
            if found:
                break
            pass
        return self.getXMethodFromName(name)
    def get_impl(self, name, *args, **kwargs):
        message(name, args, kwargs)
        try:
            value = getattr(self.python_object, name)
        except:
            sendExceptionOnCorbaBus()
            pass
        message("python_value:", value)
        xtype = self.getXTypeFromName(name)
        from xsalome import python2corba
        value = python2corba(value, self.component, xtype)
        message("corba_value:", value)
        return value
    def set_impl(self, name, *args, **kwargs):
        message(name, args, kwargs)
        value = args[0]
        from xsalome import corba2python
        value = corba2python(value)
        try:
            setattr(self.python_object, name, value)
        except:
            sendExceptionOnCorbaBus()
            pass
        return
    def apply_impl(self, name, *args, **kwargs):
        message(name, args, kwargs)
        x = self.getXMethodFromName(name)
        if x.in_xattributes:
            for i in range(len(x.in_xattributes)):
                xattr = x.in_xattributes[i]
                val = args[i]
                from xsalome import corba2python
                val = corba2python(val)
                kwargs[xattr.name] = val
                pass
            args = tuple()
            pass
        meth = getattr(self.python_object, name)
        try:
            value = meth(*args, **kwargs)
        except:
            sendExceptionOnCorbaBus()
            pass
        message("python_value:", value)
        #
        from xsalome import python2corba
        #
        xattrs = x.out_xattributes
        if xattrs:
            if len(xattrs) == 1:
                value = python2corba(value, self.component, xattrs[0].xtype)
            else:
                value_tmp = []
                for i in range(len(xattrs)):
                    xa = xattrs[i]
                    val = value[i]
                    val = python2corba(val, self.component, xa.xtype)
                    value_tmp.append(val)
                    pass
                value = tuple(value_tmp)
                pass
            pass
        else:
            value = python2corba(value, self.component, x.out_xtype)
            pass
        #
        message("corba_value:", value)
        return value
    def isContentPublished(self):
        value = self.python_object
        try:
            res = value.__content__in__study__
        except AttributeError:
            res = 1
            pass
        return res
    pass

from XDATA_CORBA__POA import XType

class XType_i(XType, XObject_i):
    def value(self):
        return self.python_object
    pass

from XDATA_CORBA__POA import XInt, XFloat, XString
from XDATA_CORBA__POA import XList
from XDATA_CORBA__POA import XListLongValues
from XDATA_CORBA__POA import XListDoubleValues
from XDATA_CORBA__POA import XListStringValues

class XInt_i(XInt, XType_i): pass
class XFloat_i(XFloat, XType_i): pass
class XString_i(XString, XType_i): pass
class XList_i(XList, XType_i): pass
class XListLongValues_i(XListLongValues, XList_i): pass
class XListDoubleValues_i(XListDoubleValues, XList_i): pass
class XListStringValues_i(XListStringValues, XList_i): pass

from XDATA_CORBA__POA import XListXObjectValues

class XListXObjectValues_i(XListXObjectValues, XList_i):
    def value(self):
        val = self.python_object
        from xsalome import python2corba
        val = [ python2corba(v, self.component) for v in val ]
        return val
    pass

from XDATA_CORBA__POA import XDict

class XDict_i(XDict, XType_i):
    def keys(self):
        return self.python_object.keys()
    def value(self, key):
        message("key:", key)
        if isinstance(key, float):
            try:
                val = self.python_object[key]
            except KeyError, e:
                key_ok = 0
                for k in self.keys():
                    error = abs(k-key)
                    epsilon = 1.0e-5 * abs(k+key)
                    if error < epsilon:
                        key_ok = 1
                        val = self.python_object[k]
                        break
                    pass
                if not key_ok:
                    raise e
                pass
            pass
        else:
            val = self.python_object[key]
            pass
        message("python_value:", val)
        from xsalome import python2corba
        val = python2corba(val, self.component)
        message("corba_value:", val)
        return val
    pass

from XDATA_CORBA__POA import XDictStringKeys
class XDictStringKeys_i(XDictStringKeys, XDict_i): pass
from XDATA_CORBA__POA import XDictDoubleKeys
class XDictDoubleKeys_i(XDictDoubleKeys, XDict_i): pass
from XDATA_CORBA__POA import XDictLongKeys
class XDictLongKeys_i(XDictLongKeys, XDict_i): pass

from XDATA_CORBA__POA import XDictXObjectKeys
class XDictXObjectKeys_i(XDictXObjectKeys, XDict_i):
    def keys(self):
        keys = XDict_i.keys(self)
        from xsalome import python2corba
        keys = [ python2corba(k, self.component) for k in keys ]
        return keys
    def value(self, key):
        message("key:", key)
        from xsalome import corba2python
        key = corba2python(key)
        val = XDict_i.value(self, key)
        return val
    pass

from XDATA_CORBA__POA import XSolver
class XSolver_i(XSolver, XObject_i):
    def run(self):
        result = self.python_object.run()
        return result
    pass
