# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xqt import *

class XDataQMainWindow(QMainWindow):
    
    def __init__(self):
        
        QMainWindow.__init__(self)
        self.resize(800, 600)
        self.move(200, 100)
        self.statusBar().message('',2000)
        
        # --
        # split the main window in horizontal windows
        #
        main_widget = QSplitter(Qt.Horizontal, self)
        self.setCentralWidget(main_widget)
        
        # --
        # put an object explorer on main_left
        from xdataobjectexplorer import XDataObjectExplorer
        object_explorer = XDataObjectExplorer(main_widget)
        
        # --
        # put a vtk widget on main_top_left
        try:
            from qvtkwidget import QVtkWidget
            qvtkwidget = QVtkWidget(main_widget)
        except ImportError:
            qvtkwidget = QWidget(main_widget)
            pass
        
        # --
        # File and View menu
        file_menu = QPopupMenu(self)
        view_menu = QPopupMenu(self)
        # view_menu.insertTearOffHandle()
        
        self.menuBar().insertItem('&File', file_menu)
        self.menuBar().insertItem('&View', view_menu)
        
        #
        actions = []
        actions.append( (file_menu, "&Import", self.open, Qt.CTRL+Qt.Key_I, None) )
        actions.append( (file_menu, "&Export", self.export, Qt.CTRL+Qt.Key_E, None) )
        actions.append( (file_menu, "E&xit", self.exit, Qt.CTRL+Qt.Key_X, None) )
        # actions.append( (view_menu, "Front", qvtkwidget.onViewFront, None, "view_front.png") )
        # actions.append( (view_menu, "Back", qvtkwidget.onViewBack, None, "view_back.png") )
        # actions.append( (view_menu, "Top", qvtkwidget.onViewTop, None, "view_top.png") )
        # actions.append( (view_menu, "Bottom", qvtkwidget.onViewBottom, None, "view_bottom.png") )
        # actions.append( (view_menu, "Left", qvtkwidget.onViewLeft, None, "view_left.png") )
        # actions.append( (view_menu, "Right", qvtkwidget.onViewRight, None, "view_right.png") )
        #
        for a in actions:
            menu = a[0]
            menu_text = a[1]
            target = a[2]
            accel = a[3]
            icon = a[4]
            #
            qaction = QAction(self)
            qaction.setText(menu_text.replace("&", ""))
            qaction.setMenuText(menu_text)
            qaction.connect(qaction, SIGNAL("activated()"), target)
            if accel :
                qaction.setAccel(accel)
                pass
            if icon :
                import xdata
                from os.path import dirname
                dir  = dirname(xdata.__file__)
                dir += "/../../../../share/xdata/resources"
                from os.path import normpath
                dir  = normpath(dir)
                file = dir + '/' + icon
                qaction.setIconSet(QIconSet(QPixmap(file)))
                pass
            qaction.addTo(menu)
            pass
        
        # --
        #
        
        self.connect(self, PYSIGNAL("update_with_xtree"), object_explorer.updateWithXTree)
        
        # --
        #
        
        self.connect(object_explorer, PYSIGNAL("selection_changed"), self.browserSelectionChanged)
        
        # --
        #
        
        return
    
    def open(self):
        fn = QFileDialog.getOpenFileName(QString.null,
                                         "(*.py)",
                                         self)
        if fn.isEmpty(): return
        fileName = str(fn)
        suffix = fileName.split(".")[-1]
        exec "self.import%s(fileName)"%(suffix)
        return
    
    def export(self):
        try:
            xtree = self.xtree
        except AttributeError:
            msg = "Nothing to save"
            QMessageBox.warning(self, "Warning", msg)
            return
        #
        fn = QFileDialog.getSaveFileName(QString.null,
                                         "(*.py)",
                                         self,
                                         "save file dialog"
                                         "Choose a filename to save under" );
        if fn.isEmpty(): return
        fileName = str(fn)
        self.xtree.saveAs(fileName)
        return
    
    def exit(self):
        self.close()
        return
    
    def updateObjectBrowser(self):
        from xtree import getMainXTree
        xtree = getMainXTree()
        self.xtree = xtree
        self.emit(PYSIGNAL("update_with_xtree"), (xtree, ))
        return
    
    def browserSelectionChanged(self, objs):
        from xutilities import message
        message(self, objs)
        self.emit(PYSIGNAL("browser_selection_changed"), (objs, ))
        return
    
    def importpy(self, file_name):
        from xdatagui import importPy
        importPy(file_name, "python")
        return
    
    pass
