# --
# Copyright (C) CEA, EDF
# Author : Erwan ADAM (CEA)
# --

from xdata import *

from shape2D import Shape2D

class Circle(Shape2D):
    
    __nickname__ = "circ"
    
    __init__xattributes__ = [
        XAttribute("r", xtype=XFloat(open_min=0.0)),
        ]
    
    __object__xattributes__ = [
        XAttribute("perimeter", xtype=XFloat()),
        XAttribute("area", xtype=XFloat()),
        XAttribute("result", xtype=XFloat()),
        XAttribute("expected_outputs", xtype=XDict()),
        XAttribute("dirname", xtype=XInputDirName(), default_value="", mode="rw"),
        ]
    
    __object__xmethods__ = [
        XMethod("run", popup="single"),
        ]
    
    def setR(self, value):
        r = self.r
        self.bounds = [-r, r, -r, r]
        from math import pi
        self.perimeter = 2*pi*r
        self.area = pi*r*r
        return
    
    def run(self):
        for i in range(10000):
            print i, "#########", i
            pass
        self.result = 3.1415957
        try:
            self.expected_outputs['hydro'] = 3.45
        except AttributeError:
            self.expected_outputs = {}
            self.expected_outputs['hydro'] = 3.45
            pass
        return
    
    def popupActivated(cls, parent, method_name, selection):
        if method_name == 'run':
            selection = selection[0]
            selection.run()
            pass
        return
    
    popupActivated = classmethod(popupActivated)
    
    def getToolTip(cls, target):
        if target is cls:
            return "Circle class --> tooltip"
        if isinstance(target, cls):
            return "Circle instance --> tooltip"
        return "Circle class --> Attribute '%s' --> tooltip"%(target.name)
    
    getToolTip = classmethod(getToolTip)
    
    pass
