#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc LanguageEnglish {} {
    global menu
    global buttons
    global message

    # Main

    set menu(file) File
    set menu(edit) Edit
    set menu(view) View
    set menu(frame) Frame
    set menu(bin) Bin
    set menu(zoom) Zoom
    set menu(scale) Scale
    set menu(color) Color
    set menu(region) Region
    set menu(wcs) WCS
    set menu(analysis) Analysis
    set menu(help) Help

    set buttons(file) File
    set buttons(edit) Edit
    set buttons(view) View
    set buttons(frame) Frame
    set buttons(bin) Bin
    set buttons(zoom) Zoom
    set buttons(scale) Scale
    set buttons(color) Color
    set buttons(region) Region
    set buttons(wcs) WCS

    # File

    set menu(file,about) "About DS9..."
    set menu(file,open) "Open..."
    set menu(file,openother) "Open Other"
    set menu(file,preserve) "Preserve During Load"
    set menu(file,saveimage) "Save Image as..."
    set menu(file,savefits) "Save Frame as Fits..."
    set menu(file,savempeg) "Save Frames as MPEG..."
    set menu(file,savestate) "Save State..."
    set menu(file,loadstate) "Load State..."
    set menu(file,header) "Display Fits Header..."
    set menu(file,xpa) "XPA Information..."
    set menu(file,source) "Source TCL..."
    set menu(file,print) "Print..."
    set menu(file,page) "Page Setup..."
    set menu(file,exit) "Exit"

    set buttons(file,about) about
    set buttons(file,open) open
    set buttons(file,saveimage) {save img}
    set buttons(file,savefits) {save fits}
    set buttons(file,savempeg) {save mpeg}
    set buttons(file,header) header
    set buttons(file,source) source
    set buttons(file,print) print
    set buttons(file,page) page
    set buttons(file,exit) exit

    # Edit

    set menu(edit,undo) Undo
    set menu(edit,cut) Cut
    set menu(edit,copy) Copy
    set menu(edit,paste) Paste
    set menu(edit,default) None
    set menu(edit,pointer) Pointer
    set menu(edit,crosshair) Crosshair
    set menu(edit,colorbar) Colorbar
    set menu(edit,pan) Pan
    set menu(edit,zoom) Zoom
    set menu(edit,rotate) Rotate
    set menu(edit,catalog) Catalog
    set menu(edit,examine) Examine
    set menu(edit,preferences) Preferences

    set buttons(edit,undo) undo
    set buttons(edit,cut) cut
    set buttons(edit,copy) copy
    set buttons(edit,paste) paste
    set buttons(edit,default) default
    set buttons(edit,pointer) pointer
    set buttons(edit,crosshair) crosshair
    set buttons(edit,colorbar) colorbar
    set buttons(edit,pan) pan
    set buttons(edit,zoom) zoom
    set buttons(edit,rotate) rotate
    set buttons(edit,catalog) catalog
    set buttons(edit,examine) examine

    # Frame

    set menu(frame,new) "New Frame"
    set menu(frame,newrgb) "New Frame RGB"
    set menu(frame,delete) "Delete Frame"
    set menu(frame,deleteall) "Delete All Frames"
    set menu(frame,clear) "Clear Frame"
    set menu(frame,reset) "Reset Frame"
    set menu(frame,refresh) "Refresh Frame"
    set menu(frame,single) "Single Frame"
    set menu(frame,tile) "Tile Frames"
    set menu(frame,blink) "Blink Frames"
    set menu(frame,tileparam) "Tile"
    set menu(frame,blinkparam) "Blink Interval"
    set menu(frame,displayparam) "Display Size..."
    set menu(frame,matchframes) "Match Frames"
    set menu(frame,matchcolorbars) "Match Colorbars"
    set menu(frame,matchscales) "Match Scales"
    set menu(frame,lockcrosshairs) "Lock Crosshairs"
    set menu(frame,datacube) "Data Cube..."
    set menu(frame,rgb) "RGB..."
    set menu(frame,showhide) "Show/Hide Frames"

    set buttons(frame,new) new
    set buttons(frame,newrgb) "new rgb"
    set buttons(frame,delete) delete
    set buttons(frame,deleteall) "delete all"
    set buttons(frame,clear) clear
    set buttons(frame,reset) reset
    set buttons(frame,single) single
    set buttons(frame,tile) tile
    set buttons(frame,blink) blink
    set buttons(frame,first) first
    set buttons(frame,prev) prev
    set buttons(frame,next) next
    set buttons(frame,last) last

    # Bin

    set buttons(bin,in) in
    set buttons(bin,out) out
    set buttons(bin,block1) "block 1"
    set buttons(bin,block2) "block 2"
    set buttons(bin,block4) "block 4"
    set buttons(bin,block8) "block 8"
    set buttons(bin,block16) "block 16"
    set buttons(bin,block32) "block 32"
    set buttons(bin,block64) "block 64"
    set buttons(bin,block128) "block 128"

    # Messages

    set message(error,analysis,file) \
	"Unable to open file"
    set message(error,analysis,task) \
	"An error has occurred invoking the Analysis task."
    set message(error,ds9,xpa) \
	"Can't determine IP address for this host (no hostname); disabling XPA"
    set message(error,dialog,print) \
	"An error as occurred while printing."
    set message(error,dialog,save) \
	"An error as occurred while saving."
    set message(error,fits,rgb) \
	"Unable to load RGB image into a non-rgb frame"
    set message(error,fits,mime) \
	"File not Found or Unable to load FITS data MIME type:"
    set message(error,fits,load) \
	"Unable to load"
    set message(error,frame,rgb) \
	"Unable to create RGB frame with pseudocolor visual"
    set message(error,hvsup,scheme) \
	"Sorry, DS9 does not support"
    set message(error,hvsup,url) \
	"Unable to locate URL"
    set message(error,hvsup,http) \
	"Unable to finish http request"
    set message(error,marker,file) \
	"Unable to load fits region file."
    set message(error,plot,print) \
	"A printing error has occurred:"
    set message(error,plot,window) \
	"Unable to find plot window"
    set message(error,prefs,save) \
	"An Error as occurred while saving preferences."
    set message(error,print,error) \
	"A printing error has occurred:"
    set message(error,print,ps) \
	"A postscript generation error has occurred:"
    set message(error,state,save) \
	"An Error as occurred while saving state."
    set message(error,state,load) \
	"An Error as occurred while loading state."
    set message(error,vo,server) \
	"Unable to connect to server"
    set message(error,xpa,file) \
	"No file loaded"
    set message(error,xpa,tcl) \
	"Executing TCL code from xpa is not enabled."
    set message(error,xpa,init) \
	"XPA not initialized."

    set message(info,print,wait) \
	"Printing, please wait..."
    set message(info,print,saving) \
	"Saving image"
    set message(info,print,saving2) \
	"please wait"

    set message(error,cat,window) \
	"Unable to find catalog window"
}
