#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc SaveState {} {
    global ds9
    global message

    set fn [SaveFileDialog statefbox]
    if {[string length $fn] == 0} {
	return
    }

    set ch [open $fn w]
    if {$ch == {}} {
	Error "$message(error,state,save)" 
	return
    }

    # basic geometry
    foreach f $ds9(frames) {
	SaveStateFrame $ch $f
    }

    close $ch
}

proc LoadState {} {
    global message

    set fn [OpenFileDialog statefbox]
    if {[string length $fn] == 0} {
	return
    }

    # clear all frames
    DeleteAllFrames

    # close all dialogs
    PixelTableDestroyDialog
    RGBDestroyDialog
    ScaleDestroyDialog
    PanZoomDestroyDialog
    GroupDestroyDialog
    ColormapDestroyDialog

    TileDestroyDialog
    BinDestroyDialog
    CubeDestroyDialog
    SmoothDestroyDialog
    ContourDestroyDialog
    GridDestroyDialog
    NRESDestroyDialog
    DSSDestroyDialog
    2MASSDestroyDialog
    VODestroyDialog

    # and the rest?
    # analysis plot
    # analysis text
    # user plot
    # catalogs
    # hvs

    # and load the world
    if {[catch {source $fn}]} {
	Error "$message(error,state,load)"
	return
    }

    # and update it
    UpdateDS9
}

proc SaveStateFrame {ch which} {
    set type [$which get type]
    puts $ch "CreateNameNumberFrame $which $type"
}


