#  Copyright (C) 1999-2005
#  Smithsonian Astrophysical Observatory, Cambridge, MA, USA
#  For conditions of distribution and use, see copyright notice in "copyright"

package provide DS9 1.0

proc VectorDialog {frame id} {
    global menu
    global marker

    set w ".marker$id"

    # see if we already have a header window visible
    if [winfo exist $w] {
	raise $w
	return
    }

    # variables
    set marker($frame,$id,dcoord) $marker(dialog,dist,system)
    set marker($frame,$id,dlabel) $marker(dialog,dist,system)
    set marker($frame,$id,dformat) $marker(dialog,dist,format)
    set marker($frame,$id,arrow) [$frame get marker $id vector arrow]

    # base
    MarkerBaseDialog $frame $id 275 215

    # init
    VectorDistCB $frame $id

    # callbacks
    $frame marker $id callback move "VectorEditCB" $frame
    $frame marker $id callback edit "VectorEditCB" $frame

    # menus
    MarkerBaseDistMenu $frame $id dist Length VectorDistCB dcoord dformat

    # Point
    label $w.ref.f.title -text "Point"
    entry $w.ref.f.x -textvariable marker($frame,$id,x) -width 13
    entry $w.ref.f.y -textvariable marker($frame,$id,y) -width 13
    label $w.ref.f.coord -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,clabel)
    grid $w.ref.f.title $w.ref.f.x $w.ref.f.y $w.ref.f.coord -padx 4 -sticky w

    # Length
    label $w.ref.f.ltitle -text "Length"
    entry $w.ref.f.dist -textvariable marker($frame,$id,dist) -width 13
    label $w.ref.f.format -relief groove -width 9 -padx 4 \
	-textvariable marker($frame,$id,dlabel)
    grid $w.ref.f.ltitle $w.ref.f.dist x $w.ref.f.format -padx 4 -sticky w

    # Angle
    label $w.ref.f.angtitle -text "Angle"
    entry $w.ref.f.angle -textvariable marker($frame,$id,angle) -width 13
    label $w.ref.f.angformat -text "degrees" -relief groove \
	-width 9 -padx 4
    grid $w.ref.f.angtitle $w.ref.f.angle x $w.ref.f.angformat \
	-padx 4 -sticky w

    # Arrow
    label $w.ref.f.arrtitle -text "Arrow"
    checkbutton $w.ref.f.arrow -variable marker($frame,$id,arrow) \
	-selectcolor $menu(selectcolor) -command "VectorArrow $frame $id"
    grid $w.ref.f.arrtitle $w.ref.f.arrow -padx 4 -sticky w
}

# actions

proc VectorClose {frame id} {
    $frame marker $id delete callback move "VectorEditCB"
    $frame marker $id delete callback edit "VectorEditCB"

    MarkerBaseClose $frame $id
}

proc VectorApply {frame id} {
    global marker

    $frame marker $id vector point \
	$marker($frame,$id,system) $marker($frame,$id,sky) \
	$marker($frame,$id,x) $marker($frame,$id,y) \
	$marker($frame,$id,dcoord) $marker($frame,$id,dformat) \
	$marker($frame,$id,dist) \
	$marker($frame,$id,angle)

    MarkerBaseLineApply $frame $id
}

proc VectorArrow {frame id} {
    global marker
    
    $frame marker $id vector arrow $marker($frame,$id,arrow)
}

# callbacks

proc VectorCoordCB {frame id} {
    MarkerBaseCoordCB $frame $id
    VectorEditCB $frame $id
}

proc VectorEditCB {frame id} {
    global marker

    set p [$frame get marker $id vector point \
	       $marker($frame,$id,system) $marker($frame,$id,sky) \
	       $marker($frame,$id,skyformat)]

    set marker($frame,$id,x) [lindex $p 0]
    set marker($frame,$id,y) [lindex $p 1]

    set marker($frame,$id,dist) \
	[$frame get marker $id vector length \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]

    set marker($frame,$id,angle) \
	[$frame get marker $id angle \
	     $marker($frame,$id,system) $marker($frame,$id,sky)]

}

proc VectorDistCB {frame id} {
    global marker

    MarkerBaseDistCB $frame $id

    set marker($frame,$id,dist) \
	[$frame get marker $id vector length \
	     $marker($frame,$id,dcoord) $marker($frame,$id,dformat)]
}
