// Copyright (C) 1999-2005
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "colorscalepseudo8.h"
#include "util.h"
#include "framebase.h"

ColorScalePseudoColor8::ColorScalePseudoColor8(int s) : ColorScale(s)
{
  colors_ = new unsigned char[s];

  for (int i=0; i<s; i++)
    colors_[i] = psIndex_[i];
}

ColorScalePseudoColor8::~ColorScalePseudoColor8()
{
  if (colors_)
    delete [] colors_;
}

LinearScalePseudoColor8::LinearScalePseudoColor8(int s, 
						 unsigned short* indexCells, 
						 unsigned char* colorCells,
						 int count)
  : LinearScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s), 
    ColorScale(s) {}

LogScalePseudoColor8::LogScalePseudoColor8(int s, 
					   unsigned short* indexCells,
					   unsigned char* colorCells,
					   int count)
  : LogScale(s, indexCells, colorCells, count),
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

SquaredScalePseudoColor8::SquaredScalePseudoColor8(int s, 
						   unsigned short* indexCells,
						   unsigned char* colorCells,
						   int count)
  : SquaredScale(s, indexCells, colorCells, count), 
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

SqrtScalePseudoColor8::SqrtScalePseudoColor8(int s,
					     unsigned short* indexCells,
					     unsigned char* colorCells,
					     int count)
  : SqrtScale(s, indexCells, colorCells, count),
    ColorScalePseudoColor8(s),
    ColorScale(s) {}

IISScalePseudoColor8::IISScalePseudoColor8(FrameBase* parent,
					   unsigned short* indexCells, 
					   unsigned char* colorCells,
					   int count)
  : IISScale(indexCells, colorCells, count), 
    ColorScalePseudoColor8(IISSIZE), 
    ColorScale(IISSIZE)
{
  colors_[200] = psIndex_[200] = parent->getBlackColor();
  colors_[201] = psIndex_[201] = parent->getBlackColor();
  colors_[202] = psIndex_[202] = parent->getWhiteColor();
  colors_[203] = psIndex_[203] = parent->getRedColor();
  colors_[204] = psIndex_[204] = parent->getGreenColor();
  colors_[205] = psIndex_[205] = parent->getBlueColor();
  colors_[206] = psIndex_[206] = parent->getYellowColor();
  colors_[207] = psIndex_[207] = parent->getCyanColor();
  colors_[208] = psIndex_[208] = parent->getMagentaColor();
}

HistEquScalePseudoColor8::HistEquScalePseudoColor8(int s, 
						   unsigned short* indexCells, 
						   unsigned char* colorCells,
						   int count, 
						   double* hist, int histsize)
  : HistEquScale(s, indexCells, colorCells, count, hist, histsize), 
    ColorScalePseudoColor8(s), 
    ColorScale(s) {}
