/* A Bison parser, made by GNU Bison 1.875c.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002, 2003 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse tngparse
#define yylex   tnglex
#define yyerror tngerror
#define yylval  tnglval
#define yychar  tngchar
#define yydebug tngdebug
#define yynerrs tngnerrs


/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     INT = 258,
     REAL = 259,
     STRING = 260,
     DEGREE = 261,
     SEXSTR = 262,
     EOF_ = 263,
     BACKGROUND_ = 264,
     BOX_ = 265,
     BLACK_ = 266,
     BLUE_ = 267,
     CIRCLE_ = 268,
     CYAN_ = 269,
     DATE_ = 270,
     DEBUG_ = 271,
     DEGREES_ = 272,
     ECLIPTIC_ = 273,
     ELLIPSE_ = 274,
     FILENAME_ = 275,
     FK4_ = 276,
     FK5_ = 277,
     FORMAT_ = 278,
     GALACTIC_ = 279,
     GREEN_ = 280,
     HMS_ = 281,
     ICRS_ = 282,
     LINE_ = 283,
     MAGENTA_ = 284,
     OFF_ = 285,
     ON_ = 286,
     PHYSICAL_ = 287,
     PIXELS_ = 288,
     POINT_ = 289,
     POLYGON_ = 290,
     RED_ = 291,
     SOURCE_ = 292,
     TEXT_ = 293,
     VERSION_ = 294,
     WHITE_ = 295,
     YELLOW_ = 296
   };
#endif
#define INT 258
#define REAL 259
#define STRING 260
#define DEGREE 261
#define SEXSTR 262
#define EOF_ 263
#define BACKGROUND_ 264
#define BOX_ 265
#define BLACK_ 266
#define BLUE_ 267
#define CIRCLE_ 268
#define CYAN_ 269
#define DATE_ 270
#define DEBUG_ 271
#define DEGREES_ 272
#define ECLIPTIC_ 273
#define ELLIPSE_ 274
#define FILENAME_ 275
#define FK4_ 276
#define FK5_ 277
#define FORMAT_ 278
#define GALACTIC_ 279
#define GREEN_ 280
#define HMS_ 281
#define ICRS_ 282
#define LINE_ 283
#define MAGENTA_ 284
#define OFF_ 285
#define ON_ 286
#define PHYSICAL_ 287
#define PIXELS_ 288
#define POINT_ 289
#define POLYGON_ 290
#define RED_ 291
#define SOURCE_ 292
#define TEXT_ 293
#define VERSION_ 294
#define WHITE_ 295
#define YELLOW_ 296




/* Copy the first part of user declarations.  */
#line 5 "tngparser.Y"

#define YYPARSE_PARAM fr
#define YYDEBUG 1

#define FR ((FrameBase*)fr)
#define FITSPTR (FR->findFits(1))

#define DISCARD_(x) {yyclearin; tngDiscard(x);}

#include <math.h>
#include <string.h>
#include <iostream.h>

#include "framebase.h"
#include "fitsimage.h"
#include "util.h"
#include "vector.h"
#include "list.h"
#include "basemarker.h"
#include "coord.h"

extern int tnglex(void);
extern void tngerror(const char*);
extern void tngDiscard(int);

int tngsign;
int tngsign2;

static CoordSystem globalSystem;
static SkyFrame globalSky;
static CoordSystem localSystem;
static SkyFrame localSky;

static unsigned short globalProps;
static unsigned short localProps;

static char globalColor[16];
static char localColor[16];

static char globalFont[32];

static char globalText[80];
static char localText[80];

static char localComment[80];

static List<Vertex> polylist;
static List<Tag> taglist;
static List<CallBack> cblist;

static void setProps(unsigned short* props, unsigned short prop, int value);
static CoordSystem checkWCSSystem();
static SkyFrame checkWCSSky();


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 60 "tngparser.Y"
typedef union YYSTYPE {
  double real;
  int integer;
  char str[2048];
  double vector[3];
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 229 "tngparser.C"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 241 "tngparser.C"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

# ifndef YYFREE
#  define YYFREE free
# endif
# ifndef YYMALLOC
#  define YYMALLOC malloc
# endif

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   define YYSTACK_ALLOC alloca
#  endif
# else
#  if defined (alloca) || defined (_ALLOCA_H)
#   define YYSTACK_ALLOC alloca
#  else
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (defined (YYSTYPE_IS_TRIVIAL) && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined (__GNUC__) && 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   136

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  51
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  33
/* YYNRULES -- Number of rules. */
#define YYNRULES  80
/* YYNRULES -- Number of states. */
#define YYNSTATES  143

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   296

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      42,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    49,     2,     2,     2,     2,
      45,    46,     2,    47,    44,    48,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    50,    43,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned char yyprhs[] =
{
       0,     0,     3,     6,    10,    13,    14,    17,    19,    23,
      25,    27,    29,    31,    33,    35,    37,    39,    40,    42,
      43,    45,    46,    48,    49,    51,    53,    55,    57,    61,
      63,    67,    71,    75,    77,    79,    81,    83,    85,    86,
      87,    88,    90,    92,   100,   110,   120,   128,   134,   135,
     144,   145,   152,   156,   158,   160,   165,   166,   172,   173,
     179,   180,   184,   185,   188,   191,   194,   197,   200,   203,
     206,   209,   212,   215,   216,   220,   223,   226,   228,   233,
     234
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const yysigned_char yyrhs[] =
{
      52,     0,    -1,    68,    53,    -1,    53,    54,    55,    -1,
      54,    55,    -1,    -1,    16,    57,    -1,    39,    -1,    69,
      70,    71,    -1,    76,    -1,    42,    -1,    43,    -1,     8,
      -1,     4,    -1,     3,    -1,    31,    -1,    30,    -1,    -1,
      44,    -1,    -1,    45,    -1,    -1,    46,    -1,    -1,    62,
      -1,    56,    -1,     6,    -1,    56,    -1,    56,    58,    56,
      -1,     7,    -1,    65,    58,    65,    -1,    56,    58,    56,
      -1,     6,    58,     6,    -1,    21,    -1,    22,    -1,    24,
      -1,    18,    -1,    27,    -1,    -1,    -1,    -1,    47,    -1,
      48,    -1,    13,    59,    66,    58,    63,    60,    80,    -1,
      19,    59,    66,    58,    64,    58,    61,    60,    80,    -1,
      10,    59,    66,    58,    64,    58,    61,    60,    80,    -1,
      28,    59,    66,    58,    66,    60,    80,    -1,    34,    59,
      66,    60,    80,    -1,    -1,    38,    59,    66,    58,     5,
      60,    72,    80,    -1,    -1,    35,    73,    59,    74,    60,
      80,    -1,    74,    58,    75,    -1,    75,    -1,    66,    -1,
      49,    23,    50,    82,    -1,    -1,    49,    20,    50,    77,
       5,    -1,    -1,    49,    15,    50,    78,     5,    -1,    -1,
      49,    79,     5,    -1,    -1,    49,    40,    -1,    49,    11,
      -1,    49,    36,    -1,    49,    25,    -1,    49,    12,    -1,
      49,    14,    -1,    49,    29,    -1,    49,    41,    -1,    49,
      37,    -1,    49,     9,    -1,    -1,    49,    81,     5,    -1,
      26,    83,    -1,    17,    83,    -1,    33,    -1,    33,    45,
      32,    46,    -1,    -1,    45,    67,    46,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,   123,   123,   126,   127,   130,   131,   132,   133,   134,
     137,   138,   139,   142,   143,   146,   147,   150,   151,   154,
     155,   158,   159,   162,   163,   166,   167,   170,   173,   182,
     185,   199,   206,   216,   217,   218,   219,   220,   223,   237,
     250,   251,   252,   255,   261,   268,   275,   282,   287,   287,
     293,   293,   299,   300,   303,   306,   307,   307,   308,   308,
     309,   309,   312,   313,   314,   315,   316,   317,   318,   319,
     320,   321,   326,   331,   331,   334,   335,   336,   337,   341,
     345
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "INT", "REAL", "STRING", "DEGREE",
  "SEXSTR", "EOF_", "BACKGROUND_", "BOX_", "BLACK_", "BLUE_", "CIRCLE_",
  "CYAN_", "DATE_", "DEBUG_", "DEGREES_", "ECLIPTIC_", "ELLIPSE_",
  "FILENAME_", "FK4_", "FK5_", "FORMAT_", "GALACTIC_", "GREEN_", "HMS_",
  "ICRS_", "LINE_", "MAGENTA_", "OFF_", "ON_", "PHYSICAL_", "PIXELS_",
  "POINT_", "POLYGON_", "RED_", "SOURCE_", "TEXT_", "VERSION_", "WHITE_",
  "YELLOW_", "'\\n'", "';'", "','", "'('", "')'", "'+'", "'-'", "'#'",
  "':'", "$accept", "start", "commands", "command", "terminator",
  "numeric", "debug", "sp", "bp", "ep", "optangle", "angle", "value",
  "vvalue", "sexagesimal", "coord", "skyFrame", "initGlobal", "initLocal",
  "include", "shape", "@1", "@2", "polyNodes", "polyNode",
  "generalComment", "@3", "@4", "@5", "shapeComment", "@6", "tngFormat",
  "tngWCS", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,    10,    59,    44,    40,    41,    43,    45,    35,
      58
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,    51,    52,    53,    53,    54,    54,    54,    54,    54,
      55,    55,    55,    56,    56,    57,    57,    58,    58,    59,
      59,    60,    60,    61,    61,    62,    62,    63,    64,    65,
      66,    66,    66,    67,    67,    67,    67,    67,    68,    69,
      70,    70,    70,    71,    71,    71,    71,    71,    72,    71,
      73,    71,    74,    74,    75,    76,    77,    76,    78,    76,
      79,    76,    80,    80,    80,    80,    80,    80,    80,    80,
      80,    80,    80,    81,    80,    82,    82,    82,    82,    83,
      83
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     2,     3,     2,     0,     2,     1,     3,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     1,     0,
       1,     0,     1,     0,     1,     1,     1,     1,     3,     1,
       3,     3,     3,     1,     1,     1,     1,     1,     0,     0,
       0,     1,     1,     7,     9,     9,     7,     5,     0,     8,
       0,     6,     3,     1,     1,     4,     0,     5,     0,     5,
       0,     3,     0,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     0,     3,     2,     2,     1,     4,     0,
       3
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned char yydefact[] =
{
      38,     0,    39,     1,     0,     7,    60,    39,     0,    40,
       9,    16,    15,     6,     0,     0,     0,     0,     0,    12,
      10,    11,     4,    41,    42,     0,    58,    56,     0,    61,
       3,    19,    19,    19,    19,    19,    50,    19,     8,     0,
       0,    79,    79,    77,    55,    20,     0,     0,     0,     0,
       0,    19,     0,    59,    57,     0,    76,    75,     0,    14,
      13,    17,    29,    17,    17,    17,    17,    17,    17,    21,
       0,    17,    36,    33,    34,    35,    37,     0,     0,    18,
       0,     0,     0,     0,     0,     0,     0,    22,    62,    54,
      17,    53,     0,    80,    78,    32,    31,    30,    17,    17,
      27,    21,    17,    21,    73,    47,     0,    62,    21,     0,
      23,    62,    23,    62,    72,    64,    67,    68,    66,    69,
      65,    71,    63,    70,     0,    52,    51,    48,    28,    26,
      25,    21,    24,    43,    21,    46,    74,    62,    62,    62,
      49,    45,    44
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,     7,     8,    22,    63,    13,    80,    46,    88,
     131,   132,   101,    99,    64,    89,    77,     2,     9,    25,
      38,   137,    51,    90,    91,    10,    40,    39,    17,   105,
     124,    44,    56
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -87
static const short yypact[] =
{
     -87,     6,    -5,   -87,   -18,   -87,   -13,     0,    -7,   -28,
     -87,   -87,   -87,   -87,   -41,   -22,    -4,    42,    -7,   -87,
     -87,   -87,   -87,   -87,   -87,    88,   -87,   -87,   -12,   -87,
     -87,     5,     5,     5,     5,     5,   -87,     5,   -87,    56,
      57,    25,    25,    28,   -87,   -87,   129,   129,   129,   129,
     129,     5,   129,   -87,   -87,   107,   -87,   -87,    19,   -87,
     -87,    32,   -87,    32,    32,    32,    32,    32,    32,   -14,
     129,    32,   -87,   -87,   -87,   -87,   -87,    31,    33,   -87,
      75,    37,    77,    37,    37,    37,   129,   -87,    36,   -87,
      10,   -87,    83,   -87,   -87,   -87,   -87,   -87,    32,    32,
     -87,   -14,    32,   -14,    46,   -87,   129,    36,   -14,    37,
      27,    36,    27,    36,   -87,   -87,   -87,   -87,   -87,   -87,
     -87,   -87,   -87,   -87,    84,   -87,   -87,   -87,   -87,   -87,
     -87,   -14,   -87,   -87,   -14,   -87,   -87,    36,    36,    36,
     -87,   -87,   -87
};

/* YYPGOTO[NTERM-NUM].  */
static const yysigned_char yypgoto[] =
{
     -87,   -87,   -87,    89,    79,     9,   -87,     1,    76,   -86,
     -17,   -87,   -87,    17,    30,   -23,   -87,   -87,   -87,   -87,
     -87,   -87,   -87,   -87,     8,   -87,   -87,   -87,   -87,   -33,
     -87,   -87,    73
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -22
static const short yytable[] =
{
      -2,    19,    14,    -5,   107,    41,     3,    15,    -5,    26,
      16,     4,    11,    12,    42,   111,     4,   113,   -21,    23,
      24,    43,   127,    65,    66,    67,    68,    69,    27,    71,
      59,    60,    87,   129,     5,    20,    21,    -5,    -5,     5,
      59,    60,    -5,    -5,     6,   138,    28,    29,   139,     6,
      45,    78,   -21,   -21,    79,   114,    87,   115,   116,   -21,
     117,    53,    54,   103,    81,    82,    83,    84,    85,    86,
      55,   118,    92,    58,   126,   119,    79,    93,   133,    94,
     135,    95,   120,   121,    62,   104,   122,   123,   108,   136,
      96,   106,    98,   100,    98,   134,    18,    30,    31,   109,
     110,    32,   102,   112,   140,   141,   142,    33,    47,    48,
      49,    50,    97,    52,   125,    57,    34,     0,   128,   130,
       0,   130,    35,    36,     0,    72,    37,    70,    73,    74,
       0,    75,    59,    60,    76,    61,    62
};

static const short yycheck[] =
{
       0,     8,    15,     8,    90,    17,     0,    20,     8,    50,
      23,    16,    30,    31,    26,   101,    16,   103,     8,    47,
      48,    33,   108,    46,    47,    48,    49,    50,    50,    52,
       3,     4,    46,     6,    39,    42,    43,    42,    43,    39,
       3,     4,    42,    43,    49,   131,    50,     5,   134,    49,
      45,    32,    42,    43,    44,     9,    46,    11,    12,    49,
      14,     5,     5,    86,    63,    64,    65,    66,    67,    68,
      45,    25,    71,    45,   107,    29,    44,    46,   111,    46,
     113,     6,    36,    37,     7,    49,    40,    41,     5,     5,
      81,    90,    83,    84,    85,   112,     7,    18,    10,    98,
      99,    13,    85,   102,   137,   138,   139,    19,    32,    33,
      34,    35,    82,    37,   106,    42,    28,    -1,   109,   110,
      -1,   112,    34,    35,    -1,    18,    38,    51,    21,    22,
      -1,    24,     3,     4,    27,     6,     7
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    52,    68,     0,    16,    39,    49,    53,    54,    69,
      76,    30,    31,    57,    15,    20,    23,    79,    54,     8,
      42,    43,    55,    47,    48,    70,    50,    50,    50,     5,
      55,    10,    13,    19,    28,    34,    35,    38,    71,    78,
      77,    17,    26,    33,    82,    45,    59,    59,    59,    59,
      59,    73,    59,     5,     5,    45,    83,    83,    45,     3,
       4,     6,     7,    56,    65,    66,    66,    66,    66,    66,
      59,    66,    18,    21,    22,    24,    27,    67,    32,    44,
      58,    58,    58,    58,    58,    58,    58,    46,    60,    66,
      74,    75,    58,    46,    46,     6,    56,    65,    56,    64,
      56,    63,    64,    66,    49,    80,    58,    60,     5,    58,
      58,    60,    58,    60,     9,    11,    12,    14,    25,    29,
      36,    37,    40,    41,    81,    75,    80,    60,    56,     6,
      56,    61,    62,    80,    61,    80,     5,    72,    60,    60,
      80,    80,    80
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrorlab


/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)		\
   ((Current).first_line   = (Rhs)[1].first_line,	\
    (Current).first_column = (Rhs)[1].first_column,	\
    (Current).last_line    = (Rhs)[N].last_line,	\
    (Current).last_column  = (Rhs)[N].last_column)
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if defined (YYMAXDEPTH) && YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 7:
#line 132 "tngparser.Y"
    {cerr << "SAOtng" << endl;;}
    break;

  case 12:
#line 139 "tngparser.Y"
    {YYACCEPT;;}
    break;

  case 13:
#line 142 "tngparser.Y"
    {yyval.real=yyvsp[0].real;;}
    break;

  case 14:
#line 143 "tngparser.Y"
    {yyval.real=yyvsp[0].integer;;}
    break;

  case 15:
#line 146 "tngparser.Y"
    {yydebug=1;;}
    break;

  case 16:
#line 147 "tngparser.Y"
    {yydebug=0;;}
    break;

  case 23:
#line 162 "tngparser.Y"
    {yyval.real = 0;;}
    break;

  case 24:
#line 163 "tngparser.Y"
    {yyval.real = yyvsp[0].real;;}
    break;

  case 25:
#line 166 "tngparser.Y"
    {yyval.real = degToRad(yyvsp[0].real);;}
    break;

  case 26:
#line 167 "tngparser.Y"
    {yyval.real = degToRad(yyvsp[0].real);;}
    break;

  case 27:
#line 170 "tngparser.Y"
    {yyval.real = FITSPTR->mapLenToRef(yyvsp[0].real,IMAGE);;}
    break;

  case 28:
#line 174 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapLenToRef(Vector(yyvsp[-2].real,yyvsp[0].real), IMAGE);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 29:
#line 182 "tngparser.Y"
    {yyval.real = parseDMS(yyvsp[0].str);;}
    break;

  case 30:
#line 186 "tngparser.Y"
    {
	  Vector r;
	  CoordSystem sys = checkWCSSystem();
	  SkyFrame sky = checkWCSSky();
	  if (sky == GALACTIC || sky == ECLIPTIC) 
	    r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real), sys, sky);
	  else
	    r = FITSPTR->mapToRef(Vector(yyvsp[-2].real*360./24.,yyvsp[0].real), sys, sky);

	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 31:
#line 200 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real), localSystem, localSky);
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 32:
#line 207 "tngparser.Y"
    {
	  Vector r = FITSPTR->mapToRef(Vector(yyvsp[-2].real,yyvsp[0].real),
	    checkWCSSystem(), checkWCSSky());
	  yyval.vector[0] = r[0];
	  yyval.vector[1] = r[1];
	  yyval.vector[2] = r[2];
	;}
    break;

  case 33:
#line 216 "tngparser.Y"
    {yyval.integer = FK4;;}
    break;

  case 34:
#line 217 "tngparser.Y"
    {yyval.integer = FK5;;}
    break;

  case 35:
#line 218 "tngparser.Y"
    {yyval.integer = GALACTIC;;}
    break;

  case 36:
#line 219 "tngparser.Y"
    {yyval.integer = ECLIPTIC;;}
    break;

  case 37:
#line 220 "tngparser.Y"
    {yyval.integer = ICRS;;}
    break;

  case 38:
#line 223 "tngparser.Y"
    {
	  // global properties
	  globalSystem = IMAGE;
	  globalSky = NATIVEWCS;
	  globalProps =
	    Marker::SELECT | Marker::EDIT | Marker::MOVE |
	    Marker::ROTATE | Marker::DELETE | Marker::HIGHLITE |
	    Marker::INCLUDE | Marker::SOURCE;
	  strcpy(globalColor,"green");
	  strcpy(globalFont,"helvetica 10 normal");
	  strcpy(globalText,"");
	;}
    break;

  case 39:
#line 237 "tngparser.Y"
    {
	  // global properties
	  localSystem = globalSystem;
	  localSky = localSky;
	  localProps = globalProps;
	  strcpy(localColor,globalColor);
	  strcpy(localText,globalText);
	  strcpy(localComment,"");

	  strcpy(globalText,"");
	;}
    break;

  case 40:
#line 250 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 41:
#line 251 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 1);;}
    break;

  case 42:
#line 252 "tngparser.Y"
    {setProps(&localProps, Marker::INCLUDE, 0);;}
    break;

  case 43:
#line 256 "tngparser.Y"
    {FR->createCircleCmd(Vector(yyvsp[-4].vector),
	    yyvsp[-2].real,
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 44:
#line 262 "tngparser.Y"
    {FR->createEllipseCmd(Vector(yyvsp[-6].vector),
	    Vector(yyvsp[-4].vector),
	    yyvsp[-2].real,
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 45:
#line 269 "tngparser.Y"
    {FR->createBoxCmd(Vector(yyvsp[-6].vector),
	    Vector(yyvsp[-4].vector),
	    yyvsp[-2].real,
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 46:
#line 276 "tngparser.Y"
    {FR->createLineCmd(Vector(yyvsp[-4].vector),
	    Vector(yyvsp[-2].vector),
	    0,0,
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 47:
#line 283 "tngparser.Y"
    {FR->createBoxCirclePointCmd(Vector(yyvsp[-2].vector),
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 48:
#line 287 "tngparser.Y"
    {strncpy(localText,yyvsp[-1].str,80);;}
    break;

  case 49:
#line 288 "tngparser.Y"
    {FR->createTextCmd(Vector(yyvsp[-5].vector),
	    0,
	    localColor,1,globalFont,localText,
	    localProps,localComment,taglist,cblist);;}
    break;

  case 50:
#line 293 "tngparser.Y"
    {polylist.deleteAll();;}
    break;

  case 51:
#line 294 "tngparser.Y"
    {FR->createPolygonCmd(polylist,
	      localColor,1,globalFont,localText,
	      localProps,localComment,taglist,cblist);;}
    break;

  case 54:
#line 303 "tngparser.Y"
    {polylist.append(new Vertex(yyvsp[0].vector));;}
    break;

  case 56:
#line 307 "tngparser.Y"
    {DISCARD_(0);}
    break;

  case 58:
#line 308 "tngparser.Y"
    {DISCARD_(0);}
    break;

  case 60:
#line 309 "tngparser.Y"
    {DISCARD_(1);}
    break;

  case 61:
#line 309 "tngparser.Y"
    {strncpy(globalText,yyvsp[0].str,80);;}
    break;

  case 63:
#line 313 "tngparser.Y"
    {strcpy(localColor,"white");;}
    break;

  case 64:
#line 314 "tngparser.Y"
    {strcpy(localColor,"black");;}
    break;

  case 65:
#line 315 "tngparser.Y"
    {strcpy(localColor,"red");;}
    break;

  case 66:
#line 316 "tngparser.Y"
    {strcpy(localColor,"green");;}
    break;

  case 67:
#line 317 "tngparser.Y"
    {strcpy(localColor,"blue");;}
    break;

  case 68:
#line 318 "tngparser.Y"
    {strcpy(localColor,"cyan");;}
    break;

  case 69:
#line 319 "tngparser.Y"
    {strcpy(localColor,"magenta");;}
    break;

  case 70:
#line 320 "tngparser.Y"
    {strcpy(localColor,"yellow");;}
    break;

  case 71:
#line 322 "tngparser.Y"
    {
	  strcpy(localColor,"green");
	  setProps(&localProps,Marker::SOURCE,1);
	;}
    break;

  case 72:
#line 327 "tngparser.Y"
    {
	  strcpy(localColor,"red");
	  setProps(&localProps,Marker::SOURCE,0);
	;}
    break;

  case 73:
#line 331 "tngparser.Y"
    {DISCARD_(1);}
    break;

  case 74:
#line 331 "tngparser.Y"
    {strncpy(localComment,yyvsp[0].str,80);;}
    break;

  case 77:
#line 336 "tngparser.Y"
    {globalSystem = localSystem = IMAGE;;}
    break;

  case 78:
#line 337 "tngparser.Y"
    {globalSystem = localSystem = IMAGE;;}
    break;

  case 79:
#line 341 "tngparser.Y"
    {
	    globalSystem = localSystem = WCS;
	    globalSky = localSky = NATIVEWCS;
	  ;}
    break;

  case 80:
#line 346 "tngparser.Y"
    {
	    globalSystem = localSystem = WCS;
	    globalSky = localSky = (SkyFrame)yyvsp[-1].integer;
	  ;}
    break;


    }

/* Line 1000 of yacc.c.  */
#line 1621 "tngparser.C"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  const char* yyprefix;
	  char *yymsg;
	  int yyx;

	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  int yyxbegin = yyn < 0 ? -yyn : 0;

	  /* Stay within bounds of both yycheck and yytname.  */
	  int yychecklim = YYLAST - yyn;
	  int yyxend = yychecklim < YYNTOKENS ? yychecklim : YYNTOKENS;
	  int yycount = 0;

	  yyprefix = ", expecting ";
	  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      {
		yysize += yystrlen (yyprefix) + yystrlen (yytname [yyx]);
		yycount += 1;
		if (yycount == 5)
		  {
		    yysize = 0;
		    break;
		  }
	      }
	  yysize += (sizeof ("syntax error, unexpected ")
		     + yystrlen (yytname[yytype]));
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yyprefix = ", expecting ";
		  for (yyx = yyxbegin; yyx < yyxend; ++yyx)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			yyp = yystpcpy (yyp, yyprefix);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yyprefix = " or ";
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* If at end of input, pop the error token,
	     then the rest of the stack, then return failure.  */
	  if (yychar == YYEOF)
	     for (;;)
	       {
		 YYPOPSTACK;
		 if (yyssp == yyss)
		   YYABORT;
		 YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
		 yydestruct (yystos[*yyssp], yyvsp);
	       }
        }
      else
	{
	  YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
	  yydestruct (yytoken, &yylval);
	  yychar = YYEMPTY;

	}
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:

#ifdef __GNUC__
  /* Pacify GCC when the user code never invokes YYERROR and the label
     yyerrorlab therefore never appears in user code.  */
  if (0)
     goto yyerrorlab;
#endif

  yyvsp -= yylen;
  yyssp -= yylen;
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      YYPOPSTACK;
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 352 "tngparser.Y"


static void setProps(unsigned short* props, unsigned short prop, int value)
{
  if (value)
    *props |= prop;
  else
    *props &= ~prop;
}

static CoordSystem checkWCSSystem()
{
  switch (localSystem) {
  case IMAGE:
  case PHYSICAL:
    return WCS;
  default:
    return localSystem;
  }
}

static SkyFrame checkWCSSky()
{
  switch (localSystem) {
  case IMAGE:
  case PHYSICAL:
    return NATIVEWCS;
  default:
   return localSky;
  }
}

