#
# SchoolTool - common information systems platform for school administration
# Copyright (c) 2008 Shuttleworth Foundation
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
"""
Initial deployment of generations to schooltool.intervention.

Manually evolves to generation 1. Needed to support upgrade from a database
that did not have generations (schooltool.intervention << 0.1.3)
"""

import evolve1
import evolve2
import evolve3
import evolve4
import evolve5
import evolve6


def evolve(context):
    evolve1.evolve(context)
    evolve2.evolve(context)
    evolve3.evolve(context)
    evolve4.evolve(context)
    evolve5.evolve(context)
    evolve6.evolve(context)
    # XXX: ...ad infinitum.  This does not look good, it's prone to human error
    #      and all evolutions are executed in a *single* transaction as opposed
    #      to regular evolving.  Yet zope.app.generations do not support
    #      multiple step install evolutions.  Install is done in a single
    #      transaction, period.  And that is bad.
