// ==========================================================
// Definition of Planetary data : 
// equatorial and polar radii and mu for solar system planets
// Source: IMCCE http://www.imcce.fr
// 
// Syntax: 
// data.planet = [eqRad, polRad, mu] 
// eqRad:  Equatorial radius (m) 
// polRad: Polar radius (m)
// mu:     Gravitational constant (m^3/s^2)
// 
// (scilab syntax) 
// ==========================================================

data.mercury = [    2439700       2439700       22032080000000 ]

data.venus   = [    6051800       6051800      324858600000000 ]

// data.Earth : same values as in physical_data.scd for consistency (JGM3)
data.earth   = [  6378136.3  6378136.3*(1-1/298.25781) 3.986004415e14  ] 

data.mars    = [    3396190       3376200       42828314000000 ]

data.jupiter = [   71492000      66854000      1.26686537e+017 ]

data.saturn  = [   60268000      54364000         3.79312e+016 ]

data.uranus  = [   25559000      24973000       5.7939393e+015 ]

data.neptune = [   24764000      24341000        6.835107e+015 ]

data.pluto   = [    1195000       1195000         826100000000 ]  // although not a planet any more ! 
