/*
 * Scilab ( http://www.scilab.org/ ) - This file is part of Scilab
 * Copyright (C) 2010 - DIGITEO - Yann Collette
 * 
 * This file must be used under the terms of the CeCILL.
 * This source file is licensed as described in the file COPYING, which
 * you should have received as part of this distribution.  The terms
 * are also available at    
 * http://www.cecill.info/licences/Licence_CeCILL_V2-en.txt
 *
 */
#include <sci_mysql.h>

int sci_mysql_ssl_set(char * fname)
{
  int * sql_pointer_in = NULL;
  int * key = NULL;
  int * cert = NULL;
  int * ca = NULL;
  int * capath = NULL;
  int * cipher = NULL;
  char * ckey = NULL, * ccert = NULL, * cca = NULL, * ccapath = NULL, * ccipher = NULL;
  MYSQL * mysql_ptr_in = NULL;
  void * ptr_in = NULL;
  SciErr _SciErr;
  double result;

  CheckRhs(1,6);
  CheckLhs(0,1);

  _SciErr = getVarAddressFromPosition(pvApiCtx, 1, &sql_pointer_in);
  getPointer(pvApiCtx, sql_pointer_in, &ptr_in);
  mysql_ptr_in = (MYSQL *)ptr_in;

  if (mysql_ptr_in==NULL)
    {
      Scierror(999,"%s: problem with the mysql pointer\n", fname);
      return 0;
    }

  if (Rhs>=2)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 2, &key);
      if (!isEmptyMatrix(pvApiCtx, key)) getAllocatedSingleString(pvApiCtx, key, &ckey);
      else                               ckey = NULL;
    }
  else
    {
      ckey = NULL;
    }
  if (Rhs>=3)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 3, &cert);
      if (!isEmptyMatrix(pvApiCtx, cert)) getAllocatedSingleString(pvApiCtx, cert, &ccert);
      else                                ccert = NULL;
    }
  else
    {
      ccert = NULL;
    }
  if (Rhs>=4)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 4, &ca);
      if (!isEmptyMatrix(pvApiCtx, ca)) getAllocatedSingleString(pvApiCtx, ca, &cca);
      else                              cca = NULL;
    }
  else
    {
      cca = NULL;
    }
  if (Rhs>=5)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 5, &capath);
      if (!isEmptyMatrix(pvApiCtx, capath)) getAllocatedSingleString(pvApiCtx, capath, &ccapath);
      else                                  ccapath = NULL;
    }
  else
    {
      ccapath = NULL;
    }
  if (Rhs>=6)
    {
      _SciErr = getVarAddressFromPosition(pvApiCtx, 6, &cipher);
      if (!isEmptyMatrix(pvApiCtx, cipher)) getAllocatedSingleString(pvApiCtx, cipher, &ccipher);
      else                                  ccipher = NULL;
    }
  else
    {
      ccipher = NULL;
    }
  
  result = (double)mysql_ssl_set(mysql_ptr_in, ckey, ccert, cca, ccapath, ccipher);
  createScalarDouble(pvApiCtx, Rhs+1, result);

  LhsVar(1) = Rhs + 1;

  if (ckey)    freeAllocatedSingleString(ckey);
  if (ccert)   freeAllocatedSingleString(ccert);
  if (cca)     freeAllocatedSingleString(cca);
  if (ccapath) freeAllocatedSingleString(ccapath);
  if (ccipher) freeAllocatedSingleString(ccipher);

  return 0;
}
