/* $Id: parse_config.c,v 1.8 2003/05/30 00:42:37 cgd Exp $ */

/*
 * Copyright 2001, 2003
 * Broadcom Corporation. All rights reserved.
 *
 * This software is furnished under license and may be used and copied only
 * in accordance with the following terms and conditions.  Subject to these
 * conditions, you may download, copy, install, use, modify and distribute
 * modified or unmodified copies of this software in source and/or binary
 * form. No title or ownership is transferred hereby.
 *
 * 1) Any source code used, modified or distributed must reproduce and
 *    retain this copyright notice and list of conditions as they appear in
 *    the source file.
 *
 * 2) No right is granted to use any trade name, trademark, or logo of
 *    Broadcom Corporation.  The "Broadcom Corporation" name may not be
 *    used to endorse or promote products derived from this software
 *    without the prior written permission of Broadcom Corporation.
 *
 * 3) THIS SOFTWARE IS PROVIDED "AS-IS" AND ANY EXPRESS OR IMPLIED
 *    WARRANTIES, INCLUDING BUT NOT LIMITED TO, ANY IMPLIED WARRANTIES OF
 *    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR
 *    NON-INFRINGEMENT ARE DISCLAIMED. IN NO EVENT SHALL BROADCOM BE LIABLE
 *    FOR ANY DAMAGES WHATSOEVER, AND IN PARTICULAR, BROADCOM SHALL NOT BE
 *    LIABLE FOR DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *    CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *    SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *    BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *    WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 *    OR OTHERWISE), EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "libc.h"
#include "parse_config.h"

static unsigned int timeout = 5;
static unsigned int prompt = 0;
static char *default_name = 0;
static unsigned int parse_line = 1;

boot_config_t *boot_config;

typedef struct boot_config_node_struct {
	char *name;
	boot_config_t *config;
	struct boot_config_node_struct *next;
} boot_config_node_t;

static boot_config_node_t *config_chain = 0;


static void parse_die()
{
	lib_printf("Error parsing config file at line %i\n", parse_line);
	lib_exit();
}

static void remove_comments(char *buf)
{
	char *ptr;
	for (ptr = buf; *ptr; ptr++) {
		if (*ptr == '#') {
			*ptr = ' ';
			while (*ptr != '\n') {
				if (!*ptr) {
					return;
				}
				*ptr = ' ';
				ptr++;
			}
		}
	}
}


static void skip_whitespace(char **ptr) 
{
	while (lib_isspace(**ptr)) {
		if (**ptr == '\n') {
			parse_line++;
		}
		(*ptr)++;
	}
}


static void skip_to_end_of_token(char **ptr) 
{
	while (!lib_isspace(**ptr) 
	       && (**ptr != ';')
	       && (**ptr != '=')
	       && (**ptr != '{')
	       && (**ptr != '}')
	       && (**ptr)) {
		(*ptr)++;
	}
}

static void skip_to_char(char **ptr, char targ)
{
	while (**ptr != targ) {
		if (**ptr == '\n') {
			parse_line++;
		}
		if (!**ptr) {
			parse_die();
		}
		(*ptr)++;
	}
}

static int get_normal_arg(char **start_ptr, char **dest)
{
	char *ptr = *start_ptr;
	char *ptr2;
	char saved_char;
	skip_whitespace(&ptr);
	if (*ptr != '=') {
		return 0;
	}
	ptr++;
	skip_whitespace(&ptr);
	ptr2 = ptr;
	skip_to_end_of_token(&ptr);
	saved_char = *ptr;
	*ptr = 0;
	(*dest) = lib_strdup(ptr2);
	if (!*dest) {
		parse_die();
	}
	*ptr = saved_char;
	skip_whitespace(&ptr);
	if (*ptr != ';') {
		return 0;
	}
	ptr++;
	*start_ptr = ptr;
	return 1;
}

static void parse_config(char **start_ptr)
{
	char *ptr = *start_ptr;
	char *ptr2;
	char saved_char;
	boot_config_node_t *new_node;
	boot_config_node_t *tmp_node;
	new_node = lib_malloc(sizeof(boot_config_node_t));
	if (!new_node) {
		parse_die();
	}
//	lib_bzero(new_node, sizeof(boot_config_node_t));
	new_node->config = lib_malloc(sizeof(boot_config_t));
	if (!new_node->config) {
		parse_die();
	}
	lib_bzero(new_node->config, sizeof(boot_config_t));

	if (!config_chain) {
		config_chain = new_node;
	} else {
		for (tmp_node = config_chain; 
		     tmp_node->next; tmp_node = tmp_node->next) {
			/* Do nothing */
		}
		tmp_node->next = new_node;
	}
	new_node->next = 0;

	skip_whitespace(&ptr);
	ptr2 = ptr;
	skip_to_end_of_token(&ptr);
	if (!*ptr) {
		parse_die();
	}
	saved_char = *ptr;
	*ptr = 0;
	if (!default_name) {
		default_name = lib_strdup(ptr2);
		if (!default_name) {
			parse_die();
		}
	}
	new_node->name = lib_strdup(ptr2);
	if (!new_node->name) {
		parse_die();
	}
	*ptr = saved_char;
	skip_whitespace(&ptr);
	if (*ptr != '{') {
		parse_die();
	}
	ptr++;
	skip_whitespace(&ptr);
	for ( ; *ptr != '}'; skip_whitespace(&ptr)) {
		ptr2 = ptr;
		skip_to_end_of_token(&ptr);
		if (!*ptr) {
			parse_die();
		}
		saved_char = *ptr;
		*ptr = 0;
		if (!lib_strcmp(ptr2, "kernel")) {
			*ptr = saved_char;
			if (!get_normal_arg(&ptr, 
					    &new_node->config->kernel)) {
				parse_die();
			}
		} else if (!lib_strcmp(ptr2, "initrd")) {
			*ptr = saved_char;
			get_normal_arg(&ptr, &new_node->config->initrd);
		} else if (!lib_strcmp(ptr2, "root_dev")) {
			*ptr = saved_char;
			get_normal_arg(&ptr, &new_node->config->root_dev);
		} else if (!lib_strcmp(ptr2, "extra_args")) {
			*ptr = saved_char;
			skip_whitespace(&ptr);
			if (*ptr != '=') {
				parse_die();
			}
			ptr++;
			ptr2 = ptr;
			skip_to_char(&ptr, ';');
			if (!*ptr) {
				parse_die();
			}
			*ptr = 0;
			new_node->config->extra_args = lib_strdup(ptr2);
			if (!new_node->config->extra_args) {
				parse_die();
			}
			*ptr = ';';
			ptr++;
		} else {
			parse_die();
		}
	}
	for (tmp_node = config_chain; tmp_node; tmp_node = tmp_node->next) {
		if ((tmp_node != new_node)
		    && (!lib_strcmp(tmp_node->name, new_node->name))) {
			lib_printf("Duplicate config name: %s",
				   new_node->name);
			parse_die();
		}
	}
	if (!new_node->config->kernel) {
		lib_printf("Config %s doesn't specify a kernel\n",
			   new_node->name);
		parse_die(); 
	}
	if (!new_node->config->root_dev) {
		lib_printf("Config %s doesn't specify a root device\n",
			  new_node->name);
		parse_die();
	}
	*start_ptr = ptr;
}

static void parse_buf(char *buf)
{
	char *ptr, *ptr2;
	char saved_char;
	ptr = buf;
	skip_whitespace(&ptr);
	for ( ; *ptr; skip_whitespace(&ptr)) {
		ptr2 = ptr;
		skip_to_end_of_token(&ptr);
		if (!*ptr) {
			parse_die();
		}
		saved_char = *ptr;
		*ptr = 0;
		if (!lib_strcmp(ptr2, "prompt")) {
			*ptr = saved_char;
			skip_whitespace(&ptr);
			if (*ptr != ';') {
				parse_die();
			}
			ptr++;
			prompt = 1;
		} else if (!lib_strcmp(ptr2, "timeout")) {
			*ptr = saved_char;
			skip_whitespace(&ptr);
			if (*ptr != '=') {
				parse_die();
			}
			ptr++;
			skip_whitespace(&ptr);
			if (!lib_isdigit(*ptr)) {
				parse_die();
			}
			timeout = 0;
			while (lib_isdigit(*ptr)) {
				timeout *= 10;
				timeout += (*ptr - '0');
				ptr++;
			}
			skip_whitespace(&ptr);
			if (*ptr != ';') {
				parse_die();
			}
			ptr++;
		} else if (!lib_strcmp(ptr2, "default")) {
			*ptr = saved_char;
			skip_whitespace(&ptr);
			if (*ptr != '=') {
				parse_die();
			}
			ptr++;
			skip_whitespace(&ptr);
			if (!*ptr) {
				parse_die();
			}
			ptr2 = ptr;
			skip_to_end_of_token(&ptr);
			if (!*ptr) {
				parse_die();
			}
			saved_char = *ptr;
			*ptr = 0;
			if (default_name) {
				lib_free(default_name);
			}
			default_name = lib_strdup(ptr2);
			*ptr = saved_char;
			skip_whitespace(&ptr);
			if (*ptr != ';') {
				parse_die();
			}
			ptr++;
		} else if (!lib_strcmp(ptr2, "config")) {
			*ptr = saved_char;
			parse_config(&ptr);
			ptr++;
		}
	}
}

void gets(char *buf,int buflen,int timeout)
{
    int got_choice;
    int buf_ptr;
    uint64_t timeout_start;

    buf_ptr = 0;
    got_choice = 0;
    timeout_start = lib_get_time();

    while(!got_choice) {
	char foo;
	if (timeout && 
	    (((lib_get_time() - timeout_start)>>20) 
	     >= timeout)) {
	    got_choice = 1;
	    buf[0] = 0;
	    }
	if (lib_poll_input(&foo)) {
	    timeout = 0;
	    /* Pity the fool that has to use
	       this terminal emulation...*/
	    switch (foo) {
		case '\n':
		case '\r':
		    got_choice = 1;
		    buf[buf_ptr] = 0;
		    break;
		case '\b':
		    if (buf_ptr > 0) {
			lib_printf("\b \b");
			buf_ptr--;
			}
		    break;
		default:
		    if ((foo < 32) || (foo >= 127)) break;
		    buf[buf_ptr++] = foo;
		    if (foo == '\r') {
			foo = '\n';
			}
		    lib_printf("%c", foo);
		    if (buf_ptr == buflen) {
			buf[buf_ptr] = 0;
			got_choice = 1;
			}
		    break;
		}
	    }
	}
    lib_printf("\n");
}

void parse_config_buf(char *buf)
{
    boot_config_node_t *tmp, *next;

    remove_comments(buf);

    parse_buf(buf);
    if (!config_chain) {
	lib_printf("No configurations found\n");
	lib_exit();
	}
	
    for (tmp = config_chain; tmp; tmp = tmp->next) {
	if (!lib_strcmp(default_name, tmp->name)) {
	    break;
	    }
	}
    if (!tmp) {
	lib_printf("Default configuration %s doesn't exist.  Using"
		   " %s instead\n", default_name);
	lib_free(default_name);
	default_name = lib_strdup(config_chain->name);
	if (!default_name) {
	    parse_die();
	    }
	prompt = 1;
	}

    while (prompt) {
	char buf[64];
	lib_printf("Available configurations:\n");
	for (tmp = config_chain; tmp; tmp = tmp->next) {
	    lib_printf("  %s\n", tmp->name);
	    }
	lib_printf("Boot which configuration [%s]: ", default_name);
	gets(buf,sizeof(buf),timeout);

	if (buf[0] == 0) {
	    prompt = 0;
	    } 
	else {
	    for (tmp = config_chain; tmp; tmp = tmp->next) {
		if (!lib_strcmp(buf, tmp->name)) {
		    break;
		    }
		}
	    if (!tmp) {
		lib_printf("No such configuration\n");
		} 
	    else {
		lib_free(default_name);
		default_name = lib_strdup(buf);
		if (!default_name) {
		    parse_die();
		    }
		prompt = 0;
		}
	    }
	} 
	
    for (tmp = config_chain; tmp; tmp = next) {
	if (!lib_strcmp(default_name, tmp->name)) {
	    boot_config = tmp->config;
	    } 
	else {
	    lib_free(tmp->config->kernel);
	    lib_free(tmp->config->root_dev);
	    lib_free(tmp->config->initrd);
	    lib_free(tmp->config->extra_args);
	    lib_free(tmp->config);
	    }
	lib_free(tmp->name);
	next = tmp->next;
	lib_free(tmp);
	}
    lib_free(default_name);
	
}

