# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: css stylesheets

=end
module SiSU_Style
  require "#{SiSU_lib}/sysenv"
  require "#{SiSU_lib}/defaults"
  class CSS
    def initialize
      @vz=SiSU_Env::Get_init.instance.skin
      #@vz=SiSU_Viz::Skin.new
    end
    def fonts
      @vz.font_fonts
    end
    def html_tables                               #stylesheet for css table_pages
<<WOK
/* SiSU table output stylesheet */
  body {
    color: black;
    background: #{@vz.color_white};
  }
  p {
    display: block;
    line-height: 1.5;
    font-family: #{fonts};
  }
  a:link {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
  }
  a:visited {
    color: #{@vz.color_blue_ink};
    text-decoration: none;
    /* background-color: #{@vz.color_blue_tinge}; */
  }
  a:hover {
    color: #{@vz.color_black};
    text-decoration: underline;
    background-color: #{@vz.color_yellow_light};
  }
  a:active {
    color: #{@vz.color_blue_ink};
    text-decoration: underline;
  }
WOK
    end
    def harvest
      <<WOK
/* SiSU harvest css default stylesheet */
  body {
    color: black;
    background: "#ffffff";
    background-color: "#ffffff";
  }
  a:link {
    color: #003399;
    text-decoration: none;
  }
  a:visited {
    color: #003399;
    text-decoration: none;
  }
  a:hover {
    color: #000000;
    background-color: #f9f9aa;
  }
  a:hover img {
    background-color: "#ffffff";
  }
  a:active {
    color: #003399;
    text-decoration: underline;
  }

  .norm, .bold {
    line-height: 150%;
    margin-left: 1em;
    margin-right: 2em;
    margin-top: 10px;
    margin-bottom: 0px;
    text-indent: 0mm;
  }
  p, h0, h1, h2, h3, h4, h5, h6 {
    display: block;
    font-family: verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman;
    font-size: 100%;
    font-weight: normal;
    line-height: 150%;
    /* text-align: justify; */
    margin-left: 1em;
    text-indent: 0mm;
    margin-top: 2px;
    margin-bottom: 2px;
    margin-right: 6px;
    text-align: left;
  }
  h1 {
    font-size: 120%;
    font-weight: bold;
    color: white;
    background: #000088;
    margin-left: 0em;
  }
  p.work {
    font-size: 80%;
    margin-left: 5em;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
  }
  p.author {
    font-size: 100%;
    margin-left: 2em;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
  }
  p.publication {
    font-size: 80%;
    margin-left: 4em;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
  }
  p.letter {
    font-weight: bold;
    font-size: 60%;
    margin-left: 1em;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
    color: white;
    background: #880000;
  }
  p.lev0 {
    font-size: 120%;
    margin-left: 1em;
    color: white;
    background: #000000;
  }

  p.lev1 {
    font-size: 110%;
    margin-left: 2em;
    color: white;
    background: #444444;
  }

  p.lev2 {
    font-size: 100%;
    margin-left: 3em;
    background: #888888;
  }

  p.lev3 {
    font-size: 90%;
    margin-left: 4em;
    background: #bbbbbb;
  }

  p.lev4 {
    font-size: 80%;
    margin-left: 5em;
    background: #eeeeee;
  }

  p.lev5 {
    font-size: 80%;
    margin-left: 6em;
  }
WOK
    end
    def html                                      #stylesheet for css html pages == html.css
<<WOK
/* SiSU css default stylesheet */
  body {
    color: black;
    background: "#ffffff";
    background-color: "#ffffff";
  }
/*
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
      vertical-align: top;
    }
*/
  a:link {
    color: #003399;
    text-decoration: none;
  }
  a:visited {
    color: #003399;
    text-decoration: none;
  }
  a:hover {
    color: #000000;
    background-color: #f9f9aa;
  }
/*
  a:hover {
    border-bottom: 2px solid #777777;
    background-color: #fff3b6;
  }
*/
  a:hover img {
    background-color: "#ffffff";
  }
  a:active {
    color: #003399;
    text-decoration: underline;
  }
  div {
    margin-left: 0;
    margin-right: 0;
  }
  div.p {
    margin-left: 5%;
    margin-right: 1%;
  }

  #top_band {
    position: absolute;
    top: 0;
    bottom: 80px;
    width: 100%;
  }
  #top_band_search {
    position: absolute;
    top: 0px;
    right: 0px;
    margin-left: 75%;
    width: 20%;
  }
  #column_left {
    position: absolute;
    top: 80px;
    left: 0;
    margin-left: 1%;
    width: 20%;
  }
  #column_center {
    position: absolute;
    top: 80px;
    margin-left: 20%;
    width: 55%;
  }
  #column_right {
    position: absolute;
    top: 80px;
    right: 0px;
    margin-left: 75%;
    width: 25%;
  }
  #pane_major {
    position: absolute;
    top: 0px;
    left: 0;
    margin-left: 0;
    width: 80%;
  }
  #pane_minor {
    position: absolute;
    top: 0px;
    right: 0px;
    margin-left: 75%;
    width: 20%;
  }

  .norm, .bold {
    line-height: 150%;
    margin-left: 0em;
    margin-right: 2em;
    margin-top: 10px;
    margin-bottom: 0px;
    text-indent: 0mm;
  }
  p, h0, h1, h2, h3, h4, h5, h6 {
    display: block;
    font-family: verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman;
    font-size: 100%;
    font-weight: normal;
    line-height: 150%;
    text-align: justify;
    margin-left: 0em;
    margin-right: 2em;
    text-indent: 0mm;
    margin-top: 3px;
    margin-bottom: 3px;
  }
  p.norm { }
  p.i1 {margin-left: 1em;}
  p.i2 {margin-left: 2em;}
  p.i3 {margin-left: 3em;}
  p.i4 {margin-left: 4em;}
  p.i5 {margin-left: 5em;}
  p.i6 {margin-left: 6em;}
  p.i7 {margin-left: 7em;}
  p.i8 {margin-left: 8em;}
  p.i9 {margin-left: 9em;}

  p.it0 {
    margin-left: 0em;
    margin-top: 6px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it1 {
    margin-left: 1em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it2 {
    margin-left: 2em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it3 {
    margin-left: 3em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it4 {
    margin-left: 4em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it5 {
    margin-left: 5em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it6 {
    margin-left: 6em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it7 {
    margin-left: 7em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it8 {
    margin-left: 8em;
    margin-top: 0px;
    margin-bottom: 0px;
    line-height: 100%;
  }
  p.it9 {
    margin-left: 9em;
    margin-bottom: 0px;
    margin-top: 0px;
    line-height: 100%;
  }

  p.code {
    font-family: inconsolata, andale mono, courier new, courier, monospace;
    font-size: 90%;
    text-align: left;
  }

  p.caption {
    text-align: left;
    font-size: 80%;
    display: inline;
  }

  p.endnote {
    font-size: 96%;
    line-height: 120%;
    text-align: left;
    margin-right: 15mm;
  }
  p.endnote_indent {
    font-size: 96%;
    line-height: 120%;
    text-align: left;
    margin-left: 2em;
    margin-right: 15mm;
  }

  p.center {
    text-align: center;
  }
  p.bold {
    font-weight: bold;
  }
  p.bold_left {
    font-weight: bold;
    text-align: left;
  }
  p.centerbold {
    text-align: center;
    font-weight: bold;
  }
  p.em {
    font-weight: bold;
    font-style: normal;
    background: #fff3b6;
  }

  p.small {
    font-size: 80%;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 6px;
    text-align: left;
  }

  .tiny, .tiny_left, .tiny_right, .tiny_center {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 6px;
    text-align: left;
  }
  p.tiny { }
  p.tiny_left {
    margin-left: 0px;
    margin-right: 0px;
    text-align: left;
  }
  p.tiny_right {
    margin-right: 1em;
    text-align: right;
  }
  p.tiny_center {
    margin-left: 0px;
    margin-right: 0px;
    text-align: center;
  }

  p.pane, p.pane_title, p.pane_blurb, p.pane_link, p.pane_indent {
    font-size: 80%;
    margin-top: 0px;
    margin-bottom: 0px;
    margin-left: 2mm;
    margin-right: 4px;
    text-align: left;
  }
  p.pane { }
  p.pane_title {
    font-weight: bold;
    margin-bottom: 0px;
  }
  p.pane_blurb {
    font-size: 10px;
    margin-bottom: 0px;
  }
  p.pane_link {
    font-size: 10px;
    margin-bottom: 0px;
    margin-left: 4mm;
  }
  p.pane_indent {
    font-size: 10px;
    margin-bottom: 0px;
    margin-left: 4mm;
  }

  p.concordance_word {
    line-height: 150%;
    font-weight: bold;
    display: inline;
    margin-top: 4px;
    margin-bottom: 1px;
  }
  p.concordance_count {
    font-size: 80%;
    color: #777777;
    display: inline;
    margin-left: 0em;
  }
  p.concordance_object {
    font-size: 80%;
    line-height: 120%;
    text-align: left;
    margin-left: 3em;
    margin-top: 1px;
    margin-bottom: 3px;
  }
  p.book_index_lev1 {
    line-height: 100%;
    margin-top: 4px;
    margin-bottom: 1px;
  }
  p.book_index_lev2 {
    line-height: 100%;
    text-align: left;
    margin-left: 3em;
    margin-top: 1px;
    margin-bottom: 3px;
  }

  p.quickref {
    font-size: 10px;
    font-style: italic;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 5px;
    text-align: left;
  }
  p.bigref {
    font-size: 11px;
    font-weight: bold;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-right: 5px;
    text-align: center;
  }

  p.letter {
    font-weight: bold;
    font-size: 80%;
    margin-left: 0em;
    margin-top: 2px;
    margin-bottom: 2px;
    margin-right: 6px;
    text-align: left;
    color: white;
    background: #880000;
  }

  label.ocn {
    width: 2%;
    float: right;
    top: 0;
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 5px;
    color: #777777;
    margin-right: 5px;
    text-align: right;
    background-color: #ffffff;
  }

  table { }
  tr { }
  th, td { vertical-align: top; }

  p.left, th.left, td.left {
    text-align: left;
  }
  p.small_left, th.small_left, td.small_left {
    text-align: left;
    font-size: 80%;
  }
  p.right, th.right, td.right {
    text-align: right;
  }

  #horizontal_links {
    background: #eeeeee;
    margin-left: 5%;
    margin-right: 5%;
  }
  #horizontal {
    margin: 0;
    padding: 0 0 0 10px;
    border-top: 1px solid #000077;
    border-bottom: 1px solid #000077;
  }
  #horizontal li {
    margin: 0 0 0 0;
    padding: 0 16px 0 0;
    display: inline;
    list-style-type: none;
    text-align: left;
    background: none;
  }
  #horizontal a {
    line-height: 12px;
    margin: 0 0 0 0;
    text-decoration: none;
    color: #000077;
  }
  #horizontal a.active, #horizontal a:hover {
    border-bottom: 2px solid #777777;
    padding-bottom: 2px;
    color: #000077;
  }
  #horizontal a:hover {
    color: #000077;
  }

  #document_versions {
    position: absolute;
    top: 10mm;
    right: 2%;
    width: 12%;
    float: right;
  }

  #vertical_links {
    position: absolute;
    top: 10mm;
    right: 0px;
    width: 20%;
    background: #dddddd;
    float: right;
  }
  #vertical {
    padding: 0 12px 0px 0px;
    margin-left: 2%;
    margin-right: 2%;
  }
  #vertical li {
    display: block;
    list-style-type: none;
  }
  #vertical a {
    line-height: 12px;
    text-decoration: none;
    color: #000077;
  }
  #vertical a.active, #vertical a:hover {
    border-bottom: 2px solid #777777;
    padding-bottom: 2px;
    color: #000077;
  }

  ul, li {
    list-style-type: none;
    list-style: none;
    padding-left: 20px;
    display: block;
    font-family: verdana, arial, georgia, tahoma, sans-serif, helvetica, times, roman;
    font-weight: normal;
    line-height: 150%;
    text-align: left;
    text-indent: 0mm;
    margin-left: 1em;
    margin-right: 2em;
    margin-top: 3px;
    margin-bottom: 3px;
  }

  li {
    background: url(../image/bullet_09.png) no-repeat 0px 6px;
  }

  ul {
  }
  li.bullet { margin-left: 1em; }
  li.i1 { margin-left: 2em; }
  li.i2 { margin-left: 3em; }
  li.i3 { margin-left: 4em; }
  li.i4 { margin-left: 5em; }
  li.i5 { margin-left: 6em; }
  li.i6 { margin-left: 7em; }
  li.i7 { margin-left: 8em; }
  li.i8 { margin-left: 9em; }
  li.i9 { margin-left: 10em; }

  li.doc, li.ref, li.refcenter {
    margin-top: 0px;
    margin-bottom: 0px;
    margin-right: 0px;
    font-size: 8px;
    font-style: normal;
    text-align: left;
  }
  li.doc {
    background: url(../image/bullet_09.png) no-repeat 0px 6px;
    padding-left: 16px;
    margin-left: 10px;
    margin-right: 0px;
  }
  li.ref {
    background: none;
    padding-left: 0;
    margin-left: 0;
    color: #777777;
  }
  li.refcenter {
    background: url(../image/bullet_09.png) no-repeat 0px 6px;
    padding-left: 20px;
    margin-left: 10%;
    font-size: 9px;
    color: #777777;
    text-align: center;
  }
  li.refbold {
    list-style-type: none;
    padding-left: 16px;
    margin-left: 0;
    margin-right: 10mm;
    font-weight: bold;
  }

  h0, h1, h2, h3, h4, h5, h6 {
    font-weight: bold;
    line-height: 120%;
    text-align: left;
    margin-top: 20px;
    margin-bottom: 10px;
  }
  h4.norm, h5.norm, h6.norm {
    margin-top: 10px;
    margin-bottom: 0px;
  }
  h1.center, h2.center, h3.center, h4.center, h5.center, h6.center {
    text-align: center;
  }
  h1 { font-size: 120%; }
  h2 { font-size: 115%; }
  h3 { font-size: 110%; }
  h4 { font-size: 105%; }
  h5 { font-size: 100%; }
  h6 { font-size: 100%; }
  h0 { font-size: 80%; }

  h1.i {margin-left: 2em;}
  h2.i {margin-left: 3em;}
  h3.i {margin-left: 4em;}
  h4.i {margin-left: 5em;}
  h5.i {margin-left: 6em;}
  h6.i {margin-left: 7em;}
  h7.i {margin-left: 8em;}
  h8.i {margin-left: 9em;}
  h9.i {margin-left: 10em;}
  h1.top_band {
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 4mm;
    text-indent: 0mm;
    font-weight: bold;
    font-size: 120%;
  }
  h2.top_band_tiny {
    font-size: 10px;
    font-weight: normal;
    margin-top: 0px;
    margin-left: 4mm;
    text-indent: 0mm;
    margin-bottom: 0px;
    color: #777777;
    margin-left: 140px;
    margin-right: 0px;
    text-align: left;
  }

  p.top_band {
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 140px;
    text-indent: 0mm;
    font-weight: bold;
    font-size: 120%;
  }
  p.top_band_tiny {
    font-size: 10px;
    margin-top: 0px;
    margin-bottom: 0px;
    color: #777777;
    margin-left: 140px;
    margin-right: 0px;
    text-align: left;
  }
  p.top_band_image {
    float: left;
    display: inline;
    text-align: left;
    margin-top: 0;
    margin-left: 1mm;
    text-indent: 0mm;
    margin-right: 1mm;
  }

  .banner, .subbanner {
    font-weight: bold;
    text-align: center;
    margin-left: 10mm;
    margin-right: 15mm;
    margin-top: 20px;
    margin-bottom: 10px;
  }

  h1.banner {
    font-size: 120%;
  }
  h1.subbanner {
    font-size: 115%;
  }
  h2.banner {
    font-size: 110%;
  }
  h3.banner {
    color: #990000;
    font-size: 105%;
  }
  h4.banner {
    color: #ff0000;
    font-size: 100%;
  }
  h5.banner {
  }
  h6.banner {
  }

  .toc {
    font-weight: normal;
    margin-top: 6px;
    margin-bottom: 6px;
  }
  h1.toc {
    margin-left: 1em;
    font-size: 115%;
    line-height: 150%;
  }
  h2.toc {
    margin-left: 2em;
    font-size: 110%;
    line-height: 140%;
  }
  h3.toc {
    margin-left: 3em;
    font-size: 105%;
    line-height: 120%;
  }
  h4.toc {
    margin-left: 4em;
    font-size: 100%;
    line-height: 120%;
  }
  h5.toc {
    margin-left: 5em;
    font-size: 95%;
    line-height: 110%;
  }
  h6.toc {
    margin-left: 6em;
    font-size: 90%;
    line-height: 110%;
  }

  .microtoc {
    margin-top: 2px;
    margin-bottom: 2px;
  }

  h1.microtoc {
    margin-left: 0mm;
    font-size: 115%;
  }
  h2.microtoc {
    margin-left: 5mm;
    font-size: 110%;
  }
  h3.microtoc {
    margin-left: 10mm;
    font-size: 105%;
  }
  h4.microtoc {
    margin-left: 15mm;
    font-weight: normal;
    font-size: 100%;
  }
  h5.microtoc {
    margin-left: 20mm;
    font-weight: normal;
    font-size: 95%;
  }
  h6.microtoc {
    margin-left: 25mm;
    font-weight: normal;
    font-size: 90%;
  }

  .subtoc {
    margin-right: 34%;
    font-weight: normal;
  }
  h5.subtoc {
    margin-left: 2em;
    font-size: 80%;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h6.subtoc {
    margin-left: 3em;
    font-size: 75%;
    margin-top: 0px;
    margin-bottom: 0px;
  }

  div.substance {
    width: 100%;
    background-color: #ffffff;
  }
  div.ocn {
    width: 5%;
    float: right;
    top: 0;
    background-color: #ffffff;
  }
  div.endnote {
    width: 95%;
    background-color: #fffffff;
  }
  div.toc {
    position: absolute;
    float: left;
    margin: 0;
    padding: 0;
    padding-top: 0.5em;
    border: 0;
    width: 13em;
    background-color: #eeeeee;
    margin-right:1em;
  }
  div.summary {
    margin: 0;
    padding: 0;
    border-left: 13em solid #eeeeee;
    padding-left: 1em;
    background-color: #eeeeee;
  }
  div.content, div.main_column {
    margin: 0;
    padding: 0;
    border-left: 13em solid #ffffff;
    padding-left: 1em;
  }
  div.content:after {
    content:' ';
    clear:both;
    display:block;
    height:0;
    overflow:hidden
  }
  div.footer {
    clear:left;
    padding: 0.5em;
    font-size: 80%;
    margin: 0;
  }
  div.toc ul {
    list-style: none;
    padding: 0;
    margin: 0;
  }
  div.toc li ul a, li ul span.currentlink
  {
    font-weight: normal;
    font-size: 90%;
    padding-left: 2em;
    background-color: #eeeeee;
  }
  div.toc a, span.currentlink{
    display:block;
    text-decoration: none;
    padding-left: 0.5em;
    color: #0000aa;
  }
  hr {
    width: 90%;
  }

  span.currentlink {
    text-decoration: none;
    background-color: #aaaaf9;
  }

  div.toc a:visited {
    color: #0000aa;
  }
  div.toc a:hover {
    color: #000000;
    background-color: #f9f9aa;
  }

  .minitoc {
    font-weight: normal;
    margin-top: 2px;
    margin-bottom: 2px;
  }
  h1.minitoc, h2.minitoc, h3.minitoc {
    margin-left: 0em;
    font-weight: bold;
    text-align: left;
    font-size: 90%;
    margin-top: 4px;
    margin-bottom: 4px;
  }
  h4.minitoc {
    margin-left: 0em;
    font-size: 90%;
  }
  h5.minitoc {
    margin-left: 1em;
    font-size: 85%;
  }
  h6.minitoc {
    margin-left: 2em;
    font-size: 85%;
  }
  h0.minitoc {
    margin-left: 0em;
    font-size: 90%;
  }

  h1.c, h2.c, h3.c, h4.c, h5.c, h6.c, p.c {
    text-align: center
  }
  h1.red, h2.red, h3.red, h4.red, h5.red, h6.red {
    text-align: center;
    color: #ff0000;
    margin-left: 5mm;
    text-indent: 5mm;
    margin-top: 30px;
    margin-bottom: 20px;
    margin-right: 15mm;
  }
  h1.ruby, h2.ruby, h3.ruby, h4.ruby, h5.ruby, h6.ruby {
    text-align: center;
    color: #990000;
    margin-left: 5mm;
    text-indent: 5mm;
    margin-top: 30px;
    margin-bottom: 20px;
    margin-right: 15mm;
  }
WOK
    end
    def homepage                                  #stylesheet for index, home page
<<WOK
  body {color: black; background: #{@vz.color_white}; margin:10px 10px 0px 10px; padding:0px;}
  p { line-height: 1.5 }
  a:link      {color: #{@vz.color_blue_ink};   text-decoration: none; }
  a:visited       {color: #{@vz.color_blue_ink};   text-decoration: none; }
  a:hover {color: #{@vz.color_black}; text-decoration: underline; background-color: #{@vz.color_yellow_light};}
  a:active {color: #{@vz.color_blue_ink}; text-decoration: underline;}
  #banner {
    background:#{@vz.color_white};
  }
  #column_left {
    width:25%;
    float:left;
    background:#b9d4dd;
    padding-bottom:10px;
  }
  #column_center {
    width:55%;
    float:left;
    background:#{@vz.color_white};
    padding-bottom:10px;
  }
  #column_right {
    width:20%;
    float:left;
    background:#b9d4dd;
    padding-bottom:10px;
  }
  p,h1,pre {
    font-family: #{fonts};
    margin:0px 10px 10px 10px;
  }
  h1 {
    font-size:14px;
    padding-top:10px;
  }
  #column_right p { font-size:12px}
  #banner h1 { margin:0px; padding:10px}
WOK
    end
    def xhtml                                     #stylesheet for xhtml
<<WOK
/* SiSU css xhtml & sax.xml default style */
    document {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    head {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    meta {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #990000;
      margin-right: 2mm;
      margin-top: 0px;
      margin-bottom: 0px;

    }
    title,subtitle,creator,author,translator,translated_by,illustrator,illustrated_by,prepared_by,digitized_by,type,subject,description,contributor,publisher,format,identifier,source,language,relation,coverage,rights,keywords,comment,comments,abastract,tags,catalogue,date,date_created,date_issued,date_available,date_modified,date_valid,structure,sc {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #000099;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    source_control {
      display: block;
    }
    dc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      display: inline;
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th,td {
      display: inline;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    text,text[class|="norm"] {
      display: block;
      font-family: #{fonts};
      text-align: justify;
      font-weight: normal;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    text[class|="h1"] {
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h2"] {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h3"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h4"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h5"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h6"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="indent0"] {
      margin-left: 10%;
    }
    text[class|="indent1"] {
      margin-left: 15%;
    }
    text[class|="indent2"] {
      margin-left: 20%;
    }
    text[class|="indent3"] {
      margin-left: 25%;
    }
    text[class|="indent4"] {
      margin-left: 30%;
    }
    text[class|="indent5"] {
      margin-left: 35%;
    }
    text[class|="indent6"] {
      margin-left: 40%;
    }
    text[class|="indent7"] {
      margin-left: 45%;
    }
    text[class|="indent8"] {
      margin-left: 50%;
    }
    text[class|="indent9"] {
      margin-left: 55%;
    }
    text[class|="indent_bullet"] {
      text-indent: 0%;
    }
    text[class|="indent_bullet0"] {
      text-indent: 0%;
    }
    text[class|="indent_bullet1"] {
      text-indent: 10%;
    }
    text[class|="indent_bullet2"] {
      text-indent: 15%;
    }
    text[class|="indent_bullet3"] {
      text-indent: 20%;
    }
    text[class|="indent_bullet4"] {
      text-indent: 25%;
    }
    text[class|="indent_bullet5"] {
      text-indent: 30%;
    }
    text[class|="indent_bullet6"] {
      text-indent: 35%;
    }
    text[class|="indent_bullet7"] {
      text-indent: 40%;
    }
    text[class|="indent_bullet8"] {
      text-indent: 45%;
    }
    text[class|="indent_bullet9"] {
      text-indent: 50%;
    }
    text[class|="verse"], text[class|="group"], text[class|="code"] {
      text-align: left;
    }
    ocn {
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def xml_sax                                   #stylesheet for xml sax
      xhtml
    end
    def xml_dom                                   #sylesheet for xml dom, work on, starts from copy of css_xhtml
<<WOK
/* SiSU css dom.xml default style */
    document {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    head {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    header {
      display: block;
    }
    meta {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #990000;
      margin-right: 2mm;
      margin-top: 0px;
      margin-bottom: 0px;

    }
    title,subtitle,creator,author,translator,translated_by,illustrator,illustrated_by,prepared_by,digitized_by,type,subject,description,contributor,publisher,format,identifier,source,language,relation,coverage,rights,keywords,comment,comments,abastract,tags,catalogue,date,date_created,date_issued,date_available,date_modified,date_valid,structure,sc {
      display: inline;
      line-height: 1;
      font-size: 10px;
      color: #000099;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    source_control {
      display: block;
    }
    dc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      display: inline;
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    heading {
      font-weight: bold;
    }
    contents {
      font-weight: normal;
    }
    text {
      display: block;
      font-family: #{fonts};
      text-align: justify;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    text[class|="norm"] {
      font-weight: normal;
    }
    text[class|="h1"] {
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h2"] {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    text[class|="h3"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h4"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h5"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="h6"] {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    text[class|="indent1"] {
      margin-left: 10%;
    }
    text[class|="indent2"] {
      margin-left: 15%;
    }
    text[class|="indent3"] {
      margin-left: 20%;
    }
    text[class|="indent4"] {
      margin-left: 25%;
    }
    text[class|="indent5"] {
      margin-left: 30%;
    }
    text[class|="indent6"] {
      margin-left: 35%;
    }
    text[class|="indent7"] {
      margin-left: 40%;
    }
    text[class|="indent8"] {
      margin-left: 45%;
    }
    text[class|="indent9"] {
      margin-left: 50%;
    }
    text[class|="indent_bullet1"] {
      margin-left: 10%;
    }
    text[class|="indent_bullet2"] {
      margin-left: 15%;
    }
    text[class|="indent_bullet3"] {
      margin-left: 20%;
    }
    text[class|="indent_bullet4"] {
      margin-left: 25%;
    }
    text[class|="indent_bullet5"] {
      margin-left: 30%;
    }
    text[class|="indent_bullet6"] {
      margin-left: 35%;
    }
    text[class|="indent_bullet7"] {
      margin-left: 40%;
    }
    text[class|="indent_bullet8"] {
      margin-left: 45%;
    }
    text[class|="indent_bullet9"] {
      margin-left: 50%;
    }
    text[class|="verse"], text[class|="group"], text[class|="code"] {
      text-align: left;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
    nametag {
      display: none;
    }
    number {
      padding-right: 4px;
    }
    ocn {
      font-weight: normal;
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def docbook_xml                               #stylesheet for docbook
<<WOK
/* SiSU css docbook.xml default style */
    book {
      display: block;
      margin-left: 0mm;
      margin-right: 0mm;
    }
    bookinfo {
      display: block;
      margin-bottom: 20px;
      background-color: #dddddd;
    }
    source_control {
      display: block;
    }
    dc,sc {
      display: block;
      font-family: #{fonts};
      color: blue;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    sc {
      color: green;
    }
    keywords,copyright {
      display: block;
      font-family: #{fonts};
      color: red;
      background-color: #dddddd;
      font-weight: normal;
      text-align: justify;
      font-size: xx-small;
      line-height: 120%;
      margin-left: 5%;
      margin-right: 5mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-left: 2mm;
      margin-right: 2mm;
      margin-top: 4px;
      margin-bottom: 8px;
    }
    part {
      display: block;
      /* font-weight: bold; */
    }
    contents {
      font-weight: normal;
    }
    para {
      display: block;
      font-family: #{fonts};
      /* font-weight: normal; */
      text-align: justify;
      font-size: 100%;
      line-height: 150%;
      margin-left: 5%;
      margin-right: 5%;
      margin-top: 2px;
      margin-bottom: 0px;
    }
    para.verse, para.group, para.code {
      text-align: left;
    }
    para.norm {
      font-family: #{fonts};
      font-weight: normal;
    }
    para.h1, title {
      display: block;
      font-family: #{fonts};
      font-size: 120%;
      font-weight: bold;
      text-align: left;
      line-height: 120%;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    para.h2 {
      font-weight: bold;
      font-size: 110%;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    para.h3 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h4 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h5 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    para.h6 {
      font-size: 110%;
      font-weight: bold;
      text-align: left;
    }
    table {
      margin-left: 5%;
      display: block;
    }
    tr {
      display: block;
    }
    th, td {
      display: inline;
    }
    nametag {
      display: none;
    }
    number {
      padding-right: 4px;
    }
    ocn {
      font-weight: normal;
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-right: 0mm;
      margin-top: 0px;
      margin-bottom: 0px;
    }
    endnote {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    endnote_indent {
      display: block;
      font-size: small;
      font-family: #{fonts};
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 15%;
      margin-right: 5%;
      margin-top: 4px;
      margin-bottom: 0px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
    def css_xhtml_p                               #stylesheet for ...
<<WOK
    body {
      color: black;
      background: #ffffff;
    }
    a:link {
      color: #003399;
      text-decoration: none;
    }
    a:visited {
      color: #003399;
      text-decoration: none;
      /* background-color: #e3ecef; */
    }
    a:hover {
      color: #000000;
      text-decoration: underline;
      background-color: #fff3b6;
    }
    a:hover IMG {
      background-color: #ffffff;
    }
    a:active {
      color: #003399;
      text-decoration: underline;
    }
    object {
      display: block;
      margin-top: 3px;
      margin-bottom: 3px;
      margin-right: 5mm;
    }
    p {
      display: block;
      font-family: #{fonts};
      font-size: 100%;
      font-weight: normal;
      line-height: 150%;
      text-align: justify;
      margin-left: 10mm;
      margin-top: 3px;
      margin-bottom: 0px;
      margin-right: 5mm
    }
    p.norm { }
    p.endnote {
      font-size: 100%;
      margin-left: 20%;
      text-indent: 5%
    }
    p.endnote_indent {
      font-size: 100%;
      margin-left: 25%;
      text-indent: 5%
    }
    p.h1 {
      font-family: #{fonts};
      font-weight: bold;
      line-height: 120%;
      margin-left: 10mm;
      margin-right: 10mm;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h2 {
      font-weight: bold;
      font-size: 110%;
      margin-left: 10mm;
      margin-right: 15mm;
      text-align: left;
      margin-top: 20px;
      margin-bottom: 10px;
    }
    p.h3 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h4 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h5 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    p.h6 {
      font-size: 150%;
      font-weight: bold;
      text-align: left;
    }
    ocn {
      display: block;
      text-align: right;
      vertical-align: super;
      color: #990000;
      font-size: xx-small;
      margin-top: 0px;
      margin-bottom: 6px;
    }
    en {
      font-size: xx-small;
      vertical-align: super;
    }
    i { font-style: italic; }
    b { font-style: bold; }
    u { text-decoration: underline; }
    br { display: block; }
WOK
    end
  end
end

__END__

