# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_metadata
  class Metadata
    def initialize(md,data)
      @md,@data=md,data
      l=SiSU_Env::Standardise_language.new.file_to_language(md.fns)
      language=l[:l]
      @tr=SiSU_Translate::Source.new(md,language)
    end
    def metadata
      data=@data
      meta,@dc,@rc,@cvs,dctitle,add=Array.new(6){[]}
      dir=SiSU_Env::Info_env.new(@md.fns)
      base_html="#{dir.url.root}/#{@md.fnb}"
      ocnm=ocnd=ocnv=0
      ocnm+=1
      header1="\n#{Mx[:lv_o_1]}meta#{Mx[:lv_c]}Document Information (metadata) #{Mx[:id_o]}~0;0:0;m#{ocnm}#{Mx[:id_c]}"
      ocnm+=1
      header4="\n#{Mx[:lv_o_4]}metadata#{Mx[:lv_c]}Metadata #{Mx[:id_o]}~0;m#{ocnm};m#{ocnm}#{Mx[:id_c]}"
      ocnm+=1; ocnd+=1
      head_no_dc="#{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
      ocnm+=1; ocnd+=1
      head_no_dc_tag="#{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
      data.each do |para|
        case para
        when /^#{Mx[:meta_o]}(title|creator|author|translator|translated_by|illustrator|illustrated_by|prepared_by|digitized_by|description|publisher|contributor|date\.created|date\.issued|date\.available|date\.valid|date\.modified|date|type|format|rights|identifier|source|language)#{Mx[:meta_c]}/i
          m=$1
          ocnm+=1; ocnd+=1
          @dc << case para
          when /^#{Mx[:meta_o]}title#{Mx[:meta_c]}/
            "\n#{@tr.full_title}: #{Mx[:fa_underscore_o]}#{@md.full_title}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}(?:creator|author)#{Mx[:meta_c]}/
            "\n#{@tr.author}: #{Mx[:fa_underscore_o]}#{@md.author}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /#{Mx[:meta_o]}(?:translator|translated_by)#{Mx[:meta_c]}/
            "\n#{@tr.translator}: #{Mx[:fa_underscore_o]}#{@md.translator}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}(?:illustrator|illustrated_by)#{Mx[:meta_c]}/
            "\n#{@tr.illustrator}: #{Mx[:fa_underscore_o]}#{@md.illustrator}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}prepared_by#{Mx[:meta_c]}/
            "\n#{@tr.prepared_by}: #{Mx[:fa_underscore_o]}#{@md.prepared_by}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}digitized_by#{Mx[:meta_c]}/
            "\n#{@tr.digitized_by}: #{Mx[:fa_underscore_o]}#{@md.digitized_by}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}description#{Mx[:meta_c]}/
            "\n#{@tr.description}: #{Mx[:fa_underscore_o]}#{@md.description}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}subject#{Mx[:meta_c]}/
            "\n#{@tr.subject}: #{Mx[:fa_underscore_o]}#{@md.subject}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}abstract#{Mx[:meta_c]}/
            "\n#{@tr.abstract}: #{Mx[:fa_underscore_o]}#{@md.abstract}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}publisher#{Mx[:meta_c]}/
            "\n#{@tr.publisher}: #{Mx[:fa_underscore_o]}#{@md.publisher}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}contributor#{Mx[:meta_c]}/
            "\n#{@tr.contributor}: #{Mx[:fa_underscore_o]}#{@md.contributor}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date.created#{Mx[:meta_c]}/
            "\n#{@tr.date_created}: #{Mx[:fa_underscore_o]}#{@md.date_created}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date.issued#{Mx[:meta_c]}/
            "\n#{@tr.date_issued}: #{Mx[:fa_underscore_o]}#{@md.date_issued}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date.available#{Mx[:meta_c]}/
            "\n#{@tr.date_available}: #{Mx[:fa_underscore_o]}#{@md.date_available}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date.modified#{Mx[:meta_c]}/
            "\n#{@tr.date_modified}: #{Mx[:fa_underscore_o]}#{@md.date_modified}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date.valid#{Mx[:meta_c]}/
            "\n#{@tr.date_valid}: #{Mx[:fa_underscore_o]}#{@md.date_valid}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}date#{Mx[:meta_c]}/
            "\n#{@tr.date}: #{Mx[:fa_underscore_o]}#{@md.date}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}type#{Mx[:meta_c]}/
            "\n#{@tr.type}: #{Mx[:fa_underscore_o]}#{@md.type}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}format#{Mx[:meta_c]}/
            "\n#{@tr.format}: #{Mx[:fa_underscore_o]}#{@md.format}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}rights#{Mx[:meta_c]}/
            "\n#{@tr.rights}: #{Mx[:fa_underscore_o]}#{@md.rights}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}identifier#{Mx[:meta_c]}/
            "\n#{@tr.identifier}: #{Mx[:fa_underscore_o]}#{@md.identifier}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}source#{Mx[:meta_c]}/
            "\n#{@tr.source}: #{Mx[:fa_underscore_o]}#{@md.source}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}language#{Mx[:meta_c]}/
            "\n#{@tr.language}: #{Mx[:fa_underscore_o]}#{@md.language}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}language.original#{Mx[:meta_c]}/
            "\n#{@tr.language_original}: #{Mx[:fa_underscore_o]}#{@md.language_original}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}relation#{Mx[:meta_c]}/
            "\n#{@tr.relation}: #{Mx[:fa_underscore_o]}#{@md.relation}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}coverage#{Mx[:meta_c]}/
            "\n#{@tr.coverage}: #{Mx[:fa_underscore_o]}#{@md.coverage}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}keywords#{Mx[:meta_c]}/
            "\n#{@tr.keywords}: #{Mx[:fa_underscore_o]}#{@md.keywords}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}comments#{Mx[:meta_c]}/
            "\n#{@tr.comments}: #{Mx[:fa_underscore_o]}#{@md.comments}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}cls_loc#{Mx[:meta_c]}/
            "\n#{@cls_dewey}: #{Mx[:fa_underscore_o]}#{@md.cls_dewey}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}cls_dewey#{Mx[:meta_c]}/
            "\n#{@tr.cls_dewey}: #{Mx[:fa_underscore_o]}#{@md.cls_dewey}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}(?:cls_gutenberg|cls_pg)#{Mx[:meta_c]}/
            "\n#{@tr.cls_gutenberg}: #{Mx[:fa_underscore_o]}#{@md.cls_gutenberg}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
            #"\n#{@tr.cls_gutenberg}: <u>#{@md.cls_pg}</u> #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}cls_isbn#{Mx[:meta_c]}/
            "\n#{@tr.cls_isbn}: #{Mx[:fa_underscore_o]}#{@md.cls_isbn}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}prefix(?:_a)?#{Mx[:meta_c]}/
            "\n#{@tr.prefix_a}: #{Mx[:fa_underscore_o]}#{@md.prefix_a}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          when /^#{Mx[:meta_o]}prefix_b#{Mx[:meta_c]}/
            "\n#{@tr.prefix_b}: #{Mx[:fa_underscore_o]}#{@md.prefix_b}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}"
          else para.gsub(/^#{Mx[:meta_o]}(#{m})\s+(.+)/m,"\n#{m.capitalize}: #{Mx[:fa_underscore_o]}\\2#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};d#{ocnd}#{Mx[:id_c]}")
          end
        end
      end
      ocnm+=1; ocnv+=1
      head_no_rc="#{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
      ocnm+=1; ocnv+=1
      head_no_rc_tag="#{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
      data.each do |para|
        case para
        when /^0~(?:cvs|rcs)\+\s+/ #note the + sign to turn on use of cvs id
          ocnm+=1; ocnv+=1
          @cvs << "#{@tr.sc_number}: #{Mx[:fa_underscore_o]}#{@md.sc_number}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
          @cvs << "#{@tr.sc_date}: #{Mx[:fa_underscore_o]}#{@md.sc_date}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
          @cvs << "CVS/RCS time: #{Mx[:fa_underscore_o]}#{@md.sc_time}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
        when /^0~cvs[+\s]/ #enable pattern above instead if you wish the default to be to include cvs tags from all documents KEEP
        when /^0~cvs\s+/ #enable pattern above instead if you wish the default to be to include cvs tags from all documents KEEP
        end
      end
      if true #default version information
        ocnm+=1; ocnv+=1
        if @md.sc_filename \
        and @md.sc_filename.length > 3
          @rc << "#{@tr.sourcefile}: #{Mx[:fa_underscore_o]}#{@md.sc_filename}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
        else @rc << "#{@tr.sourcefile}: #{Mx[:fa_underscore_o]}#{@md.fns}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
        end
        ocnm+=1; ocnv+=1
        if @md.file_encoding \
        and @md.file_encoding.length > 3  #translate
          @rc << "Filetype: #{Mx[:fa_underscore_o]}#{@md.file_encoding}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
        end
        ocnm+=1; ocnv+=1
        if @md.dgst #change. enable by default
          @rc << "#{@tr.sourcefile_digest}, #{@md.dgst[0]} #{Mx[:fa_underscore_o]}#{@md.dgst[1]}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
        end
        if @md.dgst_skin #change. enable by default
          @rc << "Skin_Digest: #{@md.dgst_skin[0]} #{Mx[:fa_underscore_o]}#{@md.dgst_skin[1]}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
        end
        @rc << "#{Mx[:fa_bold_o]}Generated#{Mx[:fa_bold_c]} #{head_no_rc}" if @rc.length > 0
        @rc << "#{@tr.last_generated}: #{Mx[:fa_underscore_o]}#{Time.now}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
        ocnm+=1; ocnv+=1
        if @md.sisu_version[:version]
          @rc << "#{@tr.sisu_version}: #{Mx[:fa_underscore_o]}#{@md.sisu_version[:project]}#{Mx[:fa_underscore_c]}  #{Mx[:fa_underscore_o]}#{@md.sisu_version[:version]}#{Mx[:fa_underscore_c]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]}) #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
          ocnm+=1; ocnv+=1
        end
        @rc << "#{@tr.ruby_version}: #{Mx[:fa_underscore_o]} #{@md.ruby_version}#{Mx[:fa_underscore_c]} #{Mx[:id_o]}~0;m#{ocnm};v#{ocnv}#{Mx[:id_c]}"
      end
      meta << Mx[:br_page_new] << header1 << header4
      meta << "Document Manifest @\n #{base_html}/#{@md.fn[:manifest]} #{Mx[:id_o]}~0;m#{ocnm};m#{ocnm}#{Mx[:id_c]}"
      meta << "#{Mx[:fa_bold_o]}Dublin Core#{Mx[:fa_bold_c]} (DC) #{head_no_dc}" if @dc.length > 0
      meta << "#{Mx[:fa_italics_o]}DC tags included with this document are provided here.#{Mx[:fa_italics_c]} #{head_no_dc_tag}" if @dc.length > 0
      @dc.each { |x| meta << x }
      meta << "#{Mx[:fa_bold_o]}Version Information#{Mx[:fa_bold_c]} #{head_no_rc}" if @rc.length > 0
      if @cvs.length > 0
        meta << "#{Mx[:fa_italics_o]}Note the version information provided here, is specific to the host site.#{Mx[:fa_italics_c]} #{head_no_rc_tag}"
        @cvs.each { |x| meta << x }
      end
      @rc.each { |x| meta << x }
      ## ENDNOTE RELATED endnote related
      meta << "\n#{Mx[:br_eof]}"
      meta=SiSU_hash::Object_digest.new(@md,meta,@env).object_digest
    end
  end
end
__END__
