# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: A conversion script for canned substitutions, a fairly generic
    simple tool that can be used to store other canned conversions, used here for
    altering SiSU markup

=end
module SiSU_Markup_type
  class Markup_identify
    @@fns,@@version_determined,@@version_declared,@@declared_doc_type='','','','[text?]'
    attr_accessor :version_determined,:version_declared,:declared_doc_type
    def initialize(content,opt)
      @cont,@opt=content,opt
    end
    def identify
      @version_determined,@version_declared,@declared_doc_type=@@version_determined,@@version_declared,@@declared_doc_type
      if @opt.fns != @@fns
        if @cont[0] =~ /^(?:%\s+)?SiSU\s+(text|master|insert)\s+([0-9](?:\.[0-9]+){1,2})/ \
        or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @declared_doc_type,@version_declared=$1,$2
        elsif @cont[0] =~ /^(?:%\s+)?SiSU\s+([0-9](?:\.[0-9]+){1,2})/ \
        or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @version_declared=$1
        end
        @flag_66,@flag_57,@flag_38=false,false,false
        @cont.each_with_index do |y,i|
          if y =~/^(?:0\{?~links?|@links?:)\s/
            links=unless y =~/\{.+?\}\S+/; oldlinks=' (pre 0.20.4 header links)'
            else ' (post 0.20.4 header links)'
            end
          end
          unless @flag_38
            if y =~/^:?A~/
              version=0.38
              @version_determined=version
              @flag_38=true
            end
          end
          if @flag_38
            if @flag_69 \
            or y =~/^=\{.+?\}\s*$/
              version=0.69
              @flag_69=true
              @version_determined=version
              break
            end
            if @flag_66 \
            or y =~/[:;]\{.+?\}[:;][a-z+]/
              version='0.66'
              @flag_66=true
              @version_determined=version
              break
            end
          end
        end
        @flag_57,@flag_38=false,false
        unless @flag_66 or @flag_69
          @cont.each_with_index do |y,i|
            if @flag_57 \
            or y =~/^:?A~\?? @title/
              @version_determined=0.57
              @flag_57=true
              break
            end
            if @flag_38 \
            or y =~/^:?A~/
              @version_determined=0.38
              @flag_38=true
              break if i >= 200
              if y =~ /(?:~{\*+|~\[\*|~\[\+)\s/
                @version_determined=0.42 #0.38 can safely be treated as 0.42
                break
              end
            end
            if y =~/^0~/ \
            and not @flag_38
              @version_determined=0.16
              break
            end
          end
        end
        @@fns=@opt.fns
        @@version_determined,@@version_declared,@@declared_doc_type=@version_determined,@version_declared,@declared_doc_type
      end
      self
    end
    def markup_version?
      identify.version_determined.to_f
    end
  end
end
__END__
