# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2010, Ralph Amissah, All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: parameters extracted from input file(s) for program use

=end
module SiSU_Param
  require 'uri'
  require 'pstore'
  require "#{SiSU_lib}/sysenv"
  include SiSU_Env
  require "#{SiSU_lib}/param_identify_markup"
  require "#{SiSU_lib}/help"
  include SiSU_Help
  @@date=SiSU_Env::Info_date.new
  @@symlnk=Create_system_link.new
  @@proc=@@filename_txt=@@filename_texinfo=@@filename_lout_portrait=@@filename_lout_landscape=@@filename_html_scroll=@@filename_html_index=@@filename_html_segtoc=@@filename_semantic=@@filename_rss=@@newfile=@@drr=nil
  @doc={ :initialise=>nil,:markup=>'',:lnks=>'',:stmp=>'',:req=>{} }
  @@yaml=@@yamladdr=nil
  @@trigger=nil
  @@lv,@@flag={},{}
  @@tex_backslash="\\\\"
  class Parameters
    @@publisher='SiSU scribe'
    @@md=@@fns=nil
    def initialize(opt)
      @opt=opt
      @cX||=SiSU_Screen::Ansi.new(opt.cmd)
      @cmd,@mod=opt.cmd,opt.mod
      @fns=opt.fns.gsub(/\.ssm$/,'.ssm.sst') #revisit CHECK
      Instantiate.new.param_instantiate
      @env=SiSU_Env::Info_env.new(@fns)
      @pstorefile="#{@env.path.dal}/#{@fns}.pstore"
    end
    def get
      unless @@fns==@fns
        @@fns=@fns
        @@md=nil
      end
      if @@md.nil? \
      or @cmd =~/M/ #not particularly helpful, as current cycle is through output types, with files changing, only helpful if deal with a file all output types before going to next file
        if File.exist?(@pstorefile)
          param_msg='Parameters from pstore'
          retrieve_store=PStore.new(@pstorefile)
          retrieve_store.transaction do
            @md=retrieve_store['md']
          end
          @md
        else
          param_msg='Parameters extracted'
          fns_array=@env.read_source_file(@opt.fns)
          md=Instructions.new(fns_array,@opt)
          @md=Instructions.new(fns_array,@opt).extract
          @md
        end
        @@md=@md
      else @@md
      end
      tell=SiSU_Screen::Ansi.new(@cmd,param_msg,@@md.title)
      tell.txt_grey if @cmd =~/[MV]/
      @@md.cmd=@cmd
      @@md
    end
    class Instructions
      @doc={ :lv=>[] }
      @doc[:fns],@doc[:fnb],@doc[:scr_suffix]='','',''
      @@publisher='SiSU scribe'
      attr_accessor :cmd,:mod,:env,:fn,:fns,:fnb,:fnn,:fnt,:fnl,:flv,:fnz,:fnstex,:ocn,:sfx_src,:sfx,:pdf,:file_type,:dir_out,:dir_tex,:dir_lout,:txt_path,:site_skin,:sisu,:sisu_version,:ruby_version,:title,:subtitle,:full_title,:html_title,:subtitle_tex,:author_home,:author,:author_title,:author_nationality,:authors,:authorship,:translator,:illustrator,:prepared_by,:digitized_by,:subject,:description,:publisher,:contributor,:date,:date_created,:date_issued,:date_available,:date_valid,:date_modified,:date_translated,:date_added_to_site,:date_scheme,:date_created_scheme,:date_issued_scheme,:date_available_scheme,:date_valid_scheme,:date_modified_scheme,:type,:format,:identifier,:source,:language,:language_original,:relation,:coverage,:rights,:keywords,:comments,:abstract,:cls_loc,:cls_dewey,:cls_pg,:cls_isbn,:papersize,:papersize_array,:toc,:lv1,:lv2,:lv3,:lv4,:lv5,:lv6,:pagenew,:pagebreak,:num_top,:toc_lev_limit,:flag_endnotes,:flag_auto_endnotes,:flag_separate_endnotes,:flag_separate_endnotes_make,:flag_auto_heading_num,:markup,:markup_instruction,:markup_version,:markup_declared,:make_bold,:make_italic,:flag_tables,:vocabulary,:doc_skin,:doc_css,:yaml,:lnk,:prefix_a,:prefix_b,:suffix,:information,:contact,:icon,:image,:ad_url,:ad_png,:ad_alt,:ad_began,:flag_promo,:promo,:ad_home,:stmp,:stmpd,:sc_filename,:sc_number,:sc_date,:sc_time,:sc_info,:yamladdr,:locale,:wc_lines,:wc_words,:wc_bytes,:file_encoding,:file_size,:user,:home,:hostname,:pwd,:firstseg,:programs,:author_copymark,:lang,:en,:dgst,:dgst_skin,:generated,:tags,:tag_array,:concord_make,:seg_names,:seg_autoname_safe,:set_header_title,:set_heading_top,:set_heading_seg,:heading_seg_first,:heading_seg_first_flag,:base_program,:man_section,:man_name,:man_synopsis,:ec,:opt,:sem_tag,:book_idx,:topic_register,:topic_register_array,:original_publication,:original_publication_date,:original_publication_nationality,:original_publication_institution,:writing_focus
      def initialize(fns_array,opt)
        @env=@fn=@fns=@fnb=@fnn=@fnt=@fnl=@flv=@fnz=@fnstex=@ocn=@sfx_src=@sfx=@pdf=@file_type=@dir_out=@dir_tex=@dir_lout=@txt_path=@flag_endnotes=@flag_auto_endnotes=@flag_separate_endnotes=@flag_separate_endnotes_make=@site_skin=@sisu=@sisu_version=@ruby_version=@title=@subtitle=@full_title=@html_title=@subtitle_tex=@author_home=@author=@author_title=@author_nationality=@translator=@illustrator=@prepared_by=@digitized_by=@subject=@description=@publisher=@contributor=@date=@date_created=@date_issued=@date_available=@date_valid=@date_modified=@date_translated=@date_added_to_site=@date_scheme=@date_created_scheme=@date_issued_scheme=@date_available_scheme=@date_valid_scheme=@date_modified_scheme=@type=@format=@identifier=@source=@language=@language_original=@relation=@coverage=@rights=@keywords=@comments=@abstract=@cls_loc=@cls_dewey=@cls_pg=@cls_isbn=@papersize=@toc=@lv1=@lv2=@lv3=@lv4=@lv5=@lv6=@pagenew=@pagebreak=@num_top=@toc_lev_limit=@flag_auto_heading_num=@make_bold=@make_italic=@flag_tables=@vocabulary=@doc_skin=@doc_css=@yaml=@lnk=@prefix_a=@prefix_b=@suffix=@information=@contact=@icon=@ad_url=@ad_png=@ad_alt=@ad_began=@promo=@ad_home=@stmp=@stmpd=@sc_filename=@sc_number=@sc_date=@sc_time=@sc_info=@yamladdr=@locale=@wc_lines=@wc_words=@wc_bytes=@file_encoding=@file_size=@firstseg=@programs=@author_copymark=@lang=@en=@dgst=@dgst_skin=@generated=@heading_seg_first=@base_program=@man_synopsis=@topic_register=@original_publication_details=@original_publication=@original_publication_date=@original_publication_nationality=@original_publication_institution=@writing_focus=nil
        @man_section=1
        @man_name='man page "name/whatis" information not provided, set in header @man: name=[whatis information]'
        @data,@fns,@cmd,@mod,@opt=fns_array,opt.fns,opt.cmd,opt.mod,opt #@data used as data
        @flag_tables,@set_header_title,@set_heading_top,@set_heading_seg,@heading_seg_first_flag,@flag_promo,@book_idx=false,false,false,false,false,false,false
        @seg_autoname_safe=true
        @sem_tag=false
        @authorship,@markup_instruction,@markup_declared,@image='','','','' #check which other values should be set to empty rather than nil
        @markup=@markup_instruction #use @markup_instruction
        @doc,@fn,@make_italic,@make_bold,@tag_hash,@ec={},{},{},{},{},{},{}
        @flv,@lang,@seg_names,@tags,@tag_array,@tag_a,@ec[:image],@ec[:audio],@ec[:multimedia]=Array.new(9){[]}
        @authors,@topic_register_array,@papersize_array=[],[],[]
        @rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
        @rgx_audio=/\{\s*(\S+?\.(?:mp3|ogg))/
        @rgx_mm=/\{\s*(\S+?\.(?:ogg|mpeg))/ #expand and distinguish ogg
        begin
        rescue; SiSU_Errors::Info_error.new($!,$@,@cmd,@fns).error
        ensure
        end
      end
      #protected
      def determine_papersize(l)
        l=case l
        when /eu|europe|uk/i;           'A4'                 #European default, SiSU default
        when /(?:us-)?legal|legal/i;    'US_legal'           #U.S. alternative
        when /(?:us-)?letter|u.s.|us/i; 'US_letter'          #U.S. default
        when /book_a5|a5/i;             'book_a5'
        when /book_b5|b5|book/i;        'book_b5'            #book default - larger
        else                            'A4'
        end
      end
      def name_format(name)
        name.strip!
        @name_a_h=[]
        authors=name.scan(/[^;]+/)
        authors.each do |a|
          if a =~/"(.+?)"/
            @name_a_h << { :the => $1 }
          else #if a =~/,/
            x=a.scan(/[^,]+/)
            if x.length == 1
              @name_a_h << { :the => x[0].strip }
            elsif x.length == 2
              @name_a_h << { :the => x[0].strip, :others => x[1].strip }
            else #p x.length
            end
          end
        end
        l = @name_a_h.length
        name_str=''
        @name_a_h.each_with_index do |a,i|
          name_str += if a[:others]
            if (l - i) > 1
              "#{a[:others].strip} #{a[:the].strip}, "
            else
              "#{a[:others].strip} #{a[:the].strip}"
            end
          else
            if (l - i) > 2
              "#{a[:the].strip}, "
            else
              "#{a[:the].strip}"
            end
          end
        end
        {:name_a_h =>@name_a_h,:name_str =>name_str}
      end
      def extract
        @user,@home,@hostname,@pwd=ENV['USER'],ENV['HOME'],ENV['HOSTNAME'],ENV['PWD']
        @programs,@wc,@language,@language_original={},{},{},{}
        @en={ :sum=>0,:mark=>0,:note=>0,:mismatch=>0 }
        @prog=SiSU_Env::Info_settings.new
        @sys=SiSU_Env::System_call.new
        @env=SiSU_Env::Info_env.new(@fns) #watch
        if @prog.wc \
        and @sys.wc
          wc=%x{wc #{fns}}
          wca=wc.scan(/\d+/)
          @wc_lines,@wc_words,@wc_bytes=wca[0].to_i,wca[1].to_i,wca[2].to_i
        else
          fns_a=@data.dup
          tmp=fns_a.join
          fns_a=tmp.scan(/\S+/)
          @wc_words=fns_a.length
          fns_a=tmp=nil
        end
        @concord_make=if @wc_words > @env.concord_max; false
        else true
        end
        @locale=@sys.locale
        @file_encoding=@sys.file_encoding(fns,@cmd)
        # programs set here for things that affect output appearance only
        @programs[:pdf]=SiSU_Env::System_call.new.program_found?('pdflatex')
        if @env.i18n.multilingual
          m=/((.+?)(?:\~\w{2,3})?)\.((?:-|ssm\.)?sst)$/ #watch added match for sss
          @fnn,@fnb,@fnt=@fns[m,1],@fns[m,2],@fns[m,3]
          @flv=@env.document_language_versions_found[:f]
          @fnz=if @fns =~/\.(?:ssm\.sst|ssm)$/; @fnn + '.ssm.zip'
          else @fnn + '.sst.zip'
          end
        else m=/(.+?)\.((?:-|ssm\.)?sst)$/
          @fnb=@fnn=@fns[m,1]
          @fnt=@fns[m,2]
          @flv<<@fns
          @fnz=if @fns =~/\.(?:_sst|ssm)$/; @fnb + '.ssm.zip'
          else @@fnb + '.sst.zip'
          end
        end
        @papersize=@env.papersize #'A4' #default size #get first from SiSU_Env:: # @env is probably no longer most appropriate name! as default info is more general
        @sfx_src=@fns[m,2]
        @sfx='.html' # #@sfx=nil watch
        @flag_auto_heading_num=false
        if @fns =~ /(?:-|ssm\.)?sst$/ #watch
          @env_out_root=@env.path.output
          @dir_out="#{@env.path.output}/#{@fnb}"
          @dir_tex=@env.path.tex
          @dir_lout=@env.path.lout
          @@publisher='SiSU http://www.jus.uio.no/sisu'
        end
        @txt_path=@txt_path ||= @env.path.output
        @stmp=%{#{@fns}}[/^(.+?)\..*/m,1]
        @fnstex=@fns.gsub(/_/,'\_')
        @flag_separate_endnotes=false
        @flag_separate_endnotes_make=true
        regx_date=/^\d{4}(?:-(?:[0][0-9]|1[0-2])(-(?:[0-2][0-9]|3[01]))?)?$/
        ver=SiSU_Env::Info_version.instance
        @sisu_version=ver.get_version
        @ruby_version=ver.rbversion
        @generated=Time.now
        fns_array=@data.dup
        skip unless fns_array                                                    # consider
        @markup_version=SiSU_Markup_type::Markup_identify.new(fns_array,@opt).markup_version? #% determine markup version
        if fns_array[0] =~ /^(?:% )?(?:SiSU\s+(?:master\s+)?[\d.]*|sisu-[\d.]+)$/ #check markup and markup version
          if fns_array[0] =~ /^(?:% )?(?:SiSU\s+(?:master\s+)?|sisu-)[\d.]+$/ #check markup and markup version
            @markup_version_declared=fns_array[0].match(/^(?:% )?(?:SiSU\s+(?:master\s+)?|sisu-)([\d.]+)$/)[1]
            sm_a,sm_b,sm_c=fns_array[0].match(/^(?:% )?(?:SiSU\s+(?:master\s+)?|sisu-)([0-9]+)?(?:\.([0-9]+))?(?:\.([0-9]+))?$/)[1..3]
            sm_c ||=0
            sv=if @cmd =~/[VMv]/; "SiSU version (#{@sisu_version[:version]})"
            else ''
            end
            s_a,s_b,s_c=@sisu_version[:version].match(/^([0-9]+)?(?:\.([0-9]+))?(?:\.([0-9]+))?(?:\-\S+)?$/)[1..3]
            tell=if @markup_version_declared.to_f==@markup_version.to_f
              SiSU_Screen::Ansi.new(@cmd,"Markup version (#{@markup_version})",sv)
            else
              SiSU_Screen::Ansi.new(@cmd,"Markup version declared (#{@markup_version_declared}), determined (#{@markup_version})",sv)
            end
            ok=if s_a.to_i > sm_a.to_i
              true
            elsif s_a.to_i == sm_a.to_i \
            and s_b.to_i >= sm_b.to_i
              true
            elsif s_a.to_i == sm_a.to_i \
            and s_b.to_i == sm_b.to_i \
            and s_c.to_i >= sm_c.to_i
              true
            else false
            end
            if ok
              tell.txt_green if @cmd =~/[vVM]/
            else
              tell=SiSU_Screen::Ansi.new(@cmd,"Warning: markup version determined (#{@markup_version}) or markup version declared (#{@markup_version_declared}) is newer than SiSU version (#{@sisu_version[:version]})")
              tell.warn unless @cmd =~/q/
            end
          else
            tell=SiSU_Screen::Ansi.new(@cmd,'No SiSU markup version provided')
            tell.warn if @cmd =~/[VM]/
          end
        else
          tell=SiSU_Screen::Ansi.new(@cmd,'SiSU filetype indicator not provided')
          tell.warn unless @cmd =~/q/
        end
        @code_flag=false
        fns_array.each do |para|                                                                                       #% Scan document
          if para !~/^%+\s/ \
          and para =~/<![abcdeghijklmnopqrstuvwxyz]/i # <!f not included
            raise "Old markup style in file #{@fns}, current version #{@sisu_version[:project]} #{@sisu_version[:version]} #{@sisu_version[:date_stamp]} #{@sisu_version[:date]}:\n\t\t#{para}\n\n"
          end
          @code_flag=case para
          when /^code\{\s*$/; true
          when /^\}code\s*$/; false
          else @code_flag
          end
          regx_header=/^@\S+?:[+-]?\s/
          if para =~regx_header \
          and not @code_flag #or para=~/^(?:1|:?A)~/
            case para
            when /^@ocn:\s+(.+?)$/m; @ocn=$1                                                                 #% processing
            when /^@title:\s+(.+?)$/m                                                                      #% metainfo DC
              @title=$1.strip
              @full_title=@title.dup
              @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/,'')
              @set_header_title=true
              @title.chomp!(' ')
              @html_title.chomp!(' ')
              tell=SiSU_Screen::Ansi.new(@cmd,'Parameters',@html_title)
              tell.txt_grey unless @cmd =~/q/
            when /^@subtitle:\s+(.+?)$/m                                                                #% metainfo
              @subtitle=$1.strip
              @full_title="#{@title} - #{@subtitle}"
              @subtitle_tex=@subtitle
            when /^@creator:(?:[ ]+|.+?:author:[ ]+)(.+?)(?:[|]|$)/m    #when /^@(?:creator|author):(?:[ ]+|.+?:author:[ ]+)(.+?)(?:[|]|$)/m
              names=name_format($1)
              @authorship=@author=names[:name_str]
              @authors=names[:name_a_h]
            when /^@author:\s+(.+?)$/
              names=name_format($1)
              @authorship=@author=names[:name_str]
              @authors=names[:name_a_h]
            when /^@(?:creator|author)\.title:\s+(.+?)$/; @author_title=$1                                             # Prof. Dr. etc.
            when /^@(?:creator|author)\.nationality:\s+(.+?)$/; @author_nationality=$1
            when /^@(?:translator|translated_by):\s+(.+?)$/m                        #% metainfo
              names=name_format($1)
              @translator=names[:name_str]
            when /^@(?:illustrator|illustrated_by):\s+(.+?)$/m                    #% metainfo
              names=name_format($1)
              @illustrator=names[:name_str]
            when /^@prepared_by:\s+(.+?)$/m                                                          #% metainfo
              names=name_format($1)
              @prepared_by=names[:name_str]
            when /^@digitized_by:\s+(.+?)$/m                                                        #% metainfo DC
              names=name_format($1)
              @digitized_by=names[:name_str]
            when /^@subject:\s+(.+?)$/m; @subject=$1                                                     #% metainfo DC
            when /^@description:\s+(.+?)$/m; @description=$1                                         #% metainfo DC & rss feed
            when /^@contributor:\s+(.+?)$/m                                                          #% metainfo DC
              names=name_format($1)
              @contributor=names[:name_str]
            when /^@publisher:\s+(.+?)$/m; @publisher=$1                                               #% metainfo DC
            when /^@original_publication:\s+(.+?)$/m; @original_publication=$1
            when /^@original_publication\.date:\s+(.+?)$/; @original_publication_date=$1
            when /^@original_publication\.nationality:\s+(.+?)$/; @original_publication_nationality=$1
            when /^@original_publication\.institution:\s+(.+?)$/; @original_publication_institution=$1
            when /^@writing_focus\.nationality:\s+(.+?)$/; @writing_focus=$1                                           # e.g. Finland (where and article on Finnish law)
            when /^@date:(?:[ ]+|.+?:published:[ ]+)(\d{4})/m                                                   #% metainfo DC
            #when /^@date.+?$/m                                                                                  #% metainfo DC
              if para =~/@date:\s+(.+?)$/m
                @date=$1.strip                                                                                         #% original publication date unless the substantive text is updated/modified, then date of update
                if @date !~regx_date \
                and not @date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',@date)
                  tell.instruct if @cmd =~/v/
                end
                @date_scheme='scheme="ISO-8601"' if @date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/@date\.added_to_site:\s+(.+?)$/m
                @date_added_to_site=$1.strip
                if @date_added_to_site !~regx_date \
                and not @date_added_to_site.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',@date_added_to_site)
                  tell.instruct if @cmd =~/v/
                end
                @date_scheme='scheme="ISO-8601"' if @date_added_to_site =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/@date\.created:\s*(.+?)$/m
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_created=date
                @date_created_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/@date\.issued:\s*(.+?)$/m
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_issued=date
                @date_issued_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/@date\.available:\s*(.+?)$/m
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_available=date
                @date_available_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/^@date\.valid:\s*(.+?)$/m
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_valid=date
                @date_valid_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/^@date\.modified:\s*(.+?)$/m                                             #% of interest rss feed & sitemap
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_modified=date
                @date_modified_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
              if para =~/^@date\.translated:\s*(.+?)$/m
                date=$1.strip
                if date !~regx_date \
                and not date.empty?
                  tell=SiSU_Screen::Ansi.new(@cmd,'Date Format should be','YYYY-MM-DD','please correct document','Date','field, current value:',date)
                  tell.instruct if @cmd =~/v/
                end
                @date_translated=date
                @date_translated_scheme='scheme="ISO-8601"' if date =~/\d{4}-\d{2}-\d{2}/
              end
            when /^@type:\s+(.+?)$/m; @type=$1                                                              #% metainfo DC
            when /^@format:\s+(.+?)$/m; @format=$1                                                        #% metainfo DC
            #when /^@identifier:\s+(.+?)$/m; @identifier=$1                                           #% metainfo DC
            when /^@source:\s+(.+?)$/m; @source=$1                                                        #% metainfo DC
            when /^@language(?:\.document)?:\s+(.+?)$/m                                  #% metainfo DC
              x=$1.strip
              lang=SiSU_Env::Standardise_language.new(x.dup)
              @language[:code]=lang.code
              @language[:name]=lang.title
            when /^@language\.original:\s+(.+?)$/m                                            #% metainfo DC
              x=$1.strip
              lang=SiSU_Env::Standardise_language.new(x.dup)
              @language_original[:name]=lang.title
            when /^@relation:\s+(.+?)$/m; @relation=$1                                                  #% metainfo DC
            when /^@coverage:\s+(.+?)$/m; @coverage=$1                                                  #% metainfo DC
            when /^@rights:\s+(.+?)$/m; @rights=$1.gsub(/<(?:\/\s*)?br(?:\s*\/)?>/,Mx[:br_line])          #% metainfo DC copyright, public domain, copyleft, creative commons, etc.
            when /^@papersize:\s+(.+?)$/m                                                              #% metainfo DC
              l=$1
              if @mod.inspect !~/--papersize[=-]\S+/
                l=determine_papersize(l.dup)
                @papersize=l
              end
            when /^@keywords?:\s+(.+?)$/m; @keywords=$1                                                #% metainfo DC
            when /^@comments?:\s+(.+?)$/m; @comments=$1.gsub(/<(?:\/\s*)?br(?:\s*\/)?>/,Mx[:br_line])  #% metainfo DC
            when /^@abstract:\s+(.+?)$/m; @abstract=$1.gsub(/<(?:\/\s*)?br(?:\s*\/)?>/,Mx[:br_line])    #% metainfo DC
            when /^@tags?:\s+\S/m                                                                          #% metainfo
              tags=para.match(/^@tags?:\s+(.+)\Z/m)[1]
              tags.split(/,|$/).each do |tag|
                tag.strip!
                @tags << tag
                @tag_array << tag.split(/:/)
                tag_a=tag.downcase.gsub(/\s+/,'_').gsub(/(.+)/,'[\1]')
                tag_a=tag_a.split(/:/).join('][')
                @tag_a << tag_a
              end
            when /^@catalogue:\s+(.+)?$/m                                                              #% metainfo
              m=$1
              @cls_pg=m.match(/pg=(\S+)/)[1] if m =~/pg=/
              @cls_isbn=m.match(/isbn=(\S+)/)[1] if m =~/isbn=/
              @cls_dewey=m.match(/dewey=(\S+)/)[1] if m =~/dewey=/
              @cls_loc=m.match(/loc=(\S+)/)[1] if m =~/loc=/
            when /^@class(?:ify)?_loc:\s+(.+?)$/m; @cls_loc=$1                                 #% metainfo
            when /^@class(?:ify)?_dewey:\s+(.+?)$/m; @cls_dewey=$1                           #% metainfo
            when /^@class(?:ify)?_pg:\s+(.+?)$/m; @cls_pg=$1                                    #% metainfo
            when /^@(?:class(?:ify)?_)?isbn:\s+(\S+?)$/m; @cls_isbn=$1                   #% metainfo
            when /^@images?:\s+(.+?)$/m; @image=$1                                                       #% processing

            when /^@make:/m                                                                     #% metainfo DC

              if para=~ /^@make:.+?:breaks:[ ]+(.+?)\n/m
                #p $1 #FIX
                #@pagenew=
                #@pagebreak=
              end
              if para=~ /^@make:.+?:headings:[ ]+(.+?)\n/m
                s=$1
                lv=[]
                s=(s =~/;/) ? (s.split(/;\s*/)) : [ s ]
                @toc=s
                lv1=s[0] ||='1~ '
                @lv1=/^#{lv1}/
                lv2=s[1] ||='2~ '
                @lv2=/^#{lv2}/
                lv3=s[2] ||='3~ '
                @lv3=/^#{lv3}/
                lv4=s[3] ||='4~ '
                @lv4=/^#{lv4}/
                lv5=s[4] ||='5~ '
                @lv5=/^#{lv5}/
                lv6=s[5] ||='6~ '
                @lv6=/^#{lv6}/
              end
              if para=~ /^@make:.+?:num_top:[ ]+(.+?)\n/m
                @num_top=$1
              end
              if para=~ /^@make:.+?:skin:[ ]+(.+?)\n/m
                @doc_skin=$1
              end
            when /^@(?:toc|structure):\s+(.+?)\Z/m                                             #% processing
              doc_toc_str=$1
              @toc=doc_toc_str.split(/;\s*/)
              @toc=[ @toc ] if @toc == String
              #@toc.each {|x| x.gsub!(/\{/,'\{') } #FIX~
              lv1=@toc[0] ||='1~ '                                                                                     #some arbitrary changes made
              @lv1=/^#{lv1}/
              lv2=@toc[1] ||='2~ '
              @lv2=/^#{lv2}/
              lv3=@toc[2] ||='3~ '
              @lv3=/^#{lv3}/
              lv4=@toc[3] ||='4~ '
              @lv4=/^#{lv4}/
              lv5=@toc[4] ||='5~ '
              @lv5=/^#{lv5}/
              lv6=@toc[5] ||='6~ '
              @lv6=/^#{lv6}/
            when /^@(?:level|page|markup):\s+(.+?)$/m                                      #% processing revisit..., use syntax 0~level new=1,2,3; break=4
              if para =~/@(?:markup|level|page):?\s+(.+?)\Z/m
                page_break_str=$1
                pagebreaks=page_break_str.split(/;\s*/)
                #pagebreaks=[ pagebreaks ] if pagebreaks == String
                page_new,page_break,num_top=toc_lev_limit=nil
                pagebreaks.each do |x|
                  page_new = x[/(:?[\dA-C],?)+/] if x=~/new|clear/
                  page_break = x[/(:?[\dA-C],?)+/] if x =~/break/
                  num_top = x[/:?[\dA-C]/].to_i if x =~/num_top/
                  toc_lev_limit = x[/:?[\dA-C]/].to_i if x =~/toc_limit/
                end
                @pagenew=page_new if page_new
                @pagebreak=page_break if page_break
                @num_top=num_top if num_top
                @toc_lev_limit=toc_lev_limit if toc_lev_limit
                @flag_auto_heading_num=true if para =~/num_top/
              end
              if para =~/^@markup:\s+(.+?)$/m                                                             #%use of markup depreciated for num_top
                @markup=$1
                @flag_auto_heading_num=true if para =~/num_top/
              end
            when /^@bold:\s+(.+?)$/m                                                                        #% processing
              m=$1.strip
              x=case m
              when /\/i$/; 'i'
              else         ''
              end
              m.gsub!(/^\/(.+?)\/i?/,'\1')
              m.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
              rgx='\b(' + m + ')\b'
              @make_bold[:str]='\b(?:' + m + ')\b'
              @make_bold[:regx]=if x =~/i/; /#{rgx}/i
              else                          /#{rgx}/
              end
              @make_bold
            when /^@(?:italics?|itali[sz]e):\s+(.+?)$/m                                  #% processing Dublin Core - dublin core within
              m=$1.strip
              x=case m
              when /\/i$/; 'i'
              else         ''
              end
              m.gsub!(/^\/(.+?)\/i?/,'\1')
              m.gsub!(/\(/,'(?:') # avoid need to escape use of brackets within regex provided
              rgx='\b(' + m + ')\b'
              @make_italic[:str]='\b(?:' + m + ')\b'
              @make_italic[:regx]=if x =~/i/; /#{rgx}/i
              else                            /#{rgx}/
              end
              @make_italic
            when /^@(?:vocabulary|wordlist):\s+(.+?)$/m                                  #% processing
                @vocabulary=$1                                                                                         #not actually used by concordance
            when /^@skin:\s+(.+?)$/; @doc_skin=$1.strip                                                     #% processing
            when /^@(?:css|stylesheet):\s+(.+?)$/; @doc_css=$1.strip                          #% processing
            when /^@links:\s+(.+?)\Z/m                                                                     #% processing
              doc_links_str=$1
              @lnk=[]
              if doc_links_str=~/\{.+?\}(?:(?:https?|file|ftp):\/|\.\.)\/\S+(?:\s|$)/
                doc_links=doc_links_str.scan(/\{.+?\}(?:(?:https?|file|ftp):\/|\.\.)\/\S+/)
                count=1
                doc_links.each do |x|
                  @lnk[count]={}
                  @lnk[count][:say],@lnk[count][:url]=/\{\s*(.+?)\s*\}((?:(?:https?|file|ftp):\/|\.\.)\/\S+)/im.match(x)[1,2]
                  count +=1
                end
              else
                lnks=doc_links_str.split(/;\s+/)
                #lnks=[ lnks ] if lnks == String
                count=1
                lnks.each do |x|
                  @lnk[count]={}
                  if x =~/^\s*(?:(?:https?|file|ftp):\/\/|\.\.\/)/; @lnk[count][:url]=x
                  else
                    @lnk[count][:say]=x
                    count +=1
                  end
                end
              end
            when /^@prefix(?:_[ab])?:\s/                                                        #% metainfo
              if para =~/prefix_a:?\s+/
                @prefix_a=para[/@prefix_a:\s+(.+?)$/im,1]
              end
              if para =~/prefix(?:_b)?:?\s+/
                @prefix_b=para[/@prefix(?:_b)?:\s+(.+?)$/im,1]
              end
            when /^@suffix:\s+(.+?)$/m; @suffix=$1                                                        #% metainfo
            when /^@information:\s+(.+?)$/m; @information=$1                                         #% metainfo
            when /^(?:@topic_register:[ ]+|@classify:.+?:topic_register:[ ]+)(.+?)\n/m            #% metainfo, similar syntax to book index, leave out the ={} i.e. use equivalent of ={(.+?)}
            #when /^@topic_register:\s+(.+?)$/m; @topic_register=$1                                #% metainfo, similar syntax to book index, leave out the ={} i.e. use equivalent of ={(.+?)}
              @topic_register=$1
              u=@topic_register.scan(/[^;]+/)
              v=[]
              u.each do |l|
                v << l.scan(/[^:]+/)
              end
              v.each do |m|
                m[-1]=m[-1].scan(/[^|]+/) if m[-1] =~/[|]/
                @topic_register_array << m
              end
              @topic_register_array.sort!
            when /^@contact:\s+(.+?)$/m; @contact=$1                                                     #% metainfo
            when /^@original_publication:\s+(.+?)$/m; @original_publication=$1              #% details of original publication
            when /^@icon:\s+(.+?)$/m; @icon=$1                                                              #% processing
            when /^@promo:\s+(.+?)$/m
              @flag_promo=true
              @promo=$1.split(/[,;]\s*/)
            when /^@ad:\s+(\S+)?\s+(\S+\.png)?\s+(.+?!)\s+(\d+)\s*$/m                                         #% processing
              @ad_url,@ad_png,@ad_alt,@ad_began=$1,$2,$3,$4
#           when /0~ad\.home\s+(.+)?\s*$/m                                                                             #% processing
#             ad_home_str=$1
#             @ad_home=ad_home_str.split(/\s+!/)
            when /^@sta?mp(?:ed)?:\s+(.+?)$/m; @stmp= $1.downcase!                                 #% processing
            when /^@(?:rcs|cvs):\+?\s+/                                                              #% processing
              m=/@(?:rcs|cvs):\+?\s+/ #note the + sign to turn on use of rcs or cvs id
              ver=para[/#{m}(.+)/,1] #RCS or CVS ID tag # eg. # $Id$
              contains=/[\$]Id:\s+(\S+),v\s+(\S+)\s+(\S+)\s+(\S+)\s+(\S+)\s+Exp\s+(?:\S+\s+)?[\$]/ # reason for [$] which is apparently unnecessary is that rcs or cvs will otherwise expand id!
              if contains.match(ver)
                filename,vnumber,date,time,operator=contains.match(ver).captures
                @sc_filename,@sc_number,@sc_date,@sc_time=filename,vnumber,date,time
              end
              @sc_info=true if para[/@(?:rcs|cvs):\+/]
            when /^@base_program:\s+(.+?)$/; @base_program=$1                                                          #% processing
              #% break - break, not necessary to process headers further :-) but necessary to extract endnotes etc. ;-(
            when /^@man:\s+(.+?)\Z/m                                                                         #% man pages
              maninfo_str=$1
              maninfo=maninfo_str.split(/;\s*/m)
              maninfo.each do |x|
                @man_section= x[/^([1-8])/] if x =~/^([1-8])/
                @man_name= x[/name=(.+)/,1] if x =~/name=.+/
                @man_synopsis= x[/synopsis=(.+)/m,1] if x =~/synopsis=.+/
              end
            end
            @lv1 ||=/^#{Mx[:lv_o]}1:/
            @lv2 ||=/^#{Mx[:lv_o]}2:/
            @lv3 ||=/^#{Mx[:lv_o]}3:/
            @lv4 ||=/^#{Mx[:lv_o]}4:/
            @lv5 ||=/^#{Mx[:lv_o]}5:/
            @lv6 ||=/^#{Mx[:lv_o]}6:/
          else                                                                                                         #%
            if para =~ /^(?:1|:?A)~/                                                                                   #% processing
              if para=~/^:?A~/
                if @markup.nil? \
                or @markup.empty?
                  @markup=@markup_version.to_s
                elsif @markup !~/0\.38/;            @markup=@markup.strip + "; #@markup_version"
                end
              end
              if (para=~/^:?A~/ and @markup_version >= 0.38) \
              or (para=~/^1~/ and @markup_version < 0.38)
                if @title.nil?
                  @title=para[/^:?[A1]~\S*(.+)$/m,1]
                  @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/,'')
                  @title.chomp!("\n")
                  @html_title.chomp!("\n")
                  tell=SiSU_Screen::Ansi.new(@cmd,'Parameters',@html_title)
                  tell.txt_grey if @cmd =~/v/
                end
              end
            end
            if not @book_idx and para =~/^=\{(.+?)\}\s*$/
              @book_idx=true
            end
            unless @code_flag
              case para
              when /~\{\s+.+?\}~/m                                                                                     #% processing
                en=para.scan(/~\{.+?\}~/m)
                en.each { |e| @en[:sum] +=1 }
              when /~\^(?:\s|$)/m                                                                                      #% processing
                mk=para.scan(/~\^(?:\s|$)/)
                mk.each { |e| @en[:mark] +=1 }
              when /^\^~\s+\S/; @en[:note] +=1                                                                         #% processing
              end
            end
            if para =~/~\{|\^~ |~\^|<:ee>|\{.+?\[[1-6]\]\}\S+?\.ss[tm]/m; @flag_auto_endnotes,@flag_endnotes=true,true
            end
            unless @flag_auto_endnotes
              if para =~/^(4~endnotes\b|<:ee>)/
                @flag_separate_endnotes=true
                @flag_endnotes=true
              end
            end
            if para =~/^(?:4~endnotes|<:ee>)/;           @flag_separate_endnotes_make=false
            end
            if para =~/<!!e[#0-9]+?!>\s*.+/;            @flag_endnotes=true
            end
            if para =~/table\{|<!tableh?\s+c\d+;.+?!>/i; @flag_tables=true
            end
          end
          if (@markup_version >= 0.38 and para =~/^:?A~/) \
          or (@markup_version < 0.38 and para =~/^1~/)
            @set_heading_top=true
          end
          if (@markup_version >= 0.38 and para =~/^1~/) \
          or (@markup_version < 0.38 and para =~/^4~/)
            m=nil
            if @markup_version >= 0.38 \
            and para =~/^1~(\S+)\s+(.+)$/
              m,t=$1,$2
            elsif @markup_version < 0.38 \
            and para =~/^4~(\S+)\s+(.+)$/
              m,t=$1,$2
            elsif @markup_version >= 0.38 \
            and para =~/^1~\s+(.+)$/
              t=$1
            elsif @markup_version < 0.38 \
            and para =~/^4~\s+(.+)$/
              t=$1
            end
            unless @heading_seg_first_flag                                                                             # extract first segment name
              @heading_seg_first=t
              @heading_seg_first_flag=true
            end
            if m                                                                                                       # list all segment names
              @seg_names << m
              @set_heading_seg=true
              if m=~/^\d{1,3}/ \
              and m !~/^0/
                @seg_autoname_safe=false
              end
            end
          end
          if para !~/^%+\s/ \
          and para =~@rgx_image
            @ec[:image] << para.scan(@rgx_image).uniq
          end
          @ec[:audio] << para.scan(@rgx_audio).uniq if para =~@rgx_audio #embedded content
          @ec[:multimedia] << para.scan(@rgx_mm).uniq if para =~@rgx_mm #embedded content
          unless @sem_tag
            @sem_tag=true if para=~/[:;]\{.+?\}[:;][a-z+]/ #refix later
          end
        end                                                                                                            #% here endeth the document loop
        if @ec[:image].length > 0
          @ec[:image].flatten!
          @ec[:image].uniq!
          @ec[:image].delete_if {|x| x =~/http:\/\// }
          @ec[:image].sort!
        end
        @ec[:audio].uniq!; @ec[:audio].flatten!; @ec[:audio].sort!
        @ec[:multimedia].uniq!; @ec[:multimedia].flatten!; @ec[:multimedia].sort!
        @man_name.gsub!(/(-)/,"\\\\\\1")
        @man_name.gsub!(/\n/,"\n.BR\n")
        @man_name.gsub!(/\A/,"\n.SH NAME\n")
        unless @man_synopsis.nil?
          @man_synopsis.gsub!(/(-)/,"\\\\\\1")
          @man_synopsis.gsub!(/\n/,"\n.BR\n")
          @man_synopsis.gsub!(/\A/,"\n.SH SYNOPSIS\n")
        end
        unless @rights
          if @author
            @rights ||=if @date =~/([12][890]\d{2})/                     #matches years 1800 through 20\d\d 2004w19
              "Copyright (C) #{$1} #@author"
            else 'Copyright (C)' + @author
            end
          end
        end
        if @markup_version.to_f >= 0.38 #convert values in headers to internal representation
          translated=[]
          translate_list=[@pagenew,@pagebreak,@num_top,@toc_lev_limit]
          translate_list.each do |t|
            translate=t.to_s if t
            translated << if translate
              #translate.gsub!(/6/,'9')
              #translate.gsub!(/5/,'8')
              #translate.gsub!(/4/,'7')
              translate.gsub!(/3/,'6')
              translate.gsub!(/2/,'5')
              translate.gsub!(/1/,'4')
              translate.gsub!(/:?C/,'3')
              translate.gsub!(/:?B/,'2')
              translate.gsub!(/:?A/,'1')
              translate=if translate =~/^\d+$/; translate.to_i
              else translate
              end
            else nil
            end
          end
          @pagenew,@pagebreak,@num_top,@toc_lev_limit=translated
          @markup.gsub!(/page_new\s*=\s*([\dA-C])/,"page_new=#@pagenew")
          @markup.gsub!(/page_break\s*=\s*([\dA-C])/,"page_break=#@pagebreak")
          @markup.gsub!(/num_top\s*=\s*([\dA-C])/,"num_top=#@num_top")
          @markup.gsub!(/toc_lev_limit\s*=\s*([\dA-C])/,"toc_lev_limit=#@toc_lev_limit")
        end
        if @mod.inspect =~/--papersize[=-]\S+|--pdf[=-]\S+/ \
        or  @mod.inspect =~/--(?:a4|letter|legal|book|a5|b5)\b/i #command line config/header override
          @papersize=determine_papersize(@mod.inspect)
        end
        @papersize_array=@papersize.scan(/(?:a4|letter|legal|book|a5|b5)/i)
        if @sys.openssl !=false
          skin=if @doc_skin; SiSU_Env::Info_skin.new(@opt,@doc_skin).select
          else               SiSU_Env::Info_skin.new(@opt).select
          end
          @dgst,@dgst_skin=[],[]
          if @env.digest.type =~/sha256/
            @dgst=@sys.sha256(@env.source_file_with_path)
            @dgst_skin=if skin; @sys.sha256(skin)
            else                nil
            end
          else
            @dgst=@sys.md5(@env.source_file_with_path)
            @dgst_skin=if skin; @sys.md5(skin)
            else                nil
            end
          end
        end
        @publisher ||= "#@@publisher (this copy)"
        fn_set_lang=SiSU_Env::Standardise_language.new.file_to_language(@fns)
        unless @language[:code] \
        and @language[:name]
          lang=@env.i18n.language #default language settings for directory by name, or in sysrc.yml
          @language[:code] ||= lang.code
          @language[:name] ||= lang.title
        end
        unless fn_set_lang[:d]==true #decide, naming convention overrides other settings, within document, etc.
          @language[:code]=fn_set_lang[:c]
          @language[:name]=fn_set_lang[:l]
        end
        @fnl=@env.i18n.lang_filename(fn_set_lang[:c])
        @flv.each do |l|
          lang=SiSU_Env::Standardise_language.new.file_to_language(l)
          c={ :a=>'',:b=>'',:c=>'' }
          if @fnl[:pre] =~/\S/;     c[:a]="#{lang[:c]}."
          elsif @fnl[:mid] =~/\S/;  c[:b]=".#{lang[:c]}"
          elsif @fnl[:post] =~/\S/; c[:c]=".#{lang[:c]}"
          end
          @lang << [lang[:l],"#{c[:a]}sisu_manifest#{c[:b]}.html#{c[:c]}"]
        end if @flv
        @lang.uniq!
        @fn=SiSU_Env::Env_call.new(@fns).lang(fn_set_lang[:c])
        @identifier="#{@env.url.root}/#@fnb/#{@fn[:toc]}" #DC note constructed dc identifier
        if @en[:note] > 0 \
        and @en[:sum] > 0
          if @en[:sum] > 0
          else tell=SiSU_Screen::Ansi.new(@cmd,'both endnote styles used',"~{ #{@en[:sum]} }~ and ^~ #{@en[:mark]}")
            tell.warn if @cmd !~/q/
          end
        end
        if @en[:mark] != @en[:note] \
        and @en[:note] > 0
          @en[:mismatch]=@en[:note] - @en[:mark]
          SiSU_Screen::Ansi.new(@cmd,'endnote number mismatch',"endnotes: #{@en[:note]} != endnote reference marks: #{@en[:mark]} (difference = #{@en[:mismatch]})").warn if @cmd !~/q/
          footnote_conversion_errors=File.new("#{Dir.pwd}/footnote_conversion_errors.txt",'a')
          footnote_conversion_errors << "#@fns:\n\tendnotes: #{@en[:note]} != endnote reference marks: #{@en[:mark]} (difference = #{@en[:mismatch]})\n"
        end
        if @title !~/[\S]/
          tell=SiSU_Screen::Ansi.new(@cmd,'Document Title Missing','please provide it')
          tell.warn if @cmd =~/v/
        end
        if @author !~/[\S]/
          tell=SiSU_Screen::Ansi.new(@cmd,'Document Author/Creator Missing','please provide it')
          tell.warn if @cmd =~/v/
        end
        # Elementary Document Structure Analysis - adds complexity may remove - need to develop - appears to work, proof of concept
        if @title.nil?
          title_trigger=nil
          fns_array.each do |para|
            if para !~/0~|@\S+:[+-]?\s/ \
            and para =~/\S/ \
            and title_trigger.nil?
              @title=para[/(\S.+)/m,1]
              @html_title=@title.gsub(/(<p>|<p \/>|<br>|<br \/>)/,'')
              @title.chomp!("\n")
              @html_title.chomp!("\n")
              title_trigger=1
              tell=SiSU_Screen::Ansi.new(@cmd,@html_title)
              tell.txt_cyan unless @cmd =~/q/
              tell=SiSU_Screen::Ansi.new(@cmd,'Parameters')
              tell.txt_grey unless @cmd =~/q/
            end
          end
        end
        @struct={}
        doc_struct=Hash.new(0)
        if @lv1.nil?
          fns_array.each do |para|
            if para =~/^(Part|Chapter|Section|Article)\b/i
              case para
              when /^(Part|PART)\b/
                @struct[:part]=doc_struct[:part]
                doc_struct[:part]=doc_struct[:part] + 1
              when /^(Chapter|CHAPTER)\b/
                @struct[:chapter]=doc_struct[:chapter]
                doc_struct[:chapter]=doc_struct[:chapter] + 1
              when /^(Section|SECTION)\b/
                @struct[:section]=doc_struct[:section]
                doc_struct[:section]=doc_struct[:section] + 1
              when /^(Article|ARTICLE)\b/
                @struct[:article]=doc_struct[:article]
                doc_struct[:article]=doc_struct[:article] + 1
              when /^(Clause|CLAUSE)\b/
                @struct[:clause]=doc_struct[:clause]
                doc_struct[:clause]=doc_struct[:clause] + 1
              when /^\d\..*[^\.]$/
                @struct[:number]=doc_struct[:number]
                doc_struct[:number]=doc_struct[:number] + 1
              end
            end
          end
          if doc_struct[:article] > 2                                            #%~level 4
            @lv4=/^(?:Article|ARTICLE)\b/
          elsif doc_struct[:chapter] > 2 \
          and doc_struct[:article] \
          and doc_struct[:article] < 3
            @lv4=/^(?:Chapter|CHAPTER)\b/
          elsif doc_struct[:clause] > 2
            @lv4=/^(?:Clause|CLAUSE)\b/
          elsif doc_struct[:number] > 2
            @lv4="^\d\..*[^\.]$"
          end
          if doc_struct[:section] > 2                                           #%~level 3
            @lv3=/^(?:Section|SECTION)\b/
          end
          if doc_struct[:chapter] > 2 \
          and doc_struct[:article] \
          and doc_struct[:article] > 2
            @lv2=/^(?:Chapter|CHAPTER)\b/
          end
          if doc_struct[:part] > 2 \
          and @lv[2].nil?
            @lv2=/^(?:Part|PART)\b/
          end
          if doc_struct[:part] > 2 \
          and @lv[2].inspect !~/Part/ \
          and @lv[1].nil?
            @lv1=/^(Part|PART)\b/
          end
        end
        @lnk=@lnk.compact if @lnk
        @lv1 ||=/^#{Mx[:lv_o]}1:/
        @lv2 ||=/^#{Mx[:lv_o]}2:/
        @lv3 ||=/^#{Mx[:lv_o]}3:/
        @lv4 ||=/^#{Mx[:lv_o]}4:/
        @lv5 ||=/^#{Mx[:lv_o]}5:/
        @lv6 ||=/^#{Mx[:lv_o]}6:/
        if @doc_skin
          tell=SiSU_Screen::Ansi.new(@cmd,"doc_skin <- #@doc_skin")
          tell.txt_grey if @cmd =~/v/
        end
        @data=nil #else whole file's contents are stored in md pstore & is not required to be... big waste actually
        Store.new(self,@env).store                                                                                     #% pstore
        self
      end
      private
      class Store
        def initialize(md,dir)
          @md=md
          @pstorefile="#{dir.path.dal}/#{md.fns}.pstore"
        end
        def store
          File.unlink(@pstorefile) if FileTest.file?(@pstorefile)
          tell=SiSU_Screen::Ansi.new(@md.cmd,"PStore -> #@pstorefile")
          tell.txt_grey if @md.cmd =~/v/
          store=PStore.new(@pstorefile)
          store.transaction do
            store['md']=@md
            #doc.each{|x,y| puts "#{x}, #{y}; "}
            store.commit
          end
          @@md=@md=nil
        end
      end
    end
  end
  class Instantiate
    def param_instantiate
      @@date=SiSU_Env::Info_date.new
      @@symlnk=SiSU_Env::Create_system_link.new
      @@proc=@@filename_txt=@@filename_texinfo=@@filename_lout_portrait=@@filename_lout_landscape=@@filename_html_scroll=@@filename_html_index=@@filename_html_segtoc=@@filename_semantic=@@filename_rss=@@newfile=@@drr=nil
      @doc={
       :initialise=>nil,
       :markup=>'',:lnks=>'',:stmp=>'',:prefix_a=>'',:prefix_b=>'',
       :req=>{}
      }
      @@yaml=@@yamladdr=nil
      @@flag={}
      @@publisher='SiSU scribe'
    end
  end
end
__END__
