/***************************************************************************
 *   Copyright (C) 2008 by S. MANKOWSKI / G. DE BURE skrooge@mankowski.fr  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>  *
 ***************************************************************************/
/** @file
 * This file is a plugin for dataengine management.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgdataengineplugin.h"
#include "skgtraces.h"
#include "skgerror.h"
#include "skgmainpanel.h"
#include "skgservices.h"
#include "skgnodeobject.h"
#include "skgtransactionmng.h"

#include <QtGui/QWidget>


/**
 * This plugin factory.
 */
K_PLUGIN_FACTORY ( SKGDataenginePluginFactory, registerPlugin<SKGDataenginePlugin>(); )
/**
 * This plugin export.
 */
K_EXPORT_PLUGIN ( SKGDataenginePluginFactory ( "skg_dataengine", "skg_dataengine" ) )

SKGDataenginePlugin::SKGDataenginePlugin ( QObject* iParent, const QVariantList& iArg ) :
        SKGInterfacePlugin ( iParent )
{
    Q_UNUSED ( iArg );
    SKGTRACEIN ( 10, "SKGDataenginePlugin::SKGDataenginePlugin" );
}

SKGDataenginePlugin::~SKGDataenginePlugin()
{
    SKGTRACEIN ( 10, "SKGDataenginePlugin::~SKGDataenginePlugin" );
    currentDocument=NULL;
}

bool SKGDataenginePlugin::setupActions ( SKGDocument* iDocument, const QStringList& iArgument )
{
    SKGTRACEIN ( 10, "SKGDataenginePlugin::setupActions" );
    Q_UNUSED ( iArgument );

    currentDocument=iDocument;

    setComponentData ( SKGDataenginePluginFactory::componentData() );
    setXMLFile ( "skg_dataengine.rc" );

    return true;
}

void SKGDataenginePlugin::refresh()
{
    SKGTRACEIN ( 10, "SKGDataenginePlugin::refresh" );
}

QString SKGDataenginePlugin::title() const
{
    return i18nc ( "Noun, a dataengine as in presenting data to dashboard widgets","Dataengine" );
}

QStringList SKGDataenginePlugin::tips() const
{
    QStringList output;
    return output;
}

int SKGDataenginePlugin::getOrder() const
{
    return 500;
}

void SKGDataenginePlugin::close()
{
    SKGTRACEIN ( 10, "SKGDataenginePlugin::close" );
}


#include "skgdataengineplugin.moc"
