/***************************************************************************
    smb4kscanner_p  -  This is a private helper class for Smb4KScanner.
                             -------------------
    begin                : Do Jul 19 2007
    copyright            : (C) 2007 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

#ifndef SMB4KSCANNER_P_H
#define SMB4KSCANNER_P_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// Qt includes
#include <QString>

// application specific includes
#include <smb4kworkgroup.h>
#include <smb4khost.h>


class Smb4KScannerPrivate
{
  public:
    Smb4KScannerPrivate();
    ~Smb4KScannerPrivate();
    bool retry;
    void clearData();
    void setWorkgroup( const Smb4KWorkgroup &workgroup );
    void setHost( const Smb4KHost &host );
    Smb4KWorkgroup &workgroup() { return m_workgroup; }
    Smb4KHost &host() { return m_host; }

  private:
    Smb4KWorkgroup m_workgroup;
    Smb4KHost m_host;
};


class Smb4KScannerQueueContainer
{
  public:
    Smb4KScannerQueueContainer( int todo, const Smb4KWorkgroup &workgroup );
    Smb4KScannerQueueContainer( int todo, const Smb4KHost &item );
    Smb4KScannerQueueContainer( int todo, const QString &string );
    Smb4KScannerQueueContainer( int todo );
    ~Smb4KScannerQueueContainer();
    int todo() { return m_todo; }
    const Smb4KWorkgroup &workgroup() const { return m_workgroup; }
    const Smb4KHost &host() const { return m_host; }
    const QString &string() const { return m_string; }

  private:
    int m_todo;
    Smb4KWorkgroup m_workgroup;
    Smb4KHost m_host;
    QString m_string;
};

#endif
