/***************************************************************************
    smb4kbookmark  -  This is the bookmark container for Smb4K (next
    generation).
                             -------------------
    begin                : So Jun 8 2008
    copyright            : (C) 2008 by Alexander Reinholdt
    email                : dustpuppy@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful, but   *
 *   WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   General Public License for more details.                              *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,   *
 *   MA  02111-1307 USA                                                    *
 ***************************************************************************/

// Qt includes
#include <QHostAddress>
#include <QAbstractSocket>

// application specific includes
#include <smb4kbookmark.h>
#include <smb4kshare.h>


Smb4KBookmark::Smb4KBookmark( Smb4KShare *share, const QString &label )
: m_workgroup( share->workgroup() ), m_host( share->host() ), m_share( share->name() ),
  m_ip( share->hostIP() ), m_type( share->type() ), m_unc( share->unc() ), m_label( label ),
  m_profile( QString() )
{
}


Smb4KBookmark::Smb4KBookmark( const Smb4KBookmark &b )
: m_workgroup( b.workgroup() ), m_host( b.host() ), m_share( b.share() ),
  m_ip( b.hostIP() ), m_type( b.type() ), m_unc( b.unc() ), m_label( b.label() ),
  m_profile( b.profile() )
{
}


Smb4KBookmark::Smb4KBookmark()
: m_workgroup( QString() ), m_host( QString() ), m_share( QString() ),
  m_ip( QString() ), m_type( "Disk" ), m_unc( QString() ), m_label( QString() ),
  m_profile( QString() )
{
}


Smb4KBookmark::~Smb4KBookmark()
{
}


void Smb4KBookmark::setWorkgroup( const QString &workgroup )
{
  m_workgroup = workgroup;
}


void Smb4KBookmark::setHost( const QString &host )
{
  m_host = host;
  m_unc = "//"+host+"/"+m_share;
}


void Smb4KBookmark::setShare( const QString &share )
{
  m_share = share;
  m_unc = "//"+m_host+"/"+share;
}


void Smb4KBookmark::setHostIP( const QString &ip )
{
  m_ip = ipIsValid( ip );
}


void Smb4KBookmark::setType( const QString &type )
{
  m_type = type;
}


void Smb4KBookmark::setUNC( const QString &unc )
{
  m_unc = unc;

  // Extract host and share from the UNC
  if ( !unc.contains( "@" ) )
  {
    m_host = m_unc.section( "/", 2, 2 ).trimmed();
  }
  else
  {
    m_host = m_unc.section( "@", 1, 1 ).section( "/", 0, 0 ).trimmed();
  }

  m_share = m_unc.section( "/", 3, 3 ).trimmed();
}


void Smb4KBookmark::setLabel( const QString &label )
{
  m_label = label;
}


void Smb4KBookmark::setProfile( const QString &profile )
{
  m_profile = profile;
}


const QString &Smb4KBookmark::ipIsValid( const QString &ip )
{
  QHostAddress ip_address( ip );

  if ( ip_address.protocol() == QAbstractSocket::UnknownNetworkLayerProtocol )
  {
    // The IP address is invalid.
    static_cast<QString>( ip ).clear();
  }

  return ip;
}
