/*
 * DVEncoderAudioParams.h -- DV Encoder Classes
 * Copyright (C) 2002 Charles Yates <charles.yates@pandora.be>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _KINO_DV_ENCODER_AUDIO_PARAMS_
#define _KINO_DV_ENCODER_AUDIO_PARAMS_

#include <string>
using std::string;

/** Parameters associated to DV audio encoding.
*/

class DVEncoderAudioParams
{
	private:
		string audio_file;
		bool audio_loop;
		int frequency;
		int channels;
		int bits_per_sample;

	public:
		DVEncoderAudioParams( ) :
			audio_file( "" ),
			audio_loop( false ),
			frequency( 48000 ),
			channels( 2 ),
			bits_per_sample( 16 )
		{
		}

		void SetAudioFile( string _audio_file ) { audio_file = _audio_file; }
		void SetFrequency( int _frequency ) { frequency = _frequency; }
		void SetChannels( int _channels ) { channels = _channels; }
		void SetBitsPerSample( int _bits_per_sample ) { bits_per_sample = _bits_per_sample; }
		void SetAudioLoop( bool _audio_loop ) { audio_loop = _audio_loop; }
		string GetAudioFile( ) { return audio_file; }
		int GetFrequency( ) { return frequency; }
		int GetChannels( ) { return channels; }
		int GetBitsPerSample( ) { return bits_per_sample; }
		bool GetAudioLoop( ) { return audio_loop; }
};

#endif
