

#ifndef CONVERSIONOPTIONS_H
#define CONVERSIONOPTIONS_H

#include "outputdirectory.h"

#include <qstring.h>

/**
 * @short Here the options for the conversion process can be stored
 * @author Daniel Faust <hessijames@gmail.com>
 * @version 0.3
 */
class ConversionOptions
{
public:
    struct EncodingOptions {
        QString sFormat;                  // output format
        QString sQualityMode;             // which mode are we using? quality, bitrate, lossless? i18n()!!!
        int iQuality;                     // the encoding quality / bitrate
        QString sBitrateMode;             // when using bitrate mode, which? abr, cbr?
        bool bBitrateRange;               // enable bitrate range?
        int iMinBitrate, iMaxBitrate;     // when using bitrate range
        struct SamplingRateOptions {      // special options, when sampling rate is enabled
            bool bEnabled;
            int iSamplingRate;
        } samplingRate;
        struct ChannelsOptions {          // special options, when channels is enabled
            bool bEnabled;
            QString sChannels;
        } channels;
        struct ReplaygainOptions {        // special options, when replaygain is enabled
            bool bEnabled;
        } replaygain;
        QString sInOutFiles;               // could be called 'user defined parameter'
                                           // but it is analog to the in_out_files option in the plugins
    };
    struct OutputOptions {
        OutputDirectory::Mode mode;
        QString directory;
    };

    /**
     * Constructor
     */
    ConversionOptions();

    /**
     * Destructor
     */
    virtual ~ConversionOptions();

    /**
     * Checks whether this ConversionOptions and @p other are equal, except the 'filePathName' and 'outputFilePathName' members
     */
    bool nearlyEqual( const ConversionOptions& other );

    QString filePathName;            // the path and name of the file
    QString outputFilePathName;      // if the user wants to change the output directory/file name per file!
    EncodingOptions encodingOptions; // what shall we do with the file?
    OutputOptions outputOptions;     // where to save the file?
};

#endif // CONVERSIONOPTIONS_H
