message("-- Checking for libunique...")
pkg_check_modules(UNIQUE unique-1.0)
message("-- Checking for libgee...")
pkg_check_modules(GEE gee-1.0)
message("-- Checking for libnotify...")
pkg_check_modules(LIBNOTIFY libnotify)

if(UNIQUE_FOUND)
    set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${UNIQUE_INCLUDE_DIRS})
    set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${UNIQUE_CFLAGS_OTHER})
    set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${UNIQUE_LDFLAGS})
else()
    message(FATAL_ERROR "libunique not found")
endif()

if(GEE_FOUND)
    set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${GEE_INCLUDE_DIRS})
    set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${GEE_CFLAGS_OTHER})
    set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${GEE_LDFLAGS})
else()
    message(FATAL_ERROR "libgee not found")
endif()

if(LIBNOTIFY_FOUND)
    set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${LIBNOTIFY_INCLUDE_DIRS})
    set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${LIBNOTIFY_CFLAGS_OTHER})
    set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${LIBNOTIFY_LDFLAGS})
else()
    message(FATAL_ERROR "libnotify not found")
endif()

if(WANT_AYATANA)
	message("-- Checking for libappindicator...")
	pkg_check_modules(APPINDICATOR appindicator-0.1)
	
	if(APPINDICATOR_FOUND)
		set(EXTRA_DEP_INCLUDES ${EXTRA_DEP_INCLUDES} ${APPINDICATOR_INCLUDE_DIRS})
		set(EXTRA_DEP_CFLAGS ${EXTRA_DEP_CFLAGS} ${APPINDICATOR_CFLAGS_OTHER})
		set(EXTRA_DEP_LIBS ${EXTRA_DEP_LIBS} ${APPINDICATOR_LDFLAGS})
	endif()
endif()
