/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_REPOSITORYMODEL_H
#define _SC_REPOSITORYMODEL_H

// sc
#include "BaseModel.h"
#include "util/String.h"
#include "svn/ClientTypes.h"
#include "svn/DirEntryTypes.h"
class ScModel;
class Project;
class CmdResultCallback;
class DetailsParam;
class ListParam;
class MergeParam;
class MkdirParam;
class PropListParam;
class SwitchParam;
class ImportParam;

// sys
#include <map>

namespace svn
{
class Revision;
}


class RepositoryModel : public BaseModel
{
public:
  typedef std::map<sc::String,svn::DirEntryPtr> MapEntry;

  RepositoryModel( ScModel* model );

  void setRoot( long rpId, const sc::String& url );
  sc::String getRootUrl() const;
  long getRpId() const;

  void setCurrentUrl( const sc::String& currUrl );
  const sc::String& getCurrentUrl() const;
  void setCurrentEntry( svn::DirEntryPtr );
  sc::String getParentUrl() const;

  void setProject( Project* prj );
  Project* getProject() const;

  const MapEntry& getAllEntries() const;
  const MapEntry& getNewEntries() const;
  void addEntries( const svn::DirEntries& entriesNew );
  void setSelection( const svn::DirEntries& statussSel );

  void getSelection( svn::Paths& paths ) const;
  void getSelection( svn::DirEntries& entries ) const;

  void list( ListParam*, CmdResultCallback* );
  void mkdir( MkdirParam*, CmdResultCallback* );
  void proplist( PropListParam*, CmdResultCallback* );
  void switchx( SwitchParam*, CmdResultCallback* );
  void details( DetailsParam*, CmdResultCallback* );
  void import( ImportParam*, CmdResultCallback* );

  void copy2( const sc::String& dst, CmdResultCallback* );
  void move2( const sc::String& dst, CmdResultCallback* );

  bool isRepository() const;
  bool isWorkingCopy() const;

  void update( const sc::String& root, const svn::DirEntries& statuss );

  /** the selected item is a directory? */
  bool isDir();
  /** the selected item is a file? */
  bool isFile();

private:
  void reset();

private:
  Project*          _prj;             ///< our "project"
  long              _rpId;            ///< unique rp id
  sc::String        _rootUrl;         ///< our repository root url
  sc::String        _currUrl;         ///< the url of the active repository lvi

  MapEntry          _entriesAll;      ///< all entries in entry.
  MapEntry          _entriesNew;      ///< all new entries.

  svn::DirEntries   _entriesSel;      ///< all currently selected entries.
};


#endif // _SC_REPOSITORYMODEL_H
