import olpcgames
import glob
import os

import pygame
import olpcgames
from sugar.activity import activity

#from sugar.graphics.toolbutton import ToolButton
from sugar.graphics.toolcombobox import ToolComboBox
from sugar.graphics.combobox import ComboBox

class PhysicsActivity(olpcgames.PyGameActivity):
    game_name = 'physics'
    game_title = 'Physics'
    game_size = None    # let olpcgames pick a nice size for us

    def build_toolbar( self ):
        """Build our Activity toolbar for the Sugar system."""
        toolbar = super( PhysicsActivity, self ).build_toolbar()
        
        # toolbar.harder = ToolButton('activity-harder')
        # toolbar.harder.set_tooltip(_('Harder'))
        # toolbar.harder.connect('clicked', self._harder_cb)
        # toolbar.insert(toolbar.harder, 2)
        # toolbar.harder.show()
        
        self.scene_combo = ComboBox()
        self.scene_combo.connect('changed', self._scene_changed_cb)
        scenefolder = os.path.join(activity.get_bundle_path(), "scenes")
        scenepaths = glob.glob(os.path.join(scenefolder, "*.py"))
        scenepaths.sort()
        for path in scenepaths:
            modulename = os.path.basename(path)[:-3] # remove the .py
            nicename = modulename.capitalize()
            if not modulename.startswith("__"):
                self.scene_combo.append_item(modulename, nicename)
        #self.scene_combo.set_active(0)
        combotool = ToolComboBox(self.scene_combo)
        toolbar.insert(combotool, 1)
        combotool.show()
        
        return toolbar

    def _scene_changed_cb(self, combo):
        print "Scene change:", combo.props.value
        pygame.event.post(olpcgames.eventwrap.Event(pygame.USEREVENT, action='scene-changed', scene=combo.props.value))
