from Box2D import *

class Scene:

    def __init__(self, game, screen):
        screen_w, screen_h = screen.get_size()
        
        # pixels per meter
        self.ppm = screen_w / 12.;
        
        # degrees to radians
        d2r = b2_pi/180.0
        
        # init game
        # Define the size of the world. Simulation will still work
        # if bodies reach the end of the world, but it will be slower.
        aabb = b2AABB()
        aabb.lowerBound.Set(-12, -12)
        aabb.upperBound.Set( 24,  24)
        self.gravity = b2Vec2(0,-9.81)
        self.world = b2World(aabb, self.gravity, 1)
        
        def staticRect(x,y,w,h,lx=0,ly=0,r=0,collisonMask=(1,0xffff)):
            bodyDef = b2BodyDef()
            bodyDef.position.Set(x,y)
            body = self.world.CreateStaticBody(bodyDef)
            shapeDef = b2PolygonDef()
            shapeDef.SetAsBox(w/2.0,h/2.0, b2Vec2(w/2.0+lx,h/2.0+ly), r)
            shapeDef.categoryBits, shapeDef.maskBits = collisonMask
            body.CreateShape(shapeDef)
            return body
        
        ground    = staticRect(0,-1, 12,1)
        leftWall  = staticRect(-1,0, 1,9)
        rightWall = staticRect(12,0, 1,9)
        #ceiling   = staticRect(0,9,  12,1)
    
        ramp1 = staticRect(1.5,5, 5,0.2, 0,0, 15*d2r, (2,2))
        ramp2 = staticRect(0,1, 8,0.2, 0,0, -15*d2r, (2,2))
        ramp3 = staticRect(7,0, 6,0.2, 0,0, 20*d2r, (2,2))
    
        # mixer motor
        motorBodyDef = b2BodyDef()
        motorBodyDef.position.Set(7.75, 4.0)
        motorBodyDef.rotation = b2_pi/4.0
        motor = self.world.CreateDynamicBody(motorBodyDef)
    
        wheelDef = b2CircleDef()
        wheelDef.density = 1.0
        wheelDef.radius = 2.5
        wheelDef.restitution = 0.15
        wheelDef.friction = 0.5
        wheelDef.categoryBits, wheelDef.maskBits = (1,1)
        motor.CreateShape(wheelDef)
        
        for d in range(0, 360, 60):
            r = d*d2r
            m = b2Mat22(r)
            paddleDef = b2PolygonDef()
            paddleDef.SetAsBox(0.1, 0.9, b2Mul(m,b2Vec2(0.0, 2.9)), r+20*d2r)
            paddleDef.density = 5.0
            paddleDef.restitution = 0.15
            paddleDef.friction = 0.5
            paddleDef.categoryBits, paddleDef.maskBits = (1,1)
            motor.CreateShape(paddleDef)
        motor.SetMassFromShapes()
    
        motorJointDef = b2RevoluteJointDef()
        motorJointDef.Initialize(self.world.GetGroundBody(), motor, motor.GetPosition())
        motorJointDef.maxMotorTorque = 400.0
        motorJointDef.motorSpeed = 1.0
        motorJointDef.enableMotor = True
        self.world.CreateJoint(motorJointDef)
    
        numBoxes = 50
        for i in range(0,numBoxes):
    
            # Define the dynamic body. We set its position,
            # add the box shape, and call the body factory.
            bodyDef = b2BodyDef()
            bodyDef.position.Set(0.0+0.1*i, 8.0)
            bodyDef.angle = b2_pi/10.0 * i
            body = self.world.CreateDynamicBody(bodyDef)
    
            if i%2 == 0:
                boxDef = b2PolygonDef()
                boxDef.SetAsBox(0.25, 0.25)
                boxDef.density = 1.0
                boxDef.restitution = 0.15
                boxDef.friction = 0.5
                boxDef.categoryBits, boxDef.maskBits = (3,0xffff)
                body.CreateShape(boxDef)
            else:
                circleDef = b2CircleDef()
                circleDef.density = 1.0
                circleDef.radius = 0.25
                circleDef.restitution = 0.15
                circleDef.friction = 0.5
                circleDef.categoryBits, circleDef.maskBits = (3,0xffff)
                body.CreateShape(circleDef)
        
            body.SetMassFromShapes()
        
        self.game = game
        game.ppm = self.ppm
        game.world = self.world
