from Box2D import *

class Scene:

    def __init__(self, game, screen):
        screen_w, screen_h = screen.get_size()
        
        # pixels per meter
        self.ppm = screen_w / 4.;
    
        # init game
        # Define the size of the world. Simulation will still work
        # if bodies reach the end of the world, but it will be slower.
        aabb = b2AABB()
        aabb.lowerBound.Set(-100, -100)
        aabb.upperBound.Set( 110,  110)
        self.gravity = b2Vec2(0,-9.81)
        self.world = b2World(aabb, self.gravity, 1)
    
        fixedBodyDef = b2BodyDef();
        fixedBodyDef.position.Set(0.0, 0.0)
        ground = self.world.CreateStaticBody(fixedBodyDef)
    
        # Define the ground
        fixedBoxDef1 = b2PolygonDef()
        fixedBoxDef1.SetAsBox(1.0, 0.1, b2Vec2(2.0, 0.5), 0)
        ground.CreateShape(fixedBoxDef1)
    
        # left wall
        fixedBoxDef2 = b2PolygonDef()
        fixedBoxDef2.SetAsBox(0.1, 1.0, b2Vec2(1.0, 1.5), 0)
        ground.CreateShape(fixedBoxDef2)
    
        # right wall
        fixedBoxDef3 = b2PolygonDef()
        fixedBoxDef3.SetAsBox(0.1, 1.0, b2Vec2(3.0, 1.5), 0)
        ground.CreateShape(fixedBoxDef3)
    
        # mixer motor
        motorBodyDef = b2BodyDef()
        motorBodyDef.position.Set(2.0, 1.5)
        motorBodyDef.rotation = b2_pi/4.0
        motor = self.world.CreateDynamicBody(motorBodyDef)
    
        paddleDef = b2PolygonDef()
        paddleDef.SetAsBox(0.1, 0.4, b2Vec2(0.0, 0.25), 0)
        paddleDef.density = 5.0
        paddleDef.restitution = 0.15
        paddleDef.friction = 0.5
        motor.CreateShape(paddleDef)
        motor.SetMassFromShapes()
    
        motorJointDef = b2RevoluteJointDef()
        motorJointDef.Initialize(self.world.GetGroundBody(), motor, motor.GetPosition())
        motorJointDef.maxMotorTorque = 110.0
        motorJointDef.motorSpeed = 1.0
        motorJointDef.enableMotor = True
        self.world.CreateJoint(motorJointDef)
    
        numBoxes = 50
        for i in range(0,numBoxes):
    
            # Define the dynamic body. We set its position,
            # add the box shape, and call the body factory.
            bodyDef = b2BodyDef()
            bodyDef.position.Set(2.0, 3.0+0.21*i)
            bodyDef.angle = b2_pi/10.0 * i
            body = self.world.CreateDynamicBody(bodyDef)
    
            if i%2 == 0:
                boxDef = b2PolygonDef()
                boxDef.SetAsBox(0.1, 0.1)
                boxDef.density = 1.0
                boxDef.restitution = 0.15
                boxDef.friction = 0.5
                body.CreateShape(boxDef)
            else:
                circleDef = b2CircleDef()
                circleDef.density = 1.0
                circleDef.radius = 0.1
                circleDef.restitution = 0.15
                circleDef.friction = 0.5
                body.CreateShape(circleDef)
        
            body.SetMassFromShapes()
        
        self.game = game
        game.ppm = self.ppm
        game.world = self.world
