from __future__ import division
from pyglet.gl import *
import pyglet

import elements

from math import cos, pi, sin, sqrt

from pyglet.window import key
from pyglet.window import mouse

class Circle(object):
  segs = 15
  coef = 2.0*pi/(segs-1);
  
  vertsGL = None

  def __init__(self,x,y,rad, space):
    self.x = x
    self.y = y
    self.radius = rad
    self.angle = 0.0
    
    self.body = space.add.ball((x,y),rad)
    self.space = space
    
    self.colorGL = None
    
    self.genColor(0,100,0)
    
  @staticmethod  
  def genVertices():
    vertices = []
    x,y = (0,0)
    angle = 0
    radius = 10
    prevX = radius*cos(angle) + x
    prevY = radius*sin(angle) + y

    vExtend = vertices.extend
    """
    for n in xrange(Circle.segs-1):
      rads2 = (n+1)*Circle.coef
      vExtend([x,y,prevX, prevY, radius*cos(rads2 + angle) + x, radius*sin(rads2 + angle) + y])
      prevX = vertices[-2]
      prevY = vertices[-1]
    """    
    for n in range(Circle.segs):
       rads = n*Circle.coef
       vExtend([radius*cos(rads + angle) + x, radius*sin(rads + angle) + y])
    vExtend([x,y])
    
    Circle.vertsGL = (GLfloat * len(vertices))(*vertices)
    
  def genColor(self,r,g,b):
    colors = []
    
    for n in xrange(self.segs):
      colors.extend([r,g,b,r,g,b,r,g,b]) 
      
    self.colorGL = (GLfloat * len(colors))(*colors)
    
  def update(self,dt):
    #self.angle += 0.8

    shape = self.body.GetShapeList()
    self.angle = self.body.GetAngle()
    xform = self.body.GetXForm()
               
    type = shape.GetType()

    circle = shape.asCircle()
    position = elements.box2d.b2Mul(xform, circle.GetLocalPosition())
    
    pos = self.space.to_screen((position.x*self.space.ppm, position.y*self.space.ppm))
    self.x = pos[0]
    self.y = pos[1]
    
  def draw(self):
    glLoadIdentity()
    glTranslatef(self.x, self.y, 0)
    glRotatef(self.angle, 0, 0, 1)
    #glScalef(self.size, self.size, 1)
    glColorPointer(4, GL_BYTE, 0, self.colorGL)

    glDrawArrays(GL_LINE_LOOP, 0, len(self.vertsGL) // 2)

# The active gameworld
class GameWorld(object):

  def __init__(self, app):
    self.app = app
    self.dynamicEntities = []
    self.staticEntities  = []
    
    # init physics
    self.space = elements.Elements((app.winWidth,app.winHeight), renderer='opengl_pyglet')
    # set pyglet properties
    self.space.set_inputAxisOrigin(left=True, top=False)
    
    self.space.add.ground()
    
    for i in range(20):
      for j in range(25):
        self.dynamicEntities.append(Circle( 10+i*25, 500-j*25, 10, self.space))

  def draw(self):
    glClear(GL_COLOR_BUFFER_BIT)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()

    glEnableClientState(GL_VERTEX_ARRAY)
    glEnableClientState(GL_COLOR_ARRAY)
    glVertexPointer(2, GL_FLOAT, 0, Circle.vertsGL)

    # draw all the game entities
    for ent in self.dynamicEntities:
      ent.draw()
    
  def update(self,dt):
    #update physics simulation
    self.space.update(60)
    
    for ent in self.dynamicEntities:
      ent.update(dt)
 
# App handles the window, initialization and scheduling
class App(pyglet.window.Window):
  def __init__(self, *args, **keys):
    super(App, self).__init__(*args, **keys)
    
    # init default behaviour
    self.winWidth  = args[0]
    self.winHeight = args[1]
    
    self.initGL()
    
    self.gameWorld = GameWorld(self)

    pyglet.clock.schedule(self.gameWorld.update)
    
    self.fps = pyglet.clock.ClockDisplay()
    
  def initGL(self):
    glClearColor(1.0, 1.0, 1.0, 0.0)
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    glOrtho(-100.0, 100.0, -100.0, 100.0, -1.0, 1.0)
    glMatrixMode(GL_MODELVIEW)

  def on_draw(self):
    glClearColor(1,1,1,0)
    glClear(GL_COLOR_BUFFER_BIT)
    
    self.gameWorld.draw()
    
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
    self.fps.draw()

if __name__ == '__main__':
  Circle.genVertices()
  window = App(800,600,vsync=False)
  pyglet.app.run()