/*
 *	libetm-0.4 / misc.c - Copyright (C) Emmanuel Thomas-Maurin 2008-2011
 * 	<manutm007@gmail.com>
 *
 *	- misc functions -
 *
 * 	This program is free software: you can redistribute it and/or modify
 * 	it under the terms of the GNU General Public License as published by
 * 	the Free Software Foundation, either version 3 of the License, or
 * 	(at your option) any later version.
 *
 * 	This program is distributed in the hope that it will be useful,
 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
 * 	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * 	GNU General Public License for more details.
 *
 * 	You should have received a copy of the GNU General Public License
 * 	along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdio.h>
#include <ctype.h>
#include "libetm.h"

#define LIBETM_VERSION	"Libetm-0.4"

const char *lib_version(unsigned int i)
{
	static const char *libv[] = {
		LIBETM_VERSION,
		"Copyright (C) Emmanuel Thomas-Maurin 2008-2011\nmanutm007@gmail.com\n"
		"This program comes with ABSOLUTELY NO WARRANTY. This is free software, and\n"
		"you are welcome to redistribute it under certain conditions; see COPYING for\n"
		"details.",
		"Compiled on "__DATE__" - "__TIME__,
	};

	if (i < sizeof(libv) / sizeof(libv[0]))
		return (const char *)libv[i];
	else
		return NULL;
}

int question(const char *str)
{
	int	i, c;

	while (1) {
		printf("%s [y/n] ? ", str);
		i = fgetc(stdin);
		c = tolower(i);
		while (i != '\n' && i != EOF)
			(i = fgetc(stdin));
		if (c == 'y')
			return TRUE;
		else if (c == 'n')
			return FALSE;
	}
}
