/***************************************************************************
 *   copyright            : (C) 1999 by Daniel Reith                       *
 *   email                : DanR@gmx.de                                    *
 *                                                                         *
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : pingos@hendrik-sattler.de                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "outputcontrol.h"
#include "inputcontrol.h"
#include "LessonController.H"
#include <wx/wx.h>
#include <wx/splitter.h>
#include <wx/textfile.h>
#include <wx/toolbar.h>
#include <wx/config.h>
#include <wx/intl.h>

class tipptrainer : public wxApp {
 public:
  virtual bool OnInit();
  virtual int OnExit();
 private:
  wxLocale m_locale;
  void localize();
};

class TtInputControl;
class TtOutputControl;

class Hauptfenster : public wxFrame {
 public:
  Hauptfenster();
  ~Hauptfenster();
  //this is a center of the application, so it should be
  //possible from anywhere to get a pointer to this
  static Hauptfenster* getPtr() { return localpointer; };

  void OnSize(wxSizeEvent& event);

  void OnHilfe_Info(wxCommandEvent& event);
  void OnD_Beenden(wxCommandEvent& event);

  // Einzelne Lektionen laden bzw. abbrechen
  void OnD_LBeenden(wxCommandEvent& event);
  void OnLektionLaden(wxCommandEvent& event);
  void OnD_LektionPause(wxCommandEvent& event);

  // 10 Finger Kurs beginnen, laden bzw abbrechen
  void OnD_KursLaden(wxCommandEvent& event);
  void OnO_Einstellungen(wxCommandEvent& event);
  void OnO_Schriftwaehlen(wxCommandEvent& event);
  void OnO_SwitchBell (wxCommandEvent& event);

  void OnC_RunContest(wxCommandEvent& event);
  void OnC_ShowRanking(wxCommandEvent& event);
  void OnC_EditContest(wxCommandEvent& event);

  bool setLessonController(LessonController* c, bool deleteOld = true);
  inline LessonController* getLessonController() { return this->lcontrol; };

  inline wxMenu* GetFileMenu() { return FileMenu; };
  inline TtOutputControl* GetOutput() { return (TtOutputControl*)this->sw->GetWindow1(); };
  inline TtInputControl* GetInput() { return  (TtInputControl*)this->sw->GetWindow2(); };
		
 private:
  static Hauptfenster* localpointer;

  wxSplitterWindow* sw;
  wxMenuBar* MainMenu;
  wxMenu*     FileMenu;
  wxMenu*     ModesMenu;
  wxMenu*     ViewMenu;
  wxMenu*     OptionsMenu;
  wxMenu*     HelpMenu;

  LessonController* lcontrol;

  // Event Table 
  DECLARE_EVENT_TABLE()
};

enum {
  D_Beenden = 1,
  Hilfe_Info = 2,
  D_LektionLaden = 3,
  O_Einstellungen = 4,
  D_LektionBeenden = 5,
  D_LPause = 6,
  D_KBeginnen = 7,
  D_KLaden = 8,
  O_Schriftwaehlen = 10,
  O_SwitchBell = 11,
  C_RunContest,
  C_ShowRanking,
  C_EditContest
};

#endif
