/****************************************************************************
    Copyright (C) 1987-2007 by Jeffery P. Hansen

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Last edit by hansen on Tue Dec  2 10:28:02 2003
****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <assert.h>
#include "tkgate.h"

SHash *GateTypeHash = 0;
NHash *GateIdxHash = 0;

int INVERTER;
int Mark;
int SIZEHASH;
int REPCOUNTMARK;

extern int NumLispAllocs,NumLispFrees,MaxLispAlloced; /* Memory statistics */
extern struct keystate *KeyState;
extern int stepsize,baderp,batp,lastcheckpoint;
extern char *LispMessages[];

extern char *g2pscommand;

char NetListFile[STRMAX];

struct gateinfo *gateinfo_lookup(const char *name)
{
  return (struct gateinfo*) SHash_find(GateTypeHash,name);
}

int gateinfo_variantNum(GGateInfo *gi,const char *func)
{
  int vn = 0;
  char *p;
  int L = strlen(func);

  for (p = gi->vnames;p && *p;vn++,p = strchr(p+1,':')) {
    if (*p == ':') p++;
    if (strncmp(p,func,L) == 0 && (p[L] == ':' || !p[L]))
      break;
  }

  return vn;
}

/*
   Registers a gate type
*/
void RegisterGate(GGateInfo *gi)
{
  static int code_count = 1; 
  char buf[STRMAX],*T;

  if (gi->Code <= 0)
    gi->Code = code_count++;

  if (!gi->vnames) {
    fprintf(stderr,"No verilog name for block '%s'\n",gi->englishName);
    exit(1);
  }
  strcpy(buf,gi->vnames);

  for (T = strtok(buf,":");T;T = strtok(0,":")) {
    SHash_insert(GateTypeHash,T,gi);
  }

  NHash_insert(GateIdxHash,gi->Code,gi);
}

void specials_init()
{
  if (XGate.tcl) {
    Pixmap P = Pixmap_registerFromFile("misc","misc.b");
    Mark = Icon_register(P,6,28,9,9,4,4);
    SIZEHASH = Icon_register(P,16,27,10,10,4,4);
    INVERTER = Icon_register(P,0,28,5,5,2,2);
    REPCOUNTMARK = Icon_register(P,32,0,9,9,4,4);
  }
}

void MakeHashTables()
{
  GateTypeHash = new_SHash();
  GateIdxHash = new_SHash();

  specials_init();
}

GGateInfo *gtype_get(int T)
{
  return (GGateInfo*) NHash_find(GateIdxHash,T);
}

