-- Topal: GPG/GnuPG and Alpine/Pine integration
-- Copyright (C) 2001--2008  Phillip J. Brooke
--
-- This program is free software: you can redistribute it and/or modify
-- it under the terms of the GNU General Public License version 3 as
-- published by the Free Software Foundation.
--
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

package Externals.Mail is

   -- Figure out the MIME boundary by heuristic.
   function Find_Mime_Boundary (Infile : String) return UBS;

   -- Given an infile, a boundary, and a MIME file that we hope is in two
   -- parts, split it into the two parts
   procedure Split_Two_Parts (Infile   : in String;
                              Part_One : in String;
                              Part_Two : in String;
                              Boundary : in UBS);

   -- Extract a content-type from the header of a header-body mail into a
   -- file.
   procedure Extract_Content_Type_From_Header (Email_Filename  : in String;
                                               Target_Filename : in String;
                                               Ignore_Missing  : in Boolean := False);

   -- Ditto, for content-transfer-encoding.
   procedure Extract_Content_Transfer_Encoding_From_Header (Email_Filename  : in String;
                                                            Target_Filename : in String;
                                                            Ignore_Missing  : in Boolean := False);

   -- Get the header from a header-body mail into a file.
   procedure Extract_Header (Email_Filename  : in String;
                             Target_Filename : in String);

   -- Get the body from a header-body mail into a file.
   procedure Extract_Body (Email_Filename  : in String;
                           Target_Filename : in String);

   procedure Delete_Trailing_Blank_Lines (Infile  : in String;
                                          Outfile : in String);

   procedure Formail_Concat_Extract_InOut (Header : in String;
                                           Source : in String;
                                           Target : in String);

   procedure Formail_Drop_InOut (Header : in UBS_Array;
                                  Source : in String;
                                  Target : in String);

   -- Equivalent of `formail -s Action'.
   procedure Formail_Action_InOut (Source : in String;
                                   Target : in String;
                                   Action : in String);

   -- Construct a top-level 2 part MIME email.
   procedure Mimeconstruct2 (Part1_Filename  : in String;
                             Part2_Filename  : in String;
                             Output_Filename : in String;
                             Content_Type    : in String);

   -- Construct a subpart of a MIME email.  This is a drop-in
   --  replacement for an older subroutine.  The behaviour is weird:
   --  We ignore the Use_Header and Header arguments.  Content-Type is
   --  explicitly used.  Use_Encoding => False forces it to be omitted.
   procedure Mimeconstruct_Subpart (Infile       : in String;
                                    Outfile      : in String;
                                    Content_Type : in String;
                                    Dos2UnixU    : in Boolean;
                                    Use_Header   : in Boolean;
                                    Use_Encoding : in Boolean;
                                    Header       : in String := "";
                                    Encoding     : in String := "");

   -- Construct an entire multipart/mixed email.
   procedure Mimeconstruct_Mixed (Filenames : in UBS_Array;
                                  Outfile   : in String);

   -- View a MIME file.
   procedure View_MIME (F : String);

   -- Base 64 decode from infile to outfile.
   procedure Base64_Decode (Infile, Outfile : in String);

   -- Quoted-printable decode from infile to outfile.
   procedure QP_Decode (Infile, Outfile : in String);

end Externals.Mail;
