#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

GtkWidget*
create_filechooserdialog1 (void)
{
  GtkWidget *filechooserdialog1;
  GtkWidget *dialog_vbox1;
  GtkWidget *dialog_action_area1;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkFileFilter *filter;
  
  filechooserdialog1 = gtk_file_chooser_dialog_new (_("Choose the file to visualize"), NULL, GTK_FILE_CHOOSER_ACTION_OPEN, NULL);
  gtk_widget_set_size_request (filechooserdialog1, 640, 360);
  gtk_container_set_border_width (GTK_CONTAINER (filechooserdialog1), 5);
  gtk_window_set_position (GTK_WINDOW (filechooserdialog1), GTK_WIN_POS_CENTER);
  gtk_window_set_resizable (GTK_WINDOW (filechooserdialog1), FALSE);
  gtk_window_set_type_hint (GTK_WINDOW (filechooserdialog1), GDK_WINDOW_TYPE_HINT_DIALOG);
  
  /* Add filters */
  filter = gtk_file_filter_new();
  gtk_file_filter_set_name( filter, "All Office Files" );
  gtk_file_filter_add_pattern( filter, "*.doc" );
  gtk_file_filter_add_pattern( filter, "*.docx" );
  gtk_file_filter_add_pattern( filter, "*.xls" );
  gtk_file_filter_add_pattern( filter, "*.xlsx" );
  gtk_file_filter_add_pattern( filter, "*.ppt" );
  gtk_file_filter_add_pattern( filter, "*.pptx" );
  gtk_file_chooser_add_filter( GTK_FILE_CHOOSER(filechooserdialog1), filter );

  filter = gtk_file_filter_new();
  gtk_file_filter_set_name( filter, "Documents (*.doc, *.docx)" );
  gtk_file_filter_add_pattern( filter, "*.doc" );
  gtk_file_filter_add_pattern( filter, "*.docx" );
  gtk_file_chooser_add_filter( GTK_FILE_CHOOSER(filechooserdialog1), filter );

  filter = gtk_file_filter_new();
  gtk_file_filter_set_name( filter, "Spreadsheets (*.xls, *.xlsx)" );
  gtk_file_filter_add_pattern( filter, "*.xls" );
  gtk_file_filter_add_pattern( filter, "*.xlsx" );
  gtk_file_chooser_add_filter( GTK_FILE_CHOOSER(filechooserdialog1), filter );
  
  filter = gtk_file_filter_new();
  gtk_file_filter_set_name( filter, "Presentations (*.ppt, *.pptx)" );
  gtk_file_filter_add_pattern( filter, "*.ppt" );
  gtk_file_filter_add_pattern( filter, "*.pptx" );
  gtk_file_chooser_add_filter( GTK_FILE_CHOOSER(filechooserdialog1), filter );
  
  dialog_vbox1 = GTK_DIALOG (filechooserdialog1)->vbox;
  gtk_widget_show (dialog_vbox1);

  dialog_action_area1 = GTK_DIALOG (filechooserdialog1)->action_area;
  gtk_widget_show (dialog_action_area1);
  gtk_button_box_set_layout (GTK_BUTTON_BOX (dialog_action_area1), GTK_BUTTONBOX_END);

  button1 = gtk_button_new_from_stock ("gtk-cancel");
  gtk_widget_show (button1);
  gtk_dialog_add_action_widget (GTK_DIALOG (filechooserdialog1), button1, GTK_RESPONSE_CANCEL);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

  button2 = gtk_button_new_from_stock ("gtk-open");
  gtk_widget_show (button2);
  gtk_dialog_add_action_widget (GTK_DIALOG (filechooserdialog1), button2, GTK_RESPONSE_OK);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);

  g_signal_connect ((gpointer) filechooserdialog1, "destroy",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect ((gpointer) filechooserdialog1, "response",
                    G_CALLBACK (on_filechooserdialog1_response),
                    NULL);
  g_signal_connect ((gpointer) button1, "clicked",
                    G_CALLBACK (gtk_main_quit),
                    NULL);
  g_signal_connect ((gpointer) button2, "clicked",
                    G_CALLBACK (gtk_main_quit),
                    NULL);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog1, filechooserdialog1, "filechooserdialog1");
  GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog1, dialog_vbox1, "dialog_vbox1");
  GLADE_HOOKUP_OBJECT_NO_REF (filechooserdialog1, dialog_action_area1, "dialog_action_area1");
  GLADE_HOOKUP_OBJECT (filechooserdialog1, button1, "button1");
  GLADE_HOOKUP_OBJECT (filechooserdialog1, button2, "button2");

  gtk_widget_grab_default (button2);
  return filechooserdialog1;
}

GtkWidget*
create_waitdialog (void)
{
  GtkWidget *waitdialog;
  GtkWidget *label1;

  waitdialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (waitdialog), _("Processing file"));
  gtk_window_set_position (GTK_WINDOW (waitdialog), GTK_WIN_POS_CENTER_ALWAYS);
  gtk_window_set_modal (GTK_WINDOW (waitdialog), TRUE);
  gtk_window_set_default_size (GTK_WINDOW (waitdialog), 88, 53);

  label1 = gtk_label_new (_("Processing request. Please wait..."));
  gtk_widget_show (label1);
  gtk_container_add (GTK_CONTAINER (waitdialog), label1);
  gtk_label_set_width_chars (GTK_LABEL (label1), 0);

  /* Store pointers to all widgets, for use by lookup_widget(). */
  GLADE_HOOKUP_OBJECT_NO_REF (waitdialog, waitdialog, "waitdialog");
  GLADE_HOOKUP_OBJECT (waitdialog, label1, "label1");

  return waitdialog;
}
