# -*- coding: utf-8 -*-
# Author: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Script that shows the qt gui."""

# pylint: disable=F0401, E1101
from twisted.internet import reactor
from twisted.internet.defer import inlineCallbacks
from ubuntu_sso.main.windows import UbuntuSSOClient


def found(*args):
    """The credentials were found."""
    print "creds found", args
    reactor.stop()


def errback(*args):
    """Unsuccessful login."""
    print "EB:", args


@inlineCallbacks
def main():
    """Perform a client request to be logged in."""
    client = UbuntuSSOClient()
    client = yield client.connect()
    yield client.cred_management.register_to_signals()
    client.cred_management.on_credentials_found_cb = found
    client.cred_management.on_credentials_error_cb = errback
    yield client.cred_management.login_email_password('SUPER', dict(
          app_name='SUPER',
          email='xyz@canonical.com',
          password='ABC',
    ))
    print "called ok"


if __name__ == '__main__':
    main()
    reactor.run()
