# -*- coding: utf-8 -*-
#
# Authors: Natalia B. Bidart <natalia.bidart@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.

"""Platform independent tests for the XDG constants."""

import os

from twisted.trial.unittest import TestCase

from ubuntu_sso import xdg_base_directory


class TestBaseDirectory(TestCase):
    """Tests for the BaseDirectory module."""

    def test_xdg_cache_home_is_bytes(self):
        """The returned path is bytes."""
        actual = xdg_base_directory.xdg_cache_home
        self.assertIsInstance(actual, str)

    def test_xdg_data_home_is_bytes(self):
        """The returned path is bytes."""
        actual = xdg_base_directory.xdg_data_home
        self.assertIsInstance(actual, str)

    def test_load_config_paths_filter(self):
        """Since those folders don't exist, this should be empty."""
        self.assertEqual(list(xdg_base_directory.load_config_paths("x")), [])

    def test_save_config_path(self):
        """The path should end with xdg_config/x (respecting the separator)."""
        self.patch(os, "makedirs", lambda *args: None)
        result = xdg_base_directory.save_config_path("x")
        self.assertEqual(result.split(os.sep)[-2:], ['xdg_config', 'x'])
