/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_PROJECT_IMPL_H_
#define _GB2_PROJECT_IMPL_H_

#include <core_api/ProjectModel.h>

#include <QtCore/QMap>

namespace GB2 {

class FailedToLoadFormat;
class ServiceLock;
class SaveProjectTask;
class LoadProjectTask;

class ProjectImpl : public Project {
    Q_OBJECT
	friend class SaveProjectTask;
	friend class LoadProjectTask;
public:
    ProjectImpl(const QString& _name, const QString& _file); 
	~ProjectImpl();
    
	virtual const QString& getProjectName() const {return name;}

	virtual void setProjectName(const QString& name);

	virtual const QString& getProjectURL() const {return url;}

    virtual void setProjectURL(const QString&);

	virtual const QList<Document*>& getDocuments() const {return docs;}

	virtual void addDocument(Document* d);

	virtual void removeDocument(Document* d, bool autodelete = true);

	virtual Document* findDocumentByURL(const QString& url) const;
	
	virtual void makeClean();

    virtual const QList<GObjectViewState*>& getGObjectViewStates() const {return stub;}

    virtual void addGObjectViewState(GObjectViewState* s) {assert(0);}

    virtual void removeGObjectViewState(GObjectViewState* s) {assert(0);}


protected:
	//void updateServiceLock();

private:
    QString name;
    QString url;
	QList<Document*> docs;
    QList<GObjectViewState*> stub;
};




}//namespace

#endif
