##################################################################
# Unipro UGENE - Integrated Bioinformatics Suite
# Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
# All Rights Reserved
# 
#
#     This source code is distributed under the terms of the
#     GNU General Public License. See the files COPYING and LICENSE
#     for details.
##################################################################

include (core.pri)

# Input
HEADERS += src/core_api/AppContext.h \
           src/core_api/AppGlobals.h \
           src/core_api/AppResources.h \
           src/core_api/AppSettings.h \
           src/core_api/AppSettingsGUI.h \
           src/core_api/core_api.h \
           src/core_api/Counter.h \
           src/core_api/CudaGpuRegistry.h \
           src/core_api/AtiStreamGpuRegistry.h \
           src/core_api/DBXRefRegistry.h \
           src/core_api/DNAAlphabet.h \
           src/core_api/DNATranslation.h \
           src/core_api/DocumentFormatConfigurators.h \
           src/core_api/DocumentFormats.h \
           src/core_api/DocumentModel.h \
           src/core_api/GHints.h \
           src/core_api/GObject.h \
           src/core_api/GObjectReference.h \
           src/core_api/IOAdapter.h \
           src/core_api/Log.h \
           src/core_api/LRegion.h \
           src/core_api/MainWindow.h \
           src/core_api/NetworkConfiguration.h \
           src/core_api/ObjectViewModel.h \
           src/core_api/PluginModel.h \
           src/core_api/PluginViewer.h \
           src/core_api/ProjectModel.h \
           src/core_api/ProjectView.h \
           src/core_api/ResourceTracker.h \
           src/core_api/ScriptRegistry.h \
           src/core_api/SecStructPredictAlgRegistry.h \
           src/core_api/SelectionModel.h \
           src/core_api/ServiceModel.h \
           src/core_api/ServiceTypes.h \
           src/core_api/Settings.h \
           src/core_api/SmithWatermanTaskFactoryRegistry.h \
           src/core_api/StateLockableDataModel.h \
           src/core_api/SubstMatrixRegistry.h \
           src/core_api/SWResultFilterRegistry.h \
           src/core_api/Task.h \
           src/core_api/Timer.h \
           src/core_api/UserApplicationsSettings.h \
           src/core_api/Vector3D.h \
           src/core_services/AppContextImpl.h \
           src/core_services/AppSettingsImpl.h \
           src/core_services/DocumentFormatRegistryImpl.h \
           src/core_services/IOAdapterRegistryImpl.h \
           src/core_services/LogSettings.h \
           src/core_services/SettingsImpl.h \
           src/datatype/AnnotationData.h \
           src/datatype/BioStruct3D.h \
           src/datatype/DNAChromatogram.h \
           src/datatype/DNAInfo.h \
           src/datatype/DNASequence.h \
           src/datatype/MAlignment.h \
           src/datatype/MAlignmentInfo.h \
           src/datatype/PhyTree.h \
           src/datatype/UIndex.h \
           src/document_format/ABIFormat.h \
           src/document_format/ASNFormat.h \
           src/document_format/ClustalWAlnFormat.h \
           src/document_format/DNAAlphabetRegistryImpl.h \
           src/document_format/DNAAlphabetUtils.h \
           src/document_format/DNATranslationImpl.h \
           src/document_format/DocumentFormatUtils.h \
           src/document_format/EMBLGenbankAbstractDocument.h \
           src/document_format/EMBLPlainTextFormat.h \
           src/document_format/FastaFormat.h \
           src/document_format/FastqFormat.h \
           src/document_format/GenbankFeatures.h \
           src/document_format/GenbankLocationParser.h \
           src/document_format/GenbankPlainTextFormat.h \
           src/document_format/IndexFormat.h \
           src/document_format/IOLibUtils.h \
           src/document_format/NewickFormat.h \
           src/document_format/PDBFormat.h \
           src/document_format/PlainTextFormat.h \
           src/document_format/RawDNASequenceFormat.h \
           src/document_format/SCFFormat.h \
           src/document_format/StdResidueDictionary.h \
           src/document_format/StockholmFormat.h \
           src/document_format/SubstMatrixFile.h \
           src/gobjects/AnnotationSettings.h \
           src/gobjects/AnnotationTableObject.h \
           src/gobjects/BioStruct3DObject.h \
           src/gobjects/DNAChromatogramObject.h \
           src/gobjects/DNASequenceObject.h \
           src/gobjects/GObjectRelationRoles.h \
           src/gobjects/GObjectTypes.h \
           src/gobjects/GObjectUtils.h \
           src/gobjects/MAlignmentObject.h \
           src/gobjects/PhyTreeObject.h \
           src/gobjects/TextObject.h \
           src/gobjects/UIndexObject.h \
           src/gobjects/UnloadedObject.h \
           src/ioadapter/HttpFileAdapter.h \
           src/ioadapter/LocalFileAdapter.h \
           src/ioadapter/MemBufAdapter.h \
           src/ioadapter/ZlibAdapter.h \
           src/molecular_geometry/GeomUtils.h \
           src/molecular_geometry/MolecularSurface.h \
           src/molecular_geometry/MolecularSurfaceFactoryRegistry.h \
           src/molecular_geometry/VanDerWaalsSurface.h \
           src/plugin_support/PluginSupportImpl.h \
           src/plugin_support/ServiceRegistryImpl.h \
           src/script/GScriptModuleRegistry.h \
           src/script/GScriptRunner.h \
           src/selection/AnnotationSelection.h \
           src/selection/DNASequenceSelection.h \
           src/selection/DocumentSelection.h \
           src/selection/GObjectSelection.h \
           src/selection/LRegionsSelection.h \
           src/selection/SelectionTypes.h \
           src/selection/SelectionUtils.h \
           src/selection/TextSelection.h \
           src/task_scheduler/TaskSchedulerImpl.h \
           src/test_framework/GTest.h \
           src/test_framework/GTestFrameworkComponents.h \
           src/test_framework/TestRunnerTask.h \
           src/util_algorithm/DynTable.h \
           src/util_algorithm/FindAlgorithm.h \
           src/util_algorithm/FindAlgorithmTask.h \
           src/util_algorithm/GAutoDeleteList.h \
           src/util_algorithm/MSAUtils.h \
           src/util_algorithm/ORFAlgorithmTask.h \
           src/util_algorithm/ORFFinder.h \
           src/util_algorithm/RingBuffer.h \
           src/util_algorithm/RollingArray.h \
           src/util_algorithm/RollingMatrix.h \
           src/util_algorithm/SynchHttp.h \
           src/util_find_dialog/FindDialog.h \
           src/util_gui/AddExistingDocumentDialogImpl.h \
           src/util_gui/AddNewDocumentDialogImpl.h \
           src/util_gui/AnnotationSettingsDialogController.h \
           src/util_gui/BaseDocumentFormatConfigurators.h \
           src/util_gui/CreateAnnotationDialog.h \
           src/util_gui/CreateAnnotationWidgetController.h \
           src/util_gui/CreateObjectRelationDialogController.h \
		   src/util_gui/CreateDocumentFromTextDialogController.h \
           src/util_gui/DialogUtils.h \
           src/util_gui/DocumentFormatComboboxController.h \
           src/util_gui/EditQualifierDialog.h \
           src/util_gui/GObjectComboBoxController.h \
           src/util_gui/GraphUtils.h \
           src/util_gui/GScrollBar.h \
           src/util_gui/GUIUtils.h \
           src/util_gui/ObjectViewTreeController.h \
           src/util_gui/PositionSelector.h \
           src/util_gui/ProjectDocumentComboBoxController.h \
           src/util_gui/ProjectTreeController.h \
           src/util_gui/ProjectTreeItemSelectorDialog.h \
           src/util_gui/RangeSelector.h \
           src/util_gui/ScaleBar.h \
           src/util_gui/TextEditorDialog.h \
		   src/util_gui/CopyDocumentDialogController.h \
		   src/util_gui/SeqPasterWidgetController.h \
		   src/util_gui/AddPartToSequenceDialogController.h \
		   src/util_gui/RemovePartFromSequenceDialogController.h \
           src/util_index_support/UIndexSupport.h \
           src/util_ov_annotated_dna/ADVAlignmentSupport.h \
           src/util_ov_annotated_dna/ADVAnnotationCreation.h \
           src/util_ov_annotated_dna/ADVClipboard.h \
           src/util_ov_annotated_dna/ADVConstants.h \
           src/util_ov_annotated_dna/ADVGraphModel.h \
           src/util_ov_annotated_dna/ADVSequenceObjectContext.h \
           src/util_ov_annotated_dna/ADVSequenceWidget.h \
           src/util_ov_annotated_dna/ADVSingleSequenceWidget.h \
           src/util_ov_annotated_dna/ADVSplitWidget.h \
           src/util_ov_annotated_dna/ADVSyncViewManager.h \
           src/util_ov_annotated_dna/ADVUtils.h \
           src/util_ov_annotated_dna/AnnotatedDNAView.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewFactory.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewState.h \
           src/util_ov_annotated_dna/AnnotatedDNAViewTasks.h \
           src/util_ov_annotated_dna/AnnotationsTreeView.h \
           src/util_ov_annotated_dna/CreateRulerDialogController.h \
           src/util_ov_annotated_dna/DetView.h \
           src/util_ov_annotated_dna/EditAnnotationDialogController.h \
           src/util_ov_annotated_dna/GSequenceGraphView.h \
           src/util_ov_annotated_dna/GSequenceLineView.h \
           src/util_ov_annotated_dna/GSequenceLineViewAnnotated.h \
           src/util_ov_annotated_dna/PanView.h \
           src/util_ov_annotated_dna/PanViewRows.h \
           src/util_ov_annotated_dna/WindowStepSelectorWidget.h \
           src/util_ov_indexview/UIndexExportToNewFileDialogImpl.h \
           src/util_ov_indexview/UIndexViewer.h \
           src/util_ov_indexview/UIndexViewerFactory.h \
           src/util_ov_indexview/UIndexViewerTasks.h \
           src/util_ov_indexview/UIndexViewHeaderItemWidgetImpl.h \
           src/util_ov_indexview/UIndexViewWidgetImpl.h \
           src/util_ov_indexview/UIndexViewWidgetKey.h \
           src/util_ov_msaedit/MSAColorScheme.h \
           src/util_ov_msaedit/MSAEditor.h \
           src/util_ov_msaedit/MSAEditorBaseOffsetsCache.h \
           src/util_ov_msaedit/MSAEditorConsensusArea.h \
           src/util_ov_msaedit/MSAEditorConsensusCache.h \
           src/util_ov_msaedit/MSAEditorFactory.h \
           src/util_ov_msaedit/MSAEditorNameList.h \
           src/util_ov_msaedit/MSAEditorOffsetsView.h \
           src/util_ov_msaedit/MSAEditorSequenceArea.h \
           src/util_ov_msaedit/MSAEditorState.h \
           src/util_ov_msaedit/MSAEditorStatusBar.h \
           src/util_ov_msaedit/MSAEditorTasks.h \
           src/util_ov_msaedit/MSAEditorUndoFramework.h \
           src/util_ov_textview/SimpleTextObjectView.h \
           src/util_ov_textview/SimpleTextObjectViewTasks.h \
           src/util_sec_struct_predict/SecStructDialog.h \
           src/util_sec_struct_predict/SecStructPredictTask.h \
           src/util_sec_struct_predict/SecStructPredictTests.h \
           src/util_sec_struct_predict/SecStructPredictUtils.h \
           src/util_smith_waterman/SmithWatermanDialog.h \
           src/util_smith_waterman/SmithWatermanReportCallback.h \
           src/util_smith_waterman/SmithWatermanResult.h \
           src/util_smith_waterman/SmithWatermanResultFilters.h \
           src/util_smith_waterman/SmithWatermanSettings.h \
           src/util_smith_waterman/SmithWatermanTaskFactory.h \
           src/util_smith_waterman/SmithWatermanTests.h \
           src/util_smith_waterman/SmithWatermanUtil.h \
           src/util_smith_waterman/SubstMatrix.h \
           src/util_smith_waterman/SubstMatrixDialog.h \
           src/util_smith_waterman/SubstMatrixFactory.h \
           src/util_tasks/AddDocumentTask.h \
           src/util_tasks/AddPartToSequenceTask.h \
           src/util_tasks/CopyDataTask.h \
           src/util_tasks/CreateAnnotationTask.h \
           src/util_tasks/CreateFileIndexTask.h \
           src/util_tasks/ExportToNewFileFromIndexTask.h \
           src/util_tasks/FailTask.h \
           src/util_tasks/GetDocumentFromIndexTask.h \
           src/util_tasks/LoadDocumentTask.h \
           src/util_tasks/LoadRemoteDocumentTask.h \
           src/util_tasks/MultiTask.h \
           src/util_tasks/ObjectViewTasks.h \
           src/util_tasks/ReloadScriptTask.h \
           src/util_tasks/RemoveDocumentTask.h \
           src/util_tasks/RemovePartFromSequenceTask.h \
           src/util_tasks/SaveDocumentStreamingTask.h \
           src/util_tasks/SaveDocumentTask.h \
           src/util_tasks/ExtractAnnotatedRegionTask.h \
           src/util_tasks/SequenceWalkerTask.h \
           src/util_tasks/TaskSignalMapper.h \
           src/util_tasks/TaskStarter.h \
           src/util_text/FormatUtils.h \
           src/util_text/TextUtils.h \
           src/workflow/Attribute.h \
           src/workflow/ConfigurationEditor.h \
           src/workflow/Datatype.h \
           src/workflow/DatatypeConversion.h \
           src/workflow/Descriptor.h \
           src/workflow/IntegralBus.h \
           src/workflow/IntegralBusModel.h \
           src/workflow/IntegralBusType.h \
           src/workflow/Schema.h \
           src/workflow/TypeSet.h \
           src/workflow/WorkflowEnv.h \
           src/workflow/WorkflowManager.h \
           src/workflow/WorkflowModel.h \
           src/workflow/WorkflowRegistry.h \
           src/workflow/WorkflowTransport.h \
           src/workflow_library/BioActorLibrary.h \
           src/workflow_library/BioDatatypes.h \
           src/workflow_library/LocalDomain.h \
           src/workflow_support/CoreDataTypes.h \
           src/workflow_support/DelegateEditors.h \
           src/workflow_support/QVariantUtils.h \
           src/workflow_support/SchemaSerializer.h \
           src/workflow_support/TypeMapEditor.h \
           src/workflow_support/WorkflowEnvImpl.h \
           src/workflow_support/WorkflowIOTasks.h \
           src/workflow_support/WorkflowRunTask.h \
           src/workflow_support/WorkflowSettings.h \
           src/workflow_support/WorkflowTests.h \
           src/workflow_support/WorkflowUtils.h \
           src/test_framework/find_algo/FindAlgorithmTestFormat.h \
           src/test_framework/xmltest/AddPartToSequenceTests.h \
           src/test_framework/xmltest/AnnotationTableObjectTest.h \
           src/test_framework/xmltest/AsnParserTests.h \
           src/test_framework/xmltest/BioStruct3DObjectTests.h \
           src/test_framework/xmltest/DNASequenceObjectTests.h \
           src/test_framework/xmltest/DNATranslationImplTests.h \
           src/test_framework/xmltest/DocumentModelTests.h \
           src/test_framework/xmltest/FilesIndexingTests.h \
           src/test_framework/xmltest/RemovePartFromSequenceTests.h \
           src/test_framework/xmltest/SequenceWalkerTests.h \
           src/test_framework/xmltest/TaskTests.h \
           src/test_framework/xmltest/XMLTestFormat.h \
           src/test_framework/xmltest/XMLTestUtils.h
FORMS += src/util_find_dialog/ui/FindDialogUI.ui \
         src/util_gui/ui/AddExistingDocumentDialog.ui \
         src/util_gui/ui/AddNewDocumentDialog.ui \
         src/util_gui/ui/AnnotationSettingsDialog.ui \
         src/util_gui/ui/CreateAnnotationWidget.ui \
         src/util_gui/ui/CreateFileIndexDialog.ui \
         src/util_gui/ui/CreateNewObjectDialog.ui \
         src/util_gui/ui/CreateObjectRelationDialog.ui \
         src/util_gui/ui/EditQualifierDialog.ui \
         src/util_gui/ui/FormatSettingsDialog.ui \
         src/util_gui/ui/MultipartDocFormatConfiguratorWidget.ui \
         src/util_gui/ui/ProjectTreeItemSelectorDialogBase.ui \
         src/util_gui/ui/TextEditorDialog.ui \
         src/util_gui/ui/UIndexExportToNewFileDialog.ui \
         src/util_gui/ui/UIndexViewHeaderItemWidget.ui \
         src/util_gui/ui/UIndexViewWidget.ui \
		 src/util_gui/ui/CopyDocumentDialog.ui \
		 src/util_gui/ui/CreateDocumentFromTextDialog.ui \
		 src/util_gui/ui/SeqPasterWidget.ui \
		 src/util_gui/ui/AddPartToSequenceDialog.ui \
		 src/util_gui/ui/RemovePartFromSequenceDialog.ui \
		 src/util_gui/ui/SelectFormatToSaveDialog.ui \
         src/util_ov_annotated_dna/ui/CreateRulerDialog.ui \
         src/util_ov_annotated_dna/ui/EditAnnotationDialog.ui \
         src/util_sec_struct_predict/ui/SecStructDialog.ui \
         src/util_smith_waterman/ui/SmithWatermanDialogBase.ui \
         src/util_smith_waterman/ui/SubstMatrixDialogBase.ui 
SOURCES += src/core_api/AppContext.cpp \
           src/core_api/AppResources.cpp \
           src/core_api/Counter.cpp \
           src/core_api/CudaGpuRegistry.cpp \
           src/core_api/AtiStreamGpuRegistry.cpp \
           src/core_api/DBXRefRegistry.cpp \
           src/core_api/DNAAlphabet.cpp \
           src/core_api/DNATranslation.cpp \
           src/core_api/DocumentFormatConfigurators.cpp \
           src/core_api/DocumentFormats.cpp \
           src/core_api/DocumentModel.cpp \
           src/core_api/GHints.cpp \
           src/core_api/GObject.cpp \
           src/core_api/IOAdapter.cpp \
           src/core_api/Log.cpp \
           src/core_api/LRegion.cpp \
           src/core_api/MainWindow.cpp \
           src/core_api/NetworkConfiguration.cpp \
           src/core_api/ObjectViewModel.cpp \
           src/core_api/ProjectModel.cpp \
           src/core_api/ResourceTracker.cpp \
           src/core_api/ScriptRegistry.cpp \
           src/core_api/SecStructPredictAlgRegistry.cpp \
           src/core_api/SelectionModel.cpp \
           src/core_api/ServiceModel.cpp \
           src/core_api/SmithWatermanTaskFactoryRegistry.cpp \
           src/core_api/StateLockableDataModel.cpp \
           src/core_api/SubstMatrixRegistry.cpp \
           src/core_api/SWResultFilterRegistry.cpp \
           src/core_api/Task.cpp \
           src/core_api/Timer.cpp \
           src/core_api/UserApplicationsSettings.cpp \
           src/core_api/Vector3D.cpp \
           src/core_services/AppContextImpl.cpp \
           src/core_services/AppSettingsImpl.cpp \
           src/core_services/DocumentFormatRegistryImpl.cpp \
           src/core_services/IOAdapterRegistryImpl.cpp \
           src/core_services/LogSettings.cpp \
           src/core_services/SettingsImpl.cpp \
           src/datatype/BioStruct3D.cpp \
           src/datatype/DNAInfo.cpp \
           src/datatype/DNASequence.cpp \
           src/datatype/MAlignment.cpp \
           src/datatype/MAlignmentInfo.cpp \
           src/datatype/PhyTree.cpp \
           src/datatype/UIndex.cpp \
           src/document_format/ABIFormat.cpp \
           src/document_format/ASNFormat.cpp \
           src/document_format/BaseAlphabets.cpp \
           src/document_format/BaseTranslations.cpp \
           src/document_format/ClustalWAlnFormat.cpp \
           src/document_format/DNAAlphabetRegistryImpl.cpp \
           src/document_format/DNATranslationImpl.cpp \
           src/document_format/DocumentFormatUtils.cpp \
           src/document_format/EMBLGenbankAbstractDocument.cpp \
           src/document_format/EMBLPlainTextFormat.cpp \
           src/document_format/FastaFormat.cpp \
           src/document_format/FastqFormat.cpp \
           src/document_format/GenbankFeatures.cpp \
           src/document_format/GenbankLocationParser.cpp \
           src/document_format/GenbankPlainTextFormat.cpp \
           src/document_format/IndexFormat.cpp \
           src/document_format/NewickFormat.cpp \
           src/document_format/PDBFormat.cpp \
           src/document_format/PlainTextFormat.cpp \
           src/document_format/RawDNASequenceFormat.cpp \
           src/document_format/SCFFormat.cpp \
           src/document_format/StdResidueDictionary.cpp \
           src/document_format/StockholmFormat.cpp \
           src/document_format/SubstMatrixFile.cpp \
           src/gobjects/AnnotationSettings.cpp \
           src/gobjects/AnnotationTableObject.cpp \
           src/gobjects/BioStruct3DObject.cpp \
           src/gobjects/DNAChromatogramObject.cpp \
           src/gobjects/DNASequenceObject.cpp \
           src/gobjects/GObjectRelationRoles.cpp \
           src/gobjects/GObjectTypes.cpp \
           src/gobjects/GObjectUtils.cpp \
           src/gobjects/MAlignmentObject.cpp \
           src/gobjects/PhyTreeObject.cpp \
           src/gobjects/TextObject.cpp \
           src/gobjects/UIndexObject.cpp \
           src/gobjects/UnloadedObject.cpp \
           src/ioadapter/HttpFileAdapter.cpp \
           src/ioadapter/LocalFileAdapter.cpp \
           src/ioadapter/MemBufAdapter.cpp \
           src/ioadapter/ZlibAdapter.cpp \
           src/molecular_geometry/GeomUtils.cpp \
           src/molecular_geometry/MolecularSurface.cpp \
           src/molecular_geometry/MolecularSurfaceFactoryRegistry.cpp \
           src/molecular_geometry/VanDerWaalsSurface.cpp \
           src/plugin_support/PluginSupportImpl.cpp \
           src/plugin_support/ServiceRegistryImpl.cpp \
           src/script/GScriptModuleRegistry.cpp \
           src/script/GScriptRunner.cpp \
           src/selection/AnnotationSelection.cpp \
           src/selection/DocumentSelection.cpp \
           src/selection/GObjectSelection.cpp \
           src/selection/LRegionsSelection.cpp \
           src/selection/SelectionTypes.cpp \
           src/selection/SelectionUtils.cpp \
           src/task_scheduler/TaskSchedulerImpl.cpp \
           src/test_framework/GTest.cpp \
           src/test_framework/GTestFrameworkComponents.cpp \
           src/test_framework/TestRunnerTask.cpp \
           src/util_algorithm/FindAlgorithm.cpp \
           src/util_algorithm/FindAlgorithmTask.cpp \
           src/util_algorithm/MSAUtils.cpp \
           src/util_algorithm/ORFAlgorithmTask.cpp \
           src/util_algorithm/ORFFinder.cpp \
           src/util_algorithm/SynchHttp.cpp \
           src/util_find_dialog/FindDialog.cpp \
           src/util_gui/AddExistingDocumentDialogImpl.cpp \
           src/util_gui/AddNewDocumentDialogImpl.cpp \
           src/util_gui/AnnotationSettingsDialogController.cpp \
           src/util_gui/BaseDocumentFormatConfigurators.cpp \
           src/util_gui/CreateAnnotationDialog.cpp \
           src/util_gui/CreateAnnotationWidgetController.cpp \
           src/util_gui/CreateObjectRelationDialogController.cpp \
		   src/util_gui/CreateDocumentFromTextDialogController.cpp \
           src/util_gui/DialogUtils.cpp \
           src/util_gui/DocumentFormatComboboxController.cpp \
           src/util_gui/EditQualifierDialog.cpp \
           src/util_gui/GObjectComboBoxController.cpp \
           src/util_gui/GraphUtils.cpp \
           src/util_gui/GUIUtils.cpp \
           src/util_gui/ObjectViewTreeController.cpp \
           src/util_gui/PositionSelector.cpp \
           src/util_gui/ProjectDocumentComboBoxController.cpp \
           src/util_gui/ProjectTreeController.cpp \
           src/util_gui/ProjectTreeItemSelectorDialog.cpp \
           src/util_gui/RangeSelector.cpp \
           src/util_gui/ScaleBar.cpp \
           src/util_gui/TextEditorDialog.cpp \
		   src/util_gui/CopyDocumentDialogController.cpp \
		   src/util_gui/SeqPasterWidgetController.cpp \
		   src/util_gui/AddPartToSequenceDialogController.cpp \
		   src/util_gui/RemovePartFromSequenceDialogController.cpp \
           src/util_index_support/UIndexSupport.cpp \
           src/util_ov_annotated_dna/ADVAlignmentSupport.cpp \
           src/util_ov_annotated_dna/ADVAnnotationCreation.cpp \
           src/util_ov_annotated_dna/ADVClipboard.cpp \
           src/util_ov_annotated_dna/ADVGraphModel.cpp \
           src/util_ov_annotated_dna/ADVSequenceObjectContext.cpp \
           src/util_ov_annotated_dna/ADVSequenceWidget.cpp \
           src/util_ov_annotated_dna/ADVSingleSequenceWidget.cpp \
           src/util_ov_annotated_dna/ADVSplitWidget.cpp \
           src/util_ov_annotated_dna/ADVSyncViewManager.cpp \
           src/util_ov_annotated_dna/ADVUtils.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAView.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewFactory.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewState.cpp \
           src/util_ov_annotated_dna/AnnotatedDNAViewTasks.cpp \
           src/util_ov_annotated_dna/AnnotationsTreeView.cpp \
           src/util_ov_annotated_dna/CreateRulerDialogController.cpp \
           src/util_ov_annotated_dna/DetView.cpp \
           src/util_ov_annotated_dna/EditAnnotationDialogController.cpp \
           src/util_ov_annotated_dna/GSequenceGraphView.cpp \
           src/util_ov_annotated_dna/GSequenceLineView.cpp \
           src/util_ov_annotated_dna/GSequenceLineViewAnnotated.cpp \
           src/util_ov_annotated_dna/PanView.cpp \
           src/util_ov_annotated_dna/PanViewRows.cpp \
           src/util_ov_annotated_dna/WindowStepSelectorWidget.cpp \
           src/util_ov_indexview/UIndexExportToNewFileDialogImpl.cpp \
           src/util_ov_indexview/UIndexViewer.cpp \
           src/util_ov_indexview/UIndexViewerFactory.cpp \
           src/util_ov_indexview/UIndexViewerTasks.cpp \
           src/util_ov_indexview/UIndexViewHeaderItemWidgetImpl.cpp \
           src/util_ov_indexview/UIndexViewWidgetImpl.cpp \
           src/util_ov_indexview/UIndexViewWidgetKey.cpp \
           src/util_ov_msaedit/MSAColorScheme.cpp \
           src/util_ov_msaedit/MSAEditor.cpp \
           src/util_ov_msaedit/MSAEditorBaseOffsetsCache.cpp \
           src/util_ov_msaedit/MSAEditorConsensusArea.cpp \
           src/util_ov_msaedit/MSAEditorConsensusCache.cpp \
           src/util_ov_msaedit/MSAEditorFactory.cpp \
           src/util_ov_msaedit/MSAEditorNameList.cpp \
           src/util_ov_msaedit/MSAEditorOffsetsView.cpp \
           src/util_ov_msaedit/MSAEditorSequenceArea.cpp \
           src/util_ov_msaedit/MSAEditorState.cpp \
           src/util_ov_msaedit/MSAEditorStatusBar.cpp \
           src/util_ov_msaedit/MSAEditorTasks.cpp \
           src/util_ov_msaedit/MSAEditorUndoFramework.cpp \
           src/util_ov_textview/SimpleTextObjectView.cpp \
           src/util_ov_textview/SimpleTextObjectViewTasks.cpp \
           src/util_sec_struct_predict/SecStructDialog.cpp \
           src/util_sec_struct_predict/SecStructPredictTask.cpp \
           src/util_sec_struct_predict/SecStructPredictTests.cpp \
           src/util_sec_struct_predict/SecStructPredictUtils.cpp \
           src/util_smith_waterman/SmithWatermanDialog.cpp \
           src/util_smith_waterman/SmithWatermanReportCallback.cpp \
           src/util_smith_waterman/SmithWatermanResult.cpp \
           src/util_smith_waterman/SmithWatermanResultFilters.cpp \
           src/util_smith_waterman/SmithWatermanTests.cpp \
           src/util_smith_waterman/SmithWatermanUtil.cpp \
           src/util_smith_waterman/SubstMatrix.cpp \
           src/util_smith_waterman/SubstMatrixDialog.cpp \
           src/util_smith_waterman/SubstMatrixFactory.cpp \
           src/util_tasks/AddDocumentTask.cpp \
           src/util_tasks/AddPartToSequenceTask.cpp \
           src/util_tasks/CopyDataTask.cpp \
           src/util_tasks/CreateAnnotationTask.cpp \
           src/util_tasks/CreateFileIndexTask.cpp \
           src/util_tasks/ExportToNewFileFromIndexTask.cpp \
           src/util_tasks/GetDocumentFromIndexTask.cpp \
           src/util_tasks/LoadDocumentTask.cpp \
           src/util_tasks/LoadRemoteDocumentTask.cpp \
           src/util_tasks/MultiTask.cpp \
           src/util_tasks/ObjectViewTasks.cpp \
           src/util_tasks/ReloadScriptTask.cpp \
           src/util_tasks/RemoveDocumentTask.cpp \
           src/util_tasks/RemovePartFromSequenceTask.cpp \
           src/util_tasks/SaveDocumentStreamingTask.cpp \
           src/util_tasks/SaveDocumentTask.cpp \
           src/util_tasks/ExtractAnnotatedRegionTask.cpp \
           src/util_tasks/SequenceWalkerTask.cpp \
           src/util_tasks/TaskSignalMapper.cpp \
           src/util_tasks/TaskStarter.cpp \
           src/util_text/FormatUtils.cpp \
           src/util_text/TextUtils.cpp \
           src/workflow/Attribute.cpp \
           src/workflow/IntegralBus.cpp \
           src/workflow/IntegralBusModel.cpp \
           src/workflow/IntegralBusType.cpp \
           src/workflow/Schema.cpp \
           src/workflow/WorkflowEnv.cpp \
           src/workflow/WorkflowModel.cpp \
           src/workflow/WorkflowRegistry.cpp \
           src/workflow/WorkflowTransport.cpp \
           src/workflow_library/BioActorLibrary.cpp \
           src/workflow_library/BioDataTypes.cpp \
           src/workflow_library/LocalDomain.cpp \
           src/workflow_support/CoreDataTypes.cpp \
           src/workflow_support/DelegateEditors.cpp \
           src/workflow_support/SchemaSerializer.cpp \
           src/workflow_support/TypeMapEditor.cpp \
           src/workflow_support/WorkflowEnvImpl.cpp \
           src/workflow_support/WorkflowIOTasks.cpp \
           src/workflow_support/WorkflowRunTask.cpp \
           src/workflow_support/WorkflowSettings.cpp \
           src/workflow_support/WorkflowTests.cpp \
           src/workflow_support/WorkflowUtils.cpp \
           src/test_framework/find_algo/FindAlgorithmTestFormat.cpp \
           src/test_framework/xmltest/AddPartToSequenceTests.cpp \
           src/test_framework/xmltest/AnnotationTableObjectTest.cpp \
           src/test_framework/xmltest/AsnParserTests.cpp \
           src/test_framework/xmltest/BioStruct3DObjectTests.cpp \
           src/test_framework/xmltest/DNASequenceObjectTests.cpp \
           src/test_framework/xmltest/DNATranslationImplTests.cpp \
           src/test_framework/xmltest/DocumentModelTests.cpp \
           src/test_framework/xmltest/FilesIndexingTests.cpp \
           src/test_framework/xmltest/RemovePartFromSequenceTests.cpp \
           src/test_framework/xmltest/SequenceWalkerTests.cpp \
           src/test_framework/xmltest/TaskTests.cpp \
           src/test_framework/xmltest/XMLTestFormat.cpp \
           src/test_framework/xmltest/XMLTestUtils.cpp
RESOURCES += core.qrc
TRANSLATIONS += transl/english.ts transl/russian.ts
