/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SW_RESULT_FILTER_REGISTRY_H_
#define _GB2_SW_RESULT_FILTER_REGISTRY_H_

#include <QList>
#include <QString>
#include <QStringList>

#include <QMutex>

#include <util_smith_waterman/SmithWatermanResultFilters.h>

namespace GB2 {

struct NamedSWResultFilter {
    NamedSWResultFilter():
        id_filter(""), filter(0) 
    {}
    
    QString id_filter;
    SmithWatermanResultFilter* filter;
};

class GB2_COREAPI_EXPORT SWResultFilterRegistry: public QObject {
    Q_OBJECT
public:
    SWResultFilterRegistry(QObject* pOwn = 0);
    ~SWResultFilterRegistry();
    
    QStringList getFiltersNames() const;
    SmithWatermanResultFilter* getFilterByName(const QString& id_filter);
    bool hadRegistered(const QString& id_filter);
    bool registerFilter(SmithWatermanResultFilter* filter, 
                        const QString& id_filter);
private:

    QList<NamedSWResultFilter>::iterator findFilter(const QString& id_filter);

    QList<NamedSWResultFilter> filter_list;

    QMutex mutex;
};

} // namespace

#endif
