/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_LOG_SETTINGS_H_
#define _GB2_LOG_SETTINGS_H_

#include <core_api/Log.h>
#include <core_api/AppContext.h>

#include <QtCore/QHash>

namespace GB2 {

struct GB2_COREAPI_EXPORT LogCategorySettings {
    LogCategorySettings() { 
        std::fill(activeLevelFlag, activeLevelFlag + LogLevel_NumLevels, 0);
    }

    bool operator==(const LogCategorySettings& other) const {
        return categoryName == other.categoryName && activeLevelFlag == other.activeLevelFlag;
    }

    QString categoryName;
    bool    activeLevelFlag[LogLevel_NumLevels];
    
};

class GB2_COREAPI_EXPORT LogCategories : QObject {
    Q_OBJECT
public:
    static void init();
    static const QString getLocalizedLevelName(LogLevel l) {return localizedLevelNames[l];}
protected:
    static QString localizedLevelNames[LogLevel_NumLevels];
};

class GB2_COREAPI_EXPORT LogSettings {
public:
    LogSettings();
    
    void removeCategory(const QString& name);

    void addCategory(const LogCategorySettings& newcs);

    const LogCategorySettings& getLogCategorySettings(const QString& cName);

    const QHash<QString, LogCategorySettings> getLogCategorySettings() const {return categories;}

    bool operator==(const LogSettings& other) const;
        
    void save();
    
    void reinitAll();   
    void reinitCategories();
    
    QString levelColors[LogLevel_NumLevels];
    bool    activeLevelGlobalFlag[LogLevel_NumLevels];

    bool showDate;
    bool showLevel;
    bool showCategory;

private:
    QHash<QString, LogCategorySettings> categories;
};

} //namespace

#endif
