/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef __SYNC_HTTP_H__
#define __SYNC_HTTP_H__

#include <QtNetwork/QHttp>
#include <QtCore/QEventLoop>
#include <QtCore/QBuffer>

#include <core_api/core_api.h>

namespace GB2 {

class GB2_COREAPI_EXPORT SyncHTTP : public QHttp {
    Q_OBJECT
public:
    SyncHTTP(const QString& hostName, quint16 port=80, QObject* parent=0);
    QString syncGet(const QString& path);
    QString syncPost(const QString & path, QIODevice * data);
protected slots:
    virtual void finished(int idx, bool err);

private:
    int requestID;
    QEventLoop loop;
};

} //Gb2

#endif
