/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ALIGNMENT_SUPPORT_H_
#define _GB2_ALIGNMENT_SUPPORT_H_

#include <core_api/core_api.h>
#include <core_api/LRegion.h>

#include <QtCore/QList>
#include <QtGui/QAction>

namespace GB2 {

class AnnotatedDNAView;
class AnnotationSelection;
class Annotation;
class GObjectView;
class MAlignment;
class LRegionsSelection;
class ADVSequenceObjectContext;

class GB2_COREAPI_EXPORT ADVAlignmentSupport: public QObject {
    Q_OBJECT
public:
    ADVAlignmentSupport(AnnotatedDNAView* v);

private slots:
    void sl_annotationsToAlignment();
    void sl_sequenceToAlignment();
    void sl_sequenceToAlignmentWithTranslation();
	void sl_onAnnotationSelectionChanged(AnnotationSelection*, const QList<Annotation*>& added, const QList<Annotation*>& removed);
    void sl_onSequenceSelectionChanged(LRegionsSelection* thiz, const QList<LRegion>& added, const QList<LRegion>& removed);
    
    void sl_onSequenceContextAdded(ADVSequenceObjectContext* c);
    void sl_onSequenceContextRemoved(ADVSequenceObjectContext* c);
    
    void sl_buildPopupMenu(GObjectView* v, QMenu* menu);
    void sl_buildStaticMenu(GObjectView* v, QMenu* tb);


private:
    void updateActions();
    QString prepareMAFromAnnotations(MAlignment& al);
    QString prepareMAFromSequences(MAlignment& al, bool translate);
    void selectionToAlignment(bool annotations, bool translate);

    AnnotatedDNAView*   ctx;
    QAction*            annotationsToAlignmentAction;
    QAction*            seqSelectionToAliAction;
    QAction*            seqSelectionToAliWithTranslationAction;
};



} // namespace



#endif
