/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ANNOTATED_DNA_VIEW_H_
#define _GB2_ANNOTATED_DNA_VIEW_H_

#include <core_api/ObjectViewModel.h>

#include <QtCore/QPointer>
#include <QtGui/QTextEdit>
#include <QtGui/QSplitter>

class QScrollArea;
class QVBoxLayout;

namespace GB2 {

class AnnotatedDNAView;
class AnnotatedDNAViewState;
class DNASequenceObject;
class AnnotationTableObject;
class GSequenceLineView;
class AnnotationsTreeView;
class AnnotationSelection;
class AnnotationGroupSelection;
class DNASequenceSelection;
class Task;
class ADVClipboard;
class ADVAlignmentSupport;
class ADVSequenceWidget;
class ADVSplitWidget;
class ADVSequenceObjectContext;
class PositionSelector;
class GObjectReference;
class ADVSyncViewManager;
class ADVObjectHandler;
class ADVGlobalAction;

class GB2_COREAPI_EXPORT AnnotatedDNAView : public GObjectView {
    Q_OBJECT
public:
    AnnotatedDNAView(const QString& viewName, const QList<DNASequenceObject*>& dnaObjects);
    ~AnnotatedDNAView();

    virtual void buildStaticToolbar(QToolBar* tb);

    virtual void buildStaticMenu(QMenu* n);

    virtual Task* updateViewTask(const QString& stateName, const QVariantMap& stateData);

    virtual QVariantMap saveState();
    
    
    
    // view content
    const QList<ADVSequenceObjectContext*>& getSequenceContexts() const {return seqContexts;}

    QList<DNASequenceObject*> getSequenceObjectsWithContexts() const;
    
    QList<GObject*> getSequenceGObjectsWithContexts() const;

    const QList<AnnotationTableObject*>& getAnnotationObjects() const {return annotations;}

    AnnotationSelection*        getAnnotationsSelection() const {return annotationSelection;}
    
    AnnotationGroupSelection*   getAnnotationsGroupSelection() const {return annotationGroupSelection;}

    const QList<ADVSequenceWidget*> getSequenceWidgets() const {return seqViews;}

    virtual bool canAddObject(GObject* obj);

    void addSequenceWidget(ADVSequenceWidget* v);

    void removeSequenceWidget(ADVSequenceWidget* v);

    void insertWidgetIntoSplitter(ADVSplitWidget* widget);

    void unregisterSplitWidget(ADVSplitWidget* widget);
    
    virtual QString addObject(GObject* o);

    void saveWidgetState();

    ADVSequenceObjectContext* getSequenceContext(AnnotationTableObject* obj) const;

    ADVSequenceObjectContext* getSequenceContext(DNASequenceObject*) const;
    
    ADVSequenceObjectContext* getSequenceContext(const GObjectReference& r) const;

    QWidget* getScrolledWidget() const {return scrolledWidget;}

    ADVSequenceWidget* getSequenceWidgetInFocus() const {return focusedWidget;}

    ADVSequenceObjectContext* getSequenceInFocus() const;

    QList<ADVSequenceObjectContext*> getAllSeqContextsInFocus() const;

    QList<ADVSequenceObjectContext*> findRelatedSequenceContexts(GObject* obj) const;

    void setFocusedSequenceWidget(ADVSequenceWidget* v);

    void updateState(const AnnotatedDNAViewState& s);

    QAction* getCreateAnnotationAction() const {return createAnnotationAction;}
    
    void addADVAction(ADVGlobalAction* a);
    
    void removeADVAction(ADVGlobalAction* a) {advActions.removeAll(a);} 

    AnnotationsTreeView* getAnnotationsView() {return annotationsView;}

protected:
    virtual QWidget* createWidget();
    virtual bool onObjectRemoved(GObject* o);
    virtual bool eventFilter(QObject*, QEvent*);
    virtual void timerEvent(QTimerEvent *e);
    
    virtual bool isChildWidgetObject(GObject* o) const;
    virtual void addAnalyseMenu(QMenu* m);
    virtual void addAddMenu(QMenu* m);
    virtual void addExportMenu(QMenu* m);
    virtual void addRemoveMenu(QMenu* m);
    virtual void addEditMenu(QMenu* m);
    virtual ADVSequenceWidget* findSequenceWidgetByPos(const QPoint& globalPos) const;

signals:
    void si_sequenceAdded(ADVSequenceObjectContext* c);
    void si_sequenceRemoved(ADVSequenceObjectContext* c);

    void si_annotationObjectAdded(AnnotationTableObject* obj);
    void si_annotationObjectRemoved(AnnotationTableObject* obj);

    void si_sequenceWidgetAdded(ADVSequenceWidget* w);
    void si_sequenceWidgetRemoved(ADVSequenceWidget* w);

    void si_focusChanged(ADVSequenceWidget*, ADVSequenceWidget*);
   
private slots:
    void sl_onContextMenuRequested(const QPoint & pos);
    void sl_onFindDialog();
    void sl_onAnnotationSettings();
    void sl_onPosChangeRequest(int pos);
    void sl_onShowPosSelectorRequest();
    void sl_toggleHL();
    void sl_splitterMoved(int, int);

    void sl_addSequencePart();
    void sl_removeSequencePart();
    
    virtual void sl_onDocumentAdded(Document*);
    virtual void sl_onDocumentLoadedStateChanged();

private:
    void updateScrollAreaHeight();
    void updateMultiViewActions();

    void addRelatedAnnotations(ADVSequenceObjectContext* seqCtx);
    void importDocAnnotations(Document* doc);
    QString tryAddObject(GObject* obj);

    QSplitter*          mainSplitter;
    QScrollArea*        scrollArea;
    QWidget*            scrolledWidget;
    QVBoxLayout*        scrolledWidgetLayout;
    
    QAction*            createAnnotationAction;
    QAction*            findDialogAction;
    QAction*            annotationSettingsAction;
    QAction*            posSelectorAction;
    QAction*            toggleHLAction;
    QAction*            posSelectorWidgetAction;

    QAction*            addSequencePart;
    QAction*            removeSequencePart;
    
    PositionSelector*   posSelector;


    QList<ADVSequenceObjectContext*>    seqContexts;
    QList<AnnotationTableObject*>       annotations;
    QList<ADVObjectHandler*>            handlers; 
    QList<ADVGlobalAction*>             advActions;

    AnnotationsTreeView*        annotationsView;
    QList<ADVSequenceWidget*>   seqViews;
    QList<ADVSplitWidget*>      splitWidgets;

    AnnotationSelection *       annotationSelection;
    AnnotationGroupSelection *  annotationGroupSelection;
    
    ADVClipboard*               clipb;
    ADVAlignmentSupport*        aliSupport;
    ADVSyncViewManager*         syncViewManager;

    ADVSequenceWidget*          focusedWidget;
    
    int                         timerId;
};

}//namespace;

#endif
