/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_
#define _GB2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_

#include "ui/ui_EditAnnotationDialog.h"

#include <core_api/LRegion.h>
#include <gobjects/AnnotationTableObject.h>

namespace GB2{

class GB2_COREAPI_EXPORT EditAnnotationDialogController : public QDialog, public Ui_EditAnnotationDialog {
    Q_OBJECT
public:
    EditAnnotationDialogController(Annotation* a, QWidget* p = NULL);

    virtual void accept ();

    QList<LRegion> getRegionList(){return currentRegionList;};
    QString getName(){return currentName;};
    bool isCompliment(){return compliment;};

private slots:
    void sl_onTextChanged(const QString&);
    void sl_setPredefinedAnnotationName();
    void sl_complementLocation();

private:
    QMenu* createAnnotationNamesMenu(QWidget* p, QObject* receiver);

    QList<LRegion> currentRegionList;
    QString currentName;
    bool compliment;
};

}//ns

#endif //_GB2_EDIT_ANNOTATION_DIALOG_CONTROLLER_H_
