/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <datatype/BioStruct3D.h>
#include <util_algorithm/GAutoDeleteList.h>
#include <util_gui/GUIUtils.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>
#include <util_ov_annotated_dna/ADVConstants.h>
#include <util_ov_annotated_dna/ADVSequenceObjectContext.h>
#include <util_ov_annotated_dna/ADVUtils.h>

#include "SecStructDialog.h"
#include "SecStructPredictUtils.h"


namespace GB2 {

SecStructPredictViewAction::SecStructPredictViewAction(AnnotatedDNAView* v) : 
    ADVGlobalAction(v, QIcon(":core//images//ssp_logo.png"),  tr("Predict secondary structure") ) 
{
    connect(this, SIGNAL(triggered()), SLOT(sl_execute()));
    addAlphabetFilter(DNAAlphabet_AMINO);

}


void SecStructPredictViewAction::sl_execute() {
    QAction* a = (QAction*)sender();
    GObjectViewAction* viewAction = qobject_cast<GObjectViewAction*>(a);
    AnnotatedDNAView* av = qobject_cast<AnnotatedDNAView*>(viewAction->getObjectView());
    Q_ASSERT(av);

    ADVSequenceObjectContext* seqCtx = av->getSequenceInFocus();
    Q_ASSERT(seqCtx->getAlphabet()->isAmino());
    
    //TODO: if no analysis algorithm is available?

    SecStructDialog secStructDialog(seqCtx, av->getWidget());
    secStructDialog.exec();

}

ADVGlobalAction* SecStructPredictViewAction::createAction( AnnotatedDNAView* av )
{
    ADVGlobalAction* action = new SecStructPredictViewAction(av);

    return action;

}

SecStructPredictViewAction::~SecStructPredictViewAction()
{

}


QString SecStructPredictUtils::getStructNameForCharTag( char tag )
{
    SecondaryStructure::Type type;
    switch(tag) {
        case 'H': 
            type = SecondaryStructure::Type_AlphaHelix;
            break;
        case 'G':
            type = SecondaryStructure::Type_310Helix;
            break;
        case 'I':
            type = SecondaryStructure::Type_PiHelix;
            break;
        case 'B':
            type = SecondaryStructure::Type_BetaBridge;
            break;
        case 'E':
            type = SecondaryStructure::Type_BetaStrand;
            break;
        case 'T':
            type = SecondaryStructure::Type_Turn;
            break;
        case 'S':
            type = SecondaryStructure::Type_BendRegion;
            break;
        default:
            Q_ASSERT(0);
    }

    return BioStruct3D::getSecStructTypeName(type);
}

QList<SharedAnnotationData> SecStructPredictUtils::saveAlgorithmResultsAsAnnotations( const QByteArray& predicted, const QString& annotationName )
{
    char emptyCoil = 'C';

    int numAcronyms = predicted.length();
    QList<SharedAnnotationData> predictedStructures;
    char prevChar = predicted.at(0);
    int lastRecordedPos = 0;
    for (int i = 1; i < numAcronyms; ++i) {
        char curChar = predicted.at(i);
        if ( (curChar != prevChar) || (i == numAcronyms - 1)) {
            if ( prevChar != emptyCoil ) {
                SharedAnnotationData sd( new AnnotationData);
                sd->name = annotationName;
                sd->location.append(LRegion(lastRecordedPos, i - lastRecordedPos));
                sd->qualifiers.append(Qualifier(BioStruct3D::SecStructTypeQualifierName, getStructNameForCharTag(prevChar)));
                predictedStructures.append(sd);
            }
            lastRecordedPos = i;
        } 
        prevChar = curChar;
    }

    return predictedStructures;  
}
} //namespace



