/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include "SmithWatermanResultFilters.h"
#include <QtAlgorithms>


namespace GB2 {

//greater score goes first
static bool revScoreComparator(const SmithWatermanResult &s0, const SmithWatermanResult &s1) {
    bool res = false;
    if (s0.score < s1.score) {
        res = false;
    } else if (s0.score == s1.score) {
        LRegion r0 = s0.region;
        LRegion r1 = s1.region;
        res = r0 < r1;
    } else {
        res = true;
    }
    return res;
}

// Without any filtering
bool SWRF_EmptyFilter::applyFilter(QList<SmithWatermanResult>* lst) {
    QList<SmithWatermanResult>& results = *lst;

    qSort(results.begin(), results.end(), revScoreComparator);
    
    int i = 0;
    int size = results.size();
    while (i < size) {
        int j = i + 1;
        while (j < size) {
            const SmithWatermanResult& currItem = results[i];
            const SmithWatermanResult& someItem = results[j];
            if (needErase(currItem, someItem)) {
                results.removeAt(j);
                size--;
                continue;
            }
            j++;
        }
        i++;
    }
    return true;
}
bool SWRF_EmptyFilter::needErase(
                        const SmithWatermanResult& currItem,
                        const SmithWatermanResult& someItem) const {
    const LRegion& currRegion = currItem.region;
    const LRegion& someRegion = someItem.region;
    
    if (currRegion.contains(someRegion) && 
        currItem.complement == someItem.complement) {
        return true;
    }
    return false;
}
//

// Filtering all intersects result
bool SWRF_WithoutIntersect::applyFilter(QList<SmithWatermanResult>* lst) {
    QList<SmithWatermanResult>& results = *lst;

    qSort(results.begin(), results.end(), revScoreComparator);
    
    int i = 0;
    int size = results.size();
    while (i < size) {
        int j = i + 1;
        while (j < size) {
            const SmithWatermanResult& currItem = results[i];
            const SmithWatermanResult& someItem = results[j];
            if (needErase(currItem, someItem)) {
                results.removeAt(j);
                size--;
                continue;
            }
            j++;
        }
        i++;
    }
    return true;
}
bool SWRF_WithoutIntersect::needErase(
                        const SmithWatermanResult& currItem,
                        const SmithWatermanResult& someItem) const {
    LRegion currRegion = currItem.region;
    LRegion someRegion = someItem.region;
    if (currRegion.intersects(someRegion) && 
        currItem.complement == someItem.complement) {
        return true;
    }
    return false;
}
//

// some other filters...

//

} // namesapce
