/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_SMITH_WATERMAN_SETTINGS_H_
#define _GB2_SMITH_WATERMAN_SETTINGS_H_

#include <core_api/LRegion.h>
#include <core_api/DNATranslation.h>

#include <util_smith_waterman/SubstMatrix.h>
#include <util_smith_waterman/SmithWatermanReportCallback.h>
#include <util_smith_waterman/SmithWatermanResultFilters.h>
#include <util_smith_waterman/SmithWatermanResult.h>

namespace GB2 {

enum SmithWatermanStrand {
	SmithWatermanStrand_NoStrand   = 0x00,
	SmithWatermanStrand_Direct     = 0x01,
	SmithWatermanStrand_Complement = 0x02,
	SmithWatermanStrand_Both       = (SmithWatermanStrand_Direct | 
                                      SmithWatermanStrand_Complement)
};

static inline bool isComplement(SmithWatermanStrand strand) { 
	return 0 != (SmithWatermanStrand_Complement & strand);
}
static inline bool isDirect(SmithWatermanStrand strand) {
	return 0 != (SmithWatermanStrand_Direct & strand);
}

struct GapModel {		
	float scoreGapOpen;
	float scoreGapExtd;
};

struct SmithWatermanSettings {
	QByteArray ptrn;
	QByteArray sqnc;

	LRegion	globalRegion;
	SmithWatermanStrand strand;

    float percentOfScore;	
	GapModel gapModel;
	const SubstMatrix* pSm;
	
    DNATranslation* complTT;
    DNATranslation* aminoTT;
	
	SmithWatermanResultListener* resultListener;
    SmithWatermanResultFilter*   resultFilter;
    SmithWatermanReportCallback* resultCallback;
};

} // namespace

#endif
