/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_ADD_PART_TO_SEQUENCE_TASK_H_
#define _GB2_ADD_PART_TO_SEQUENCE_TASK_H_

#include <core_api/Task.h>
#include <core_api/DocumentModel.h>
#include <gobjects/DNASequenceObject.h>
#include <util_ov_annotated_dna/AnnotatedDNAView.h>

namespace GB2 {

class GB2_COREAPI_EXPORT AddPartToSequenceTask : public Task {
    Q_OBJECT
public:
    enum AnnotationStrategyForAdd {
        AnnotationStrategyForAdd_Resize, 
        AnnotationStrategyForAdd_Remove, 
        AnnotationStrategyForAdd_Split
    };
    AddPartToSequenceTask(DocumentFormatId _df, DNASequenceObject *_seqObj, int _insertPos, 
        DNASequence _seqPart, AnnotationStrategyForAdd _strat = AnnotationStrategyForAdd_Resize, QString _url = QString(), bool _mergeAnnotations = false);
    Task::ReportResult report();
private:

    void fixAnnotations();
    void preparationForSave();

    DocumentFormatId dfId;
    bool mergeAnnotations;
    Document *curDoc;
    Document *newDoc;  
    bool save;
    QString url;
    AnnotationStrategyForAdd strat;
    QList<Document*> docs;
    DNASequenceObject *seqObj;
    int insertPos;
    DNASequence seqPart;
};

}//ns

#endif
