/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#include <QtCore/QString>
#include <QtCore/QByteArray>
#include <memory>
#include <core_api/IOAdapter.h>
#include "CopyDataTask.h"

namespace GB2
{

CopyDataTask::CopyDataTask( IOAdapterFactory * io_f_, QString url_f_, IOAdapterFactory * io_w_, QString url_w_ ) :
Task(tr("copy_data_task_name"), TaskFlag_None), io_f(io_f_), io_w(io_w_),
url_f(url_f_), url_w(url_w_)
{
    tpm = Progress_Manual;
}

void CopyDataTask::run()
{
    assert( io_f && io_w );
    std::auto_ptr<IOAdapter> from( io_f->createIOAdapter() );
    std::auto_ptr<IOAdapter> wheree( io_w->createIOAdapter() );
    from->open( url_f, IOAdapterMode_Read );
    wheree->open( url_w, IOAdapterMode_Write );
    if( !from->isOpen() || !wheree->isOpen() ) {
        stateInfo.setError(stateInfo.getError()+tr("cannot_open_io_adapter"));
        return;
    }

    qint64 count = 0;
    qint64 count_w = 0;
    QByteArray buff( BUFFSIZE, 0 );

    
    count = from->readBlock( buff.data(), BUFFSIZE );
    if (count == 0) {
        stateInfo.setError(tr("no data in the source"));
        return;
    }
    while( count > 0 ) {
        count_w = wheree->writeBlock( buff.data(), count );
        if( stateInfo.cancelFlag ) {
            break;
        }
        stateInfo.progress = from->getProgress();
        count = from->readBlock( buff.data(), BUFFSIZE );
    }
    if( count < 0 || count_w < 0 ) {
        stateInfo.setError(stateInfo.getError() + tr("io_adapter_error"));
    }
}

}// namespace
