/*****************************************************************
* Unipro UGENE - Integrated Bioinformatics Suite
* Copyright (C) 2008,2009 Unipro, Russia (http://ugene.unipro.ru)
* All Rights Reserved
* 
*     This source code is distributed under the terms of the
*     GNU General Public License. See the files COPYING and LICENSE
*     for details.
*****************************************************************/

#ifndef _GB2_WORKFLOW_ATTR_H_
#define _GB2_WORKFLOW_ATTR_H_

#include <workflow/Datatype.h>
#include <workflow/Descriptor.h>

#include <QtCore/QVariant>

namespace GB2 {

typedef QString ActorId;
inline ActorId str2aid(const QString& s) {return s;}

class ConfigurationEditor;
class ConfigurationValidator;

class WCOREAPI_EXPORT Attribute : public Descriptor {
public:
    Attribute(const Descriptor& d, const DataTypePtr type, bool required = false, QVariant defValue = QVariant()):
      Descriptor(d), type(type), value(defValue), required(required){}
      const DataTypePtr type;
      QVariant value;
      bool required;
};

class WCOREAPI_EXPORT Configuration {
public:
    Configuration() : editor(NULL), validator(NULL) {}
    virtual ~Configuration();
    virtual QMap<QString, Attribute*> getParameters() const {return params;}
    virtual Attribute* getParameter(const QString& name) const {return params.value(name);}
    virtual void setParameter(const QString& name, const QVariant& val) {
        if (params.contains(name)) {
            params[name]->value = val;
        }
    }
    void setParameters(const QVariantMap&);
    virtual ConfigurationEditor* getEditor() {return editor;}
    void setEditor(ConfigurationEditor* ed) {editor = ed;}
    virtual ConfigurationValidator* getValidator() {return validator;}
    void setValidator(ConfigurationValidator* v) {validator = v;}

    virtual bool validate(QStringList&) const;
    virtual void remap(const QMap<ActorId, ActorId>&) {}
protected:
    QMap<QString, Attribute*> params;
    ConfigurationEditor* editor;
    ConfigurationValidator* validator;
};

class WCOREAPI_EXPORT ConfigurationValidator {
public:
    virtual ~ConfigurationValidator() { }
    virtual bool validate(const Configuration*, QStringList& output) const = 0;
};

}//GB2 namespace

#endif
